/*
 *  Copyright 2018 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.plugins;

import jmms.devtools.CliCommander;
import jmms.devtools.CliCommands;
import leap.lang.Strings;

import java.util.Map;

public class SwaggerCliCommands implements CliCommands {

    @Override
    public void register(CliCommander commander) {
        commander.command("swagger.docGen", Map.class, false, this::docGen);
    }

    public void docGen(Map<String, Object> params) throws Exception {
        String dir = (String)params.get("dir");
        SwaggerDoc doc = Strings.isEmpty(dir) ? new SwaggerDoc() : new SwaggerDoc(dir);
        if(!doc.hasSwagger()) {
            throw new IllegalArgumentException("File 'swagger.json' not exists at dir '" + doc.getDir() + "'");
        }
        doc.gen();
    }
}
