/*
 * Copyright 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package jmms.plugins;

import jmms.core.Api;
import jmms.engine.Plugin;
import jmms.engine.PluginContext;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;

public class SwaggerDocPlugin implements Plugin {
    private static final Log log = LogFactory.get(SwaggerDocPlugin.class);

    private SwaggerDoc doc;

    @Override
    public boolean isDefaultEnabled() {
        return true;
    }

    @Override
    public void init(PluginContext context) {
        doc = new SwaggerDoc();
        doc.init();
    }

    @Override
    public void destroy(PluginContext context) {
        if(null != doc) {
            doc.close();
        }
    }

    @Override
    public void postDeployApi(Api api) {
        if(doc.hasSwagger()) {
            doc.gen();
        }else {
            doc.gen(api.getSwagger());
        }
    }

}