/*
 * Copyright 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package leap.oauth2.webapp.token;

import leap.core.security.UserPrincipal;
import leap.lang.expirable.TimeExpirableSeconds;

public class SimpleTokenInfo extends TimeExpirableSeconds implements TokenInfo {

    protected String        clientId;
    protected String        userId;
    protected String        scope;
    protected UserPrincipal userInfo;

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public UserPrincipal getUserInfo() {
        return userInfo;
    }

    public void setUserInfo(UserPrincipal userInfo) {
        this.userInfo = userInfo;
    }
}
