/*
 * Decompiled with CFR 0.152.
 */
package leap.spring.boot;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import leap.core.BeanFactorySupport;
import leap.lang.Strings;
import leap.lang.beans.BeanException;
import leap.spring.boot.Global;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

public class LeapBeanSupport
implements BeanFactorySupport {
    private static final ThreadLocal<Boolean> disabled = ThreadLocal.withInitial(() -> false);

    static void disable() {
        disabled.set(true);
    }

    static void enable() {
        disabled.set(false);
    }

    public <T> T tryGetBean(String id) throws BeanException {
        if (Global.context == null) {
            return null;
        }
        try {
            return (T)this.shouldReturn(Global.context.getBean(id));
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public <T> T tryGetBean(Class<T> type) throws BeanException {
        if (Global.context == null) {
            return null;
        }
        if (type == ApplicationContext.class) {
            return (T)Global.context;
        }
        if (type == BeanFactory.class || type == DefaultListableBeanFactory.class || type == AutowireCapableBeanFactory.class) {
            return (T)((AbstractApplicationContext)Global.context).getBeanFactory();
        }
        try {
            return (T)this.shouldReturn(Global.context.getBean(type));
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public <T> T tryGetBean(Class<? super T> type, String name) throws BeanException {
        if (Global.context == null) {
            return null;
        }
        Map<String, T> beans = this.getNamedBeans(type);
        if (null == beans || beans.isEmpty()) {
            return null;
        }
        T bean = beans.get(name);
        if (null == bean) {
            return null;
        }
        return this.shouldReturn(bean);
    }

    public <T> Map<String, T> getNamedBeans(Class<? super T> type) {
        if (Global.context == null) {
            return null;
        }
        Map namedBeans = Global.context.getBeansOfType(type);
        if (namedBeans == null || namedBeans.isEmpty()) {
            return namedBeans;
        }
        String suffix = type.getSimpleName();
        LinkedHashMap beans = new LinkedHashMap();
        namedBeans.forEach((name, bean) -> {
            if (this.shouldReturn(bean) != null) {
                name = Strings.removeEnd((String)name, (String)suffix);
                beans.put(name, bean);
            }
        });
        return beans;
    }

    public <T> List<T> getBeans(Class<T> type) {
        if (Global.context == null) {
            return null;
        }
        Map namedBeans = Global.context.getBeansOfType(type);
        if (namedBeans == null || namedBeans.isEmpty()) {
            return null;
        }
        ArrayList beans = new ArrayList();
        for (Object bean : namedBeans.values()) {
            if (this.shouldReturn(bean) == null) continue;
            beans.add(bean);
        }
        return beans;
    }

    protected <T> T shouldReturn(T bean) {
        if (bean.getClass().isAnnotationPresent(Ignore.class)) {
            return null;
        }
        return bean;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Ignore {
    }
}

