/*
 * Decompiled with CFR 0.152.
 */
package leap.spring.boot;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import leap.core.AppConfigSupport;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.spring.boot.Global;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class LeapConfigSupport
implements AppConfigSupport {
    private static final Log log = LogFactory.get(LeapConfigSupport.class);
    static ThreadLocal<Boolean> skip = new ThreadLocal();

    public Set<String> getPropertyNames() {
        if (Global.context == null) {
            return Collections.EMPTY_SET;
        }
        Environment env = Global.context.getEnvironment();
        if (null == env || !(env instanceof ConfigurableEnvironment)) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> names = new HashSet<String>();
        for (PropertySource propertySource : ((ConfigurableEnvironment)env).getPropertySources()) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            for (String key : ((EnumerablePropertySource)propertySource).getPropertyNames()) {
                names.add(key);
            }
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String name) {
        if (Global.context == null) {
            return null;
        }
        Environment env = Global.context.getEnvironment();
        if (null == env) {
            return null;
        }
        if (null != skip.get()) {
            return null;
        }
        skip.set(Boolean.TRUE);
        try {
            String string = env.getProperty(name);
            return string;
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().contains("Could not resolve placeholder")) {
                log.info("Unable get property '{}' : {}", new Object[]{name, e.getMessage()});
            } else {
                log.warn("Error get property '{}' : {}", new Object[]{name, e.getMessage()});
            }
            String string = null;
            return string;
        }
        finally {
            skip.remove();
        }
    }
}

