/*
 * Decompiled with CFR 0.152.
 */
package leap.spring.boot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import leap.lang.Exceptions;
import leap.lang.resource.AbstractResource;
import leap.lang.resource.Resource;
import org.springframework.core.io.ClassPathResource;

public class LeapResource
extends AbstractResource
implements Resource {
    private final org.springframework.core.io.Resource wrapped;

    public LeapResource(org.springframework.core.io.Resource wrapped) {
        this.wrapped = wrapped;
    }

    public boolean exists() {
        return this.wrapped.exists();
    }

    public long contentLength() throws IOException {
        return this.wrapped.contentLength();
    }

    public long lastModified() throws IOException {
        return this.wrapped.lastModified();
    }

    public boolean isReadable() {
        return this.wrapped.isReadable();
    }

    public boolean isOpen() {
        return this.wrapped.isOpen();
    }

    public boolean isFile() {
        try {
            File file = this.wrapped.getFile();
            return null != file;
        }
        catch (IOException e) {
            return false;
        }
    }

    public File getFile() {
        try {
            return this.wrapped.getFile();
        }
        catch (IOException e) {
            throw Exceptions.wrap((IOException)e);
        }
    }

    public String getFilename() {
        return this.wrapped.getFilename();
    }

    public URL getURL() throws IOException {
        return this.wrapped.getURL();
    }

    public String getClasspath() {
        if (this.wrapped instanceof ClassPathResource) {
            return ((ClassPathResource)this.wrapped).getPath();
        }
        return null;
    }

    public Resource createRelative(String relativePath) throws IOException {
        return new LeapResource(this.wrapped.createRelative(relativePath));
    }

    public String getDescription() {
        return this.wrapped.getDescription();
    }

    public InputStream getInputStream() throws IOException {
        return this.wrapped.getInputStream();
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

