/*
 * Decompiled with CFR 0.152.
 */
package leap.spring.boot;

import leap.core.transaction.AbstractTransaction;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

class LeapTransaction
extends AbstractTransaction {
    private final PlatformTransactionManager manager;
    private final TransactionStatus status;

    LeapTransaction(PlatformTransactionManager manager, TransactionStatus status) {
        this.manager = manager;
        this.status = status;
    }

    public boolean isNewTransaction() {
        return this.status.isNewTransaction();
    }

    public boolean isRollbackOnly() {
        return this.status.isRollbackOnly();
    }

    public boolean isCompleted() {
        return this.status.isCompleted();
    }

    public void setRollbackOnly() throws IllegalStateException {
        this.status.setRollbackOnly();
    }

    public void complete() throws IllegalStateException {
        if (this.status.isRollbackOnly()) {
            this.manager.rollback(this.status);
        } else {
            this.manager.commit(this.status);
        }
    }

    protected AbstractTransaction begin() {
        return super.begin();
    }
}

