/*
 * Decompiled with CFR 0.152.
 */
package leap.spring.boot;

import java.sql.Connection;
import javax.sql.DataSource;
import leap.core.transaction.AbstractTransaction;
import leap.core.transaction.AbstractTransactionProvider;
import leap.core.transaction.Transaction;
import leap.core.transaction.TransactionProvider;
import leap.lang.Try;
import leap.spring.boot.LeapTransaction;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class LeapTransactionProvider
extends AbstractTransactionProvider
implements TransactionProvider {
    private static final DefaultTransactionDefinition REQUIRED = new DefaultTransactionDefinition(0);
    private static final DefaultTransactionDefinition REQUIRES_NEW = new DefaultTransactionDefinition(3);
    private final PlatformTransactionManager txm;
    private final DataSource dataSource;

    public LeapTransactionProvider(PlatformTransactionManager txm, DataSource dataSource) {
        this.txm = txm;
        this.dataSource = dataSource;
    }

    public Transaction beginTransaction() {
        return this.beginTransaction(null);
    }

    public Transaction beginTransaction(leap.core.transaction.TransactionDefinition td) {
        DefaultTransactionDefinition std = this.convert(td);
        TransactionStatus ts = this.txm.getTransaction((TransactionDefinition)std);
        return new LeapTransaction(this.txm, ts).begin();
    }

    protected Connection getConnection() {
        return DataSourceUtils.getConnection((DataSource)this.dataSource);
    }

    protected void closeConnection(Connection connection) {
        if (null != connection) {
            Try.catchAll(() -> DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource));
        }
    }

    protected AbstractTransaction getTransaction(boolean requiresNew) {
        return this.getTransaction(requiresNew ? REQUIRES_NEW : REQUIRED);
    }

    protected AbstractTransaction getTransaction(leap.core.transaction.TransactionDefinition td) {
        return this.getTransaction(this.convert(td));
    }

    private AbstractTransaction getTransaction(DefaultTransactionDefinition td) {
        TransactionStatus ts = this.txm.getTransaction((TransactionDefinition)td);
        return new LeapTransaction(this.txm, ts);
    }

    private DefaultTransactionDefinition convert(leap.core.transaction.TransactionDefinition td) {
        DefaultTransactionDefinition std;
        if (null == td) {
            std = new DefaultTransactionDefinition();
            std.setPropagationBehavior(td.getPropagation().getValue());
            std.setIsolationLevel(td.getIsolation().getValue());
        } else {
            std = new DefaultTransactionDefinition();
        }
        return std;
    }
}

