/*
 * Decompiled with CFR 0.152.
 */
package leap.spring.boot;

import javax.sql.DataSource;
import leap.core.transaction.LocalTransactionProviderFactory;
import leap.core.transaction.TransactionProvider;
import leap.core.transaction.TransactionProviderFactory;
import leap.lang.annotation.Init;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.spring.boot.Global;
import leap.spring.boot.LeapTransactionProvider;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.transaction.PlatformTransactionManager;

public class LeapTransactionProviderFactory
extends LocalTransactionProviderFactory
implements TransactionProviderFactory {
    private static final Log log = LogFactory.get(LeapTransactionProviderFactory.class);
    private PlatformTransactionManager txm;

    @Init
    private void init() {
        if (null == Global.context()) {
            return;
        }
        try {
            this.txm = (PlatformTransactionManager)Global.context.getBean(PlatformTransactionManager.class);
            log.info("Spring PlatformTransactionManager found, use it");
        }
        catch (NoSuchBeanDefinitionException e) {
            log.info("Spring PlatformTransactionManager not found, use local");
        }
    }

    public TransactionProvider getTransactionProvider(DataSource dataSource, String name) {
        if (null == this.txm) {
            return super.getTransactionProvider(dataSource, name);
        }
        return new LeapTransactionProvider(this.txm, dataSource);
    }
}

