/*
 * Decompiled with CFR 0.152.
 */
package leap.spring.boot;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import leap.lang.Classes;
import leap.lang.Objects2;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.spring.boot.Global;
import leap.spring.boot.LeapBeanSupport;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AutowireCandidateResolver;

final class SpringAutowireResolver
implements AutowireCandidateResolver {
    private static final Log log = LogFactory.get(SpringAutowireResolver.class);
    private final AutowireCandidateResolver original;
    private boolean starting;
    private boolean started;

    public SpringAutowireResolver(AutowireCandidateResolver original) {
        this.original = original;
    }

    public boolean isAutowireCandidate(BeanDefinitionHolder bdHolder, DependencyDescriptor descriptor) {
        return null != this.original ? this.original.isAutowireCandidate(bdHolder, descriptor) : false;
    }

    public Object getLazyResolutionProxyIfNecessary(DependencyDescriptor descriptor, String beanName) {
        return null != this.original ? this.original.getLazyResolutionProxyIfNecessary(descriptor, beanName) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSuggestedValue(DependencyDescriptor descriptor) {
        Class type;
        Object bean;
        Object object = bean = null != this.original ? this.original.getSuggestedValue(descriptor) : null;
        if (null == bean && !(type = descriptor.getDependencyType()).getName().startsWith("org.springframework.")) {
            if (!this.started) {
                if (this.starting) {
                    return bean;
                }
                this.starting = true;
                Global.start();
                this.starting = false;
                this.started = true;
            }
            if (null != Global.factory()) {
                Type genericType = null;
                if (null != descriptor.getField()) {
                    genericType = descriptor.getField().getGenericType();
                } else if (null != descriptor.getMethodParameter()) {
                    genericType = descriptor.getMethodParameter().getGenericParameterType();
                }
                try {
                    LeapBeanSupport.disable();
                    Qualifier qualifier = (Qualifier)Classes.getAnnotation((Annotation[])descriptor.getAnnotations(), Qualifier.class);
                    if (null == qualifier) {
                        bean = Global.factory().resolveInjectValue(type, genericType);
                    } else {
                        if (Collection.class.isAssignableFrom(type) || type.isArray()) {
                            Object var6_6 = null;
                            return var6_6;
                        }
                        bean = Global.factory().resolveInjectValue(type, genericType, qualifier.value());
                    }
                    if (null != bean && Objects2.isEmpty((Object)bean)) {
                        bean = null;
                    }
                    if (null != bean) {
                        log.debug("Found leap managed bean of type '{}'", new Object[]{type});
                    } else {
                        log.debug("No leap managed bean of type '{}'", new Object[]{type});
                    }
                }
                finally {
                    LeapBeanSupport.enable();
                }
            }
        }
        return bean;
    }
}

