/*
 * Decompiled with CFR 0.152.
 */
package leap.spring.boot;

import leap.core.AppContextInitializer;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.lang.resource.Resource;
import leap.lang.resource.Resources;
import leap.spring.boot.SpringAutowireResolver;
import leap.spring.boot.SpringBeanPostProcessor;
import leap.spring.boot.SpringEnvPostProcessor;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SpringConfiguration {
    private static final Log log = LogFactory.get(SpringConfiguration.class);

    @Bean
    public static BeanFactoryPostProcessor beanFactoryPostProcessor() {
        return springBeanFactory -> {
            if (springBeanFactory instanceof DefaultListableBeanFactory) {
                DefaultListableBeanFactory dbf = (DefaultListableBeanFactory)springBeanFactory;
                dbf.setAutowireCandidateResolver((AutowireCandidateResolver)new SpringAutowireResolver(dbf.getAutowireCandidateResolver()));
            } else {
                log.error("Found unsupported spring bean factory '{}', can't autowire leap's beans", new Object[]{springBeanFactory});
            }
        };
    }

    @Bean
    public InstantiationAwareBeanPostProcessor beanPostProcessor() {
        return new SpringBeanPostProcessor();
    }

    @Bean
    public EnvironmentPostProcessor environmentPostProcessor() {
        return new SpringEnvPostProcessor();
    }

    static {
        boolean enabled = false;
        Resource resource = Resources.getResource((String)"classpath:instrument");
        if (null != resource && resource.exists() && "enabled".equals(resource.getContent())) {
            log.info("Instrument enabled by '{}'", new Object[]{resource.getURLString()});
            enabled = true;
        }
        if (!enabled) {
            AppContextInitializer.setInstrumentDisabled((boolean)true);
        }
    }
}

