/*
 * Decompiled with CFR 0.152.
 */
package leap.spring.boot;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import leap.lang.Arrays2;
import leap.lang.Strings;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.lang.path.Paths;
import leap.lang.resource.Resource;
import leap.lang.resource.Resources;
import leap.spring.boot.SpringPropertySource;
import leap.spring.boot.SpringResource;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.PropertiesPropertySourceLoader;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;

@Order(value=0)
public class SpringEnvPostProcessor
implements EnvironmentPostProcessor {
    private static final Log log = LogFactory.get(SpringEnvPostProcessor.class);

    public void postProcessEnvironment(ConfigurableEnvironment env, SpringApplication app) {
        this.addMetaPropertySources(env);
        log.debug("Add leap property source");
        env.getPropertySources().addLast((PropertySource)new SpringPropertySource("leap"));
    }

    private void addMetaPropertySources(ConfigurableEnvironment env) {
        List<Resource> resources = this.scanConfigurations(null, "classpath*:META-INF/");
        if (resources.isEmpty()) {
            return;
        }
        this.addPropertySources(env, resources);
    }

    private List<Resource> scanConfigurations(Resource root, String prefix) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.addAll(this.scanResources(root, prefix + "application.*"));
        resources.addAll(this.scanResources(root, prefix + "application-*.*"));
        return resources;
    }

    private List<Resource> scanResources(Resource root, String location) {
        return null == root ? Resources.scan((String)location).toList() : Resources.scan((Resource)root, (String)location).toList();
    }

    private void addPropertySources(ConfigurableEnvironment env, List<Resource> resources) {
        PropertiesPropertySourceLoader propLoader = new PropertiesPropertySourceLoader();
        YamlPropertySourceLoader yamlLoader = new YamlPropertySourceLoader();
        try {
            for (Resource resource : resources) {
                if (resource.getFilename().endsWith(".properties")) {
                    this.addPropertySource(env, resource, (PropertySourceLoader)propLoader, false);
                    log.info("Load properties '{}'", new Object[]{resource.getDescription()});
                    continue;
                }
                if (!resource.getFilename().endsWith("yml") && !resource.getFilename().endsWith("yaml")) continue;
                this.addPropertySource(env, resource, (PropertySourceLoader)yamlLoader, false);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    private void addPropertySource(ConfigurableEnvironment env, Resource resource, PropertySourceLoader loader, boolean frist) throws IOException {
        if (null == env.getActiveProfiles() || env.getActiveProfiles().length == 0) {
            this.addPropertySource(env, resource, loader, null, frist);
        } else {
            for (String profile : env.getActiveProfiles()) {
                this.addPropertySource(env, resource, loader, profile, frist);
            }
        }
    }

    private void addPropertySource(ConfigurableEnvironment env, Resource resource, PropertySourceLoader loader, String profile, boolean first) throws IOException {
        String profileOfFile;
        String filenameOnly;
        int index;
        if (null != profile && (index = (filenameOnly = Paths.getFileNameWithoutExtension((String)resource.getFilename())).lastIndexOf(45)) > 0 && !Strings.equals((String)(profileOfFile = filenameOnly.substring(index + 1)), (String)profile)) {
            return;
        }
        PropertySource propertySource = loader.load(resource.getDescription(), (org.springframework.core.io.Resource)new SpringResource(resource), null);
        if (null == propertySource) {
            return;
        }
        if (propertySource instanceof EnumerablePropertySource && Arrays2.isEmpty((Object[])((EnumerablePropertySource)propertySource).getPropertyNames())) {
            return;
        }
        log.info("Add property source '{}' with profile '{}'", new Object[]{resource.getDescription(), null == profile ? "" : profile});
        if (first) {
            env.getPropertySources().addFirst(propertySource);
        } else {
            env.getPropertySources().addLast(propertySource);
        }
    }
}

