/*
 * Decompiled with CFR 0.152.
 */
package leap.spring.boot;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import leap.lang.exception.NestedIOException;
import leap.lang.resource.Resource;
import org.springframework.core.io.AbstractResource;

public class SpringResource
extends AbstractResource
implements org.springframework.core.io.Resource {
    private final Resource wrapped;

    public SpringResource(Resource wrapped) {
        this.wrapped = wrapped;
    }

    public boolean exists() {
        return this.wrapped.exists();
    }

    public boolean isReadable() {
        return this.wrapped.isReadable();
    }

    public boolean isOpen() {
        return this.wrapped.isOpen();
    }

    public URL getURL() throws IOException {
        return this.wrapped.getURL();
    }

    public URI getURI() throws IOException {
        return this.wrapped.getURI();
    }

    public File getFile() throws IOException {
        try {
            File file = this.wrapped.getFile();
            if (null == file) {
                throw new FileNotFoundException("Resource '" + this.getDescription() + "' is not a file");
            }
            return file;
        }
        catch (NestedIOException e) {
            throw e.getIOException();
        }
    }

    public long contentLength() throws IOException {
        if (this.wrapped.isFile()) {
            return this.getFile().length();
        }
        return super.contentLength();
    }

    public long lastModified() throws IOException {
        return super.lastModified();
    }

    public org.springframework.core.io.Resource createRelative(String relativePath) throws IOException {
        return new SpringResource(this.wrapped.createRelative(relativePath));
    }

    public String getFilename() {
        return this.wrapped.getFilename();
    }

    public String getDescription() {
        return this.wrapped.getDescription();
    }

    public InputStream getInputStream() throws IOException {
        return this.wrapped.getInputStream();
    }
}

