/*
 * Decompiled with CFR 0.152.
 */
package leap.spring.boot;

import java.util.LinkedHashSet;
import java.util.Set;
import leap.core.config.Context;
import leap.lang.Classes;
import leap.lang.Collections2;
import leap.lang.Props;
import leap.lang.Strings;
import leap.lang.extension.ExProperties;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.lang.resource.Resource;
import leap.lang.resource.Resources;
import leap.spring.boot.Global;
import leap.spring.boot.LeapResourceLoader;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;

public class SpringRunListener
implements SpringApplicationRunListener {
    private static final Log log = LogFactory.get(SpringRunListener.class);

    public SpringRunListener(SpringApplication application, String[] args) {
        Object source;
        log.debug("Init run listener from main : {}", new Object[]{application.getMainApplicationClass()});
        LinkedHashSet<String> bps = new LinkedHashSet<String>();
        if (application.getSources().size() == 1 && (source = application.getSources().iterator().next()) instanceof Class) {
            Class c = (Class)source;
            Global.bp = Classes.getPackageName((Class)c);
            SpringRunListener.addBasePackages(bps, c);
        }
        if (null != application.getMainApplicationClass()) {
            Class mainClass = application.getMainApplicationClass();
            if (null == Global.bp) {
                Global.bp = Classes.getPackageName((Class)mainClass);
            }
            SpringRunListener.addBasePackages(bps, mainClass);
        }
        SpringRunListener.addBasePackagesFromConfigurations(bps);
        Global.bps = bps.toArray(new String[0]);
        log.info("Base package : {}", new Object[]{Global.bp});
    }

    public void starting() {
    }

    public void environmentPrepared(final ConfigurableEnvironment env) {
        log.debug("Env prepared");
        Global.env = env;
        String[] profiles = env.getActiveProfiles();
        if (null != profiles && profiles.length > 0) {
            Global.profile = profiles[0];
        }
        Context.get().setInitialProfileResolver(new Context.InitialProfileResolver(){

            public String[] getProfiles() {
                return env.getActiveProfiles();
            }

            public void setProfiles(String ... profiles) {
                env.setActiveProfiles(profiles);
                if (null != profiles && profiles.length > 0) {
                    Global.profile = profiles[0];
                }
            }
        });
        Context.get().setInitialPropertySource(name -> env.getProperty(name));
    }

    public void contextPrepared(ConfigurableApplicationContext context) {
        Resources.setResourceLoader((leap.lang.resource.ResourceLoader)new LeapResourceLoader((ResourceLoader)context));
    }

    public void contextLoaded(ConfigurableApplicationContext context) {
        Global.context = context;
    }

    public void finished(ConfigurableApplicationContext context, Throwable exception) {
    }

    private static void addBasePackages(Set<String> bps, EntityScan a) {
        if (null == a) {
            return;
        }
        Collections2.addAll(bps, (Object[])a.value());
        Collections2.addAll(bps, (Object[])a.basePackages());
        for (Class c : a.basePackageClasses()) {
            bps.add(ClassUtils.getPackageName((Class)c));
        }
    }

    private static void addBasePackages(Set<String> bps, ComponentScan a) {
        if (null == a) {
            return;
        }
        Collections2.addAll(bps, (Object[])a.value());
        Collections2.addAll(bps, (Object[])a.basePackages());
        for (Class c : a.basePackageClasses()) {
            bps.add(ClassUtils.getPackageName((Class)c));
        }
    }

    private static void addBasePackages(Set<String> bps, Class<?> c) {
        SpringRunListener.addBasePackages(bps, c.getAnnotation(EntityScan.class));
        SpringRunListener.addBasePackages(bps, c.getAnnotation(ComponentScan.class));
    }

    private static void addBasePackagesFromConfigurations(Set<String> bps) {
        String frameworkPackage = ClassUtils.getPackageName(SpringRunListener.class);
        for (Resource r : Resources.scan((String)"classpath*:META-INF/spring.factories")) {
            String[] classNames;
            ExProperties props;
            String prop;
            if (!r.exists() || Strings.isEmpty((String)(prop = (props = Props.load((Resource)r)).get((Object)"org.springframework.boot.autoconfigure.EnableAutoConfiguration")))) continue;
            for (String className : classNames = Strings.split((String)prop, (char)',')) {
                Class c;
                if (className.startsWith(frameworkPackage) || className.startsWith("org.springframework.") || null == (c = Classes.tryForName((String)className))) continue;
                bps.add(ClassUtils.getPackageName((Class)c));
                SpringRunListener.addBasePackages(bps, c);
            }
        }
    }
}

