/*
 * Decompiled with CFR 0.152.
 */
package leap.spring.boot.spel;

import java.util.Map;
import leap.core.annotation.Inject;
import leap.core.spring.ExpressionFactory;
import leap.core.variable.VariableEnvironment;
import leap.lang.annotation.Init;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.spring.boot.spel.SpringExpression;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.AccessException;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpringExpressionFactory
implements ExpressionFactory<Expression> {
    private static final Log log = LogFactory.get(SpringExpressionFactory.class);
    @Inject
    protected VariableEnvironment env;
    @Inject
    protected BeanFactory beanFactory;
    protected EnvPropertyAccessor envProperty;
    protected SpelExpressionParser spelParser;
    protected StandardEvaluationContext evalContext;

    @Init
    public void init() {
        if (null == this.beanFactory) {
            log.error("Spring context not found, can't use spring expression factory");
            return;
        }
        SpelParserConfiguration c = new SpelParserConfiguration(SpelCompilerMode.IMMEDIATE, this.getClass().getClassLoader());
        this.spelParser = new SpelExpressionParser(c);
        this.evalContext = new StandardEvaluationContext();
        this.envProperty = new EnvPropertyAccessor(this.env);
        this.evalContext.getPropertyAccessors().add(0, this.envProperty);
        this.evalContext.getPropertyAccessors().add(0, new MapPropertyAccessor());
        this.evalContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(this.beanFactory));
    }

    public leap.lang.expression.Expression createExpression(String expr) {
        return new SpringExpression(this.createSpringExpression(expr), (EvaluationContext)this.evalContext, this.envProperty);
    }

    public Expression createSpringExpression(String expr) {
        boolean template;
        int index = expr.indexOf("#{");
        if (index < 0) {
            template = false;
        } else if (index > 0) {
            template = true;
        } else if (index == 0 && expr.endsWith("}") && expr.indexOf("#{", 2) < 0) {
            template = false;
            expr = expr.substring(2, expr.length() - 1);
        } else {
            template = true;
        }
        return template ? this.spelParser.parseExpression(expr, ParserContext.TEMPLATE_EXPRESSION) : this.spelParser.parseExpression(expr);
    }

    protected static class MapPropertyAccessor
    implements PropertyAccessor {
        private static final Class<?>[] TARGET_CLASSES = new Class[]{Map.class};

        protected MapPropertyAccessor() {
        }

        public Class<?>[] getSpecificTargetClasses() {
            return TARGET_CLASSES;
        }

        public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
            return target instanceof Map;
        }

        public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
            Map map = (Map)target;
            Object value = map.containsKey(name) ? map.get(name) : this.getIgnoreCase(map, name);
            return null == value ? TypedValue.NULL : new TypedValue(value);
        }

        public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
            return target instanceof Map;
        }

        public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
            ((Map)target).put(name, newValue);
        }

        protected Object getIgnoreCase(Map<?, ?> map, String name) throws AccessException {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                Object key = entry.getKey();
                if (!(key instanceof String) || !name.equalsIgnoreCase((String)key)) continue;
                return entry.getValue();
            }
            throw new AccessException("The variable '" + name + "' not found");
        }
    }

    protected static class EnvPropertyAccessor
    implements PropertyAccessor {
        private static final Class<?>[] TARGET_CLASSES = new Class[]{EnvPropertyAccessor.class};
        private final VariableEnvironment env;

        public EnvPropertyAccessor(VariableEnvironment env) {
            this.env = env;
        }

        public Class<?>[] getSpecificTargetClasses() {
            return TARGET_CLASSES;
        }

        public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
            return this == target;
        }

        public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
            Object value = this.env.resolveVariable(name);
            if (null == value && !this.env.checkVariableExists(name)) {
                throw new AccessException("Environment variable 'env." + name + "' not exists!");
            }
            return null == value ? TypedValue.NULL : new TypedValue(value);
        }

        public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
            return false;
        }

        public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
            throw new AccessException("Can't write env variable");
        }
    }
}

