/*
 *
 *  * Copyright 2013 the original author or authors.
 *  *
 *  * Licensed under the Apache License, Version 2.0 (the "License");
 *  * you may not use this file except in compliance with the License.
 *  * You may obtain a copy of the License at
 *  *
 *  *      http://www.apache.org/licenses/LICENSE-2.0
 *  *
 *  * Unless required by applicable law or agreed to in writing, software
 *  * distributed under the License is distributed on an "AS IS" BASIS,
 *  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  * See the License for the specific language governing permissions and
 *  * limitations under the License.
 *  
 */

package leap.web;

import leap.lang.path.Paths;

/**
 * @author kael.
 * 
 * The server info object, contain schema, host, port of this servlet context.
 * 
 * will init when first request accept.
 * 
 * @see DefaultAppHandler
 * 
 */
public class ServerInfo {
    protected String scheme;
    protected String host;
    protected int port;
    protected String contextPath;

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getScheme() {
        return scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getContextPath() {
        return contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getServerUrl(){
        String server = scheme+"://"+host;
        if(port < 0){
            server += contextPath;
        }else {
            server += ":"+port+contextPath;
        }
        
        return Paths.suffixWithoutSlash(server);
    }
}
