/*
 * Copyright 2011 Király Attila
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package leap.web.captcha.cage;

/**
 * Object generator.
 * 
 * @param <T>
 *            the type of objects generated by this class
 * 
 * @author akiraly
 */
public interface IGenerator<T> {
	/**
	 * Returns an object with type <code>T</code> on every call. The returned
	 * object does not have to be a new instance.
	 * 
	 * @return generated object
	 */
	T next();
}
