/*
 * Decompiled with CFR 0.152.
 */
package org.librarysimplified.services.api;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.librarysimplified.services.api.ServiceDirectory;
import org.librarysimplified.services.api.ServiceDirectoryBuilderType;
import org.librarysimplified.services.api.ServiceDirectoryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u001c\u0010\u0002\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\u0002\u0010\u0007J3\u0010\u000b\u001a\u00020\u0001\"\b\b\u0000\u0010\f*\u00020\u00062\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u00040\u000e2\u0006\u0010\u000f\u001a\u0002H\fH\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0002\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/librarysimplified/services/api/ServiceDirectoryBuilder;", "Lorg/librarysimplified/services/api/ServiceDirectoryBuilderType;", "services", "", "Ljava/lang/Class;", "", "", "(Ljava/util/Map;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "addService", "T", "interfaces", "", "service", "(Ljava/util/List;Ljava/lang/Object;)Lorg/librarysimplified/services/api/ServiceDirectoryBuilderType;", "build", "Lorg/librarysimplified/services/api/ServiceDirectoryType;", "simplified-services-api"})
public final class ServiceDirectoryBuilder
implements ServiceDirectoryBuilderType {
    private final Logger logger;
    private final Map<Class<?>, List<Object>> services;

    @Override
    @NotNull
    public ServiceDirectoryType build() {
        return new ServiceDirectory(MapsKt.toMap(this.services));
    }

    @Override
    @NotNull
    public <T> ServiceDirectoryBuilderType addService(@NotNull List<Class<T>> interfaces, @NotNull T service) {
        Intrinsics.checkNotNullParameter(interfaces, (String)"interfaces");
        Intrinsics.checkNotNullParameter(service, (String)"service");
        Collection collection = interfaces;
        boolean bl = false;
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0, (String)"Must supply at least one interface type", (Object[])new Object[0]);
        this.logger.debug("adding service {}", service.getClass());
        for (Class<T> inter : interfaces) {
            List list = this.services.get(inter);
            if (list == null) {
                boolean bl2 = false;
                list = new ArrayList();
            }
            List existing = list;
            existing.add(service);
            this.services.put(inter, existing);
        }
        return this;
    }

    public ServiceDirectoryBuilder(@NotNull Map<Class<?>, List<Object>> services) {
        Intrinsics.checkNotNullParameter(services, (String)"services");
        this.services = services;
        this.logger = LoggerFactory.getLogger(ServiceDirectoryBuilder.class);
    }

    @Override
    @NotNull
    public <T> ServiceDirectoryBuilderType addService(@NotNull Class<T> interfaceType, @NotNull T service) {
        Intrinsics.checkNotNullParameter(interfaceType, (String)"interfaceType");
        Intrinsics.checkNotNullParameter(service, (String)"service");
        return ServiceDirectoryBuilderType.DefaultImpls.addService(this, interfaceType, service);
    }
}

