/*
 * Decompiled with CFR 0.152.
 */
package org.librarysimplified.services.api;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.librarysimplified.services.api.ServiceDirectoryProviderType;
import org.librarysimplified.services.api.ServiceDirectoryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0007H\u0016J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/librarysimplified/services/api/Services;", "Lorg/librarysimplified/services/api/ServiceDirectoryProviderType;", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "servicesDirectory", "Lorg/librarysimplified/services/api/ServiceDirectoryType;", "servicesFuture", "Lcom/google/common/util/concurrent/SettableFuture;", "servicesLock", "", "initialize", "", "services", "isInitialized", "", "serviceDirectory", "serviceDirectoryFuture", "Lcom/google/common/util/concurrent/ListenableFuture;", "simplified-services-api"})
public final class Services
implements ServiceDirectoryProviderType {
    private static final Logger logger;
    private static final Object servicesLock;
    private static ServiceDirectoryType servicesDirectory;
    private static final SettableFuture<ServiceDirectoryType> servicesFuture;
    public static final Services INSTANCE;

    @Override
    @NotNull
    public ServiceDirectoryType serviceDirectory() {
        try {
            Object object = servicesFuture.get(30L, TimeUnit.SECONDS);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.servicesFuture.get(30L, TimeUnit.SECONDS)");
            return (ServiceDirectoryType)object;
        }
        catch (Exception e) {
            logger.error("unable to fetch service directory: ", (Throwable)e);
            throw (Throwable)e;
        }
    }

    @NotNull
    public final ListenableFuture<ServiceDirectoryType> serviceDirectoryFuture() {
        return (ListenableFuture)servicesFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isInitialized() {
        Object object = servicesLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            bl2 = servicesDirectory != null;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize(@NotNull ServiceDirectoryType services) {
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Object object = servicesLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            boolean bl4 = servicesDirectory == null;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "Service directory has already been initialized!";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            servicesDirectory = services;
            servicesFuture.set((Object)services);
            Unit unit = Unit.INSTANCE;
        }
    }

    private Services() {
    }

    static {
        Services services;
        INSTANCE = services = new Services();
        logger = LoggerFactory.getLogger(Services.class);
        servicesLock = new Object();
        SettableFuture settableFuture = SettableFuture.create();
        Intrinsics.checkNotNullExpressionValue((Object)settableFuture, (String)"SettableFuture.create()");
        servicesFuture = settableFuture;
    }
}

