/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.batteries;

import java.io.IOException;
import java.util.HashSet;
import javax.annotation.Nullable;
import org.ldk.batteries.NioPeerHandler;
import org.ldk.enums.Network;
import org.ldk.structs.BackgroundProcessor;
import org.ldk.structs.BestBlock;
import org.ldk.structs.BroadcasterInterface;
import org.ldk.structs.ChainMonitor;
import org.ldk.structs.ChainParameters;
import org.ldk.structs.ChannelDetails;
import org.ldk.structs.ChannelManager;
import org.ldk.structs.ChannelMonitor;
import org.ldk.structs.DefaultMessageRouter;
import org.ldk.structs.DefaultRouter;
import org.ldk.structs.EntropySource;
import org.ldk.structs.Event;
import org.ldk.structs.FeeEstimator;
import org.ldk.structs.Filter;
import org.ldk.structs.GossipSync;
import org.ldk.structs.IgnoringMessageHandler;
import org.ldk.structs.InFlightHtlcs;
import org.ldk.structs.Logger;
import org.ldk.structs.MultiThreadedLockableScore;
import org.ldk.structs.NetworkGraph;
import org.ldk.structs.NodeSigner;
import org.ldk.structs.OnionMessenger;
import org.ldk.structs.Option_UtxoLookupZ;
import org.ldk.structs.Option_WriteableScoreZ;
import org.ldk.structs.OutPoint;
import org.ldk.structs.P2PGossipSync;
import org.ldk.structs.PeerManager;
import org.ldk.structs.Persister;
import org.ldk.structs.ProbabilisticScorer;
import org.ldk.structs.ProbabilisticScoringDecayParameters;
import org.ldk.structs.ProbabilisticScoringFeeParameters;
import org.ldk.structs.ReceiveTlvs;
import org.ldk.structs.Result_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ;
import org.ldk.structs.Result_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ;
import org.ldk.structs.Result_CVec_BlindedPaymentPathZNoneZ;
import org.ldk.structs.Result_NetworkGraphDecodeErrorZ;
import org.ldk.structs.Result_NoneIOErrorZ;
import org.ldk.structs.Result_NoneReplayEventZ;
import org.ldk.structs.Result_ProbabilisticScorerDecodeErrorZ;
import org.ldk.structs.Result_RouteLightningErrorZ;
import org.ldk.structs.RouteParameters;
import org.ldk.structs.Router;
import org.ldk.structs.RoutingMessageHandler;
import org.ldk.structs.ScoreUpdate;
import org.ldk.structs.SignerProvider;
import org.ldk.structs.TwoTuple_ThirtyTwoBytesChannelMonitorZ;
import org.ldk.structs.UserConfig;
import org.ldk.structs.UtilMethods;
import org.ldk.structs.WriteableScore;

public class ChannelManagerConstructor {
    public final ChannelManager channel_manager;
    public final byte[] channel_manager_latest_block_hash;
    public final TwoTuple_ThirtyTwoBytesChannelMonitorZ[] channel_monitors;
    public PeerManager peer_manager = null;
    public NioPeerHandler nio_peer_handler = null;
    private final ChainMonitor chain_monitor;
    public final NetworkGraph net_graph;
    public final MultiThreadedLockableScore scorer;
    private final ProbabilisticScorer prob_scorer;
    private final Logger logger;
    private final EntropySource entropy_source;
    private final NodeSigner node_signer;
    private final Router router;
    private final DefaultMessageRouter msg_router;
    BackgroundProcessor background_processor = null;

    public ScorerWrapper get_locked_scorer() {
        return new ScorerWrapper(this.scorer.as_LockableScore().write_lock(), this.prob_scorer);
    }

    public ChannelManagerConstructor(byte[] channel_manager_serialized, byte[][] channel_monitors_serialized, UserConfig config, EntropySource entropy_source, NodeSigner node_signer, SignerProvider signer_provider, FeeEstimator fee_estimator, ChainMonitor chain_monitor, @Nullable Filter filter, byte[] net_graph_serialized, ProbabilisticScoringDecayParameters scoring_decay_params, ProbabilisticScoringFeeParameters scoring_fee_params, byte[] probabilistic_scorer_bytes, final @Nullable RouterWrapper router_wrapper, BroadcasterInterface tx_broadcaster, Logger logger) throws InvalidSerializedDataException {
        this.entropy_source = entropy_source;
        this.node_signer = node_signer;
        Result_NetworkGraphDecodeErrorZ graph_res = NetworkGraph.read(net_graph_serialized, logger);
        if (!graph_res.is_ok()) {
            throw new InvalidSerializedDataException("Serialized Network Graph was corrupt");
        }
        this.net_graph = ((Result_NetworkGraphDecodeErrorZ.Result_NetworkGraphDecodeErrorZ_OK)graph_res).res;
        assert (scoring_decay_params != null);
        assert (probabilistic_scorer_bytes != null);
        Result_ProbabilisticScorerDecodeErrorZ scorer_res = ProbabilisticScorer.read(probabilistic_scorer_bytes, scoring_decay_params, this.net_graph, logger);
        if (!scorer_res.is_ok()) {
            throw new InvalidSerializedDataException("Serialized ProbabilisticScorer was corrupt");
        }
        this.prob_scorer = ((Result_ProbabilisticScorerDecodeErrorZ.Result_ProbabilisticScorerDecodeErrorZ_OK)scorer_res).res;
        this.scorer = MultiThreadedLockableScore.of(this.prob_scorer.as_Score());
        assert (scoring_fee_params != null);
        final DefaultRouter default_router = DefaultRouter.of(this.net_graph, logger, entropy_source, this.scorer.as_LockableScore(), scoring_fee_params);
        this.router = router_wrapper != null ? Router.new_impl(new Router.RouterInterface(){

            @Override
            public Result_RouteLightningErrorZ find_route(byte[] payer, RouteParameters route_params, ChannelDetails[] first_hops, InFlightHtlcs inflight_htlcs) {
                return router_wrapper.find_route(payer, route_params, first_hops, inflight_htlcs, null, null, default_router);
            }

            @Override
            public Result_RouteLightningErrorZ find_route_with_id(byte[] payer, RouteParameters route_params, ChannelDetails[] first_hops, InFlightHtlcs inflight_htlcs, byte[] payment_hash, byte[] payment_id) {
                return router_wrapper.find_route(payer, route_params, first_hops, inflight_htlcs, payment_hash, payment_id, default_router);
            }

            @Override
            public Result_CVec_BlindedPaymentPathZNoneZ create_blinded_payment_paths(byte[] recipient, ChannelDetails[] first_hops, ReceiveTlvs tlvs, long amount_msats) {
                return default_router.as_Router().create_blinded_payment_paths(recipient, first_hops, tlvs, amount_msats);
            }
        }) : default_router.as_Router();
        this.msg_router = DefaultMessageRouter.of(this.net_graph, entropy_source);
        ChannelMonitor[] monitors = new ChannelMonitor[channel_monitors_serialized.length];
        this.channel_monitors = new TwoTuple_ThirtyTwoBytesChannelMonitorZ[monitors.length];
        HashSet<OutPoint> monitor_funding_set = new HashSet<OutPoint>();
        for (int i = 0; i < monitors.length; ++i) {
            Result_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ res = UtilMethods.C2Tuple_ThirtyTwoBytesChannelMonitorZ_read(channel_monitors_serialized[i], entropy_source, signer_provider);
            if (res instanceof Result_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ.Result_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ_Err) {
                throw new InvalidSerializedDataException("Serialized ChannelMonitor was corrupt");
            }
            byte[] block_hash = ((Result_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ.Result_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ_OK)res).res.get_a();
            monitors[i] = ((Result_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ.Result_C2Tuple_ThirtyTwoBytesChannelMonitorZDecodeErrorZ_OK)res).res.get_b();
            this.channel_monitors[i] = TwoTuple_ThirtyTwoBytesChannelMonitorZ.of(block_hash, monitors[i]);
            if (monitor_funding_set.add(monitors[i].get_funding_txo().get_a())) continue;
            throw new InvalidSerializedDataException("Set of ChannelMonitors contained duplicates (ie the same funding_txo was set on multiple monitors)");
        }
        Result_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ res = UtilMethods.C2Tuple_ThirtyTwoBytesChannelManagerZ_read(channel_manager_serialized, entropy_source, node_signer, signer_provider, fee_estimator, chain_monitor.as_Watch(), tx_broadcaster, this.router, this.msg_router.as_MessageRouter(), logger, config, monitors);
        if (!res.is_ok()) {
            throw new InvalidSerializedDataException("Serialized ChannelManager was corrupt");
        }
        this.channel_manager = ((Result_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ.Result_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ_OK)res).res.get_b();
        this.channel_manager_latest_block_hash = ((Result_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ.Result_C2Tuple_ThirtyTwoBytesChannelManagerZDecodeErrorZ_OK)res).res.get_a();
        this.chain_monitor = chain_monitor;
        this.logger = logger;
        if (filter != null) {
            for (ChannelMonitor monitor : monitors) {
                monitor.load_outputs_to_watch(filter, logger);
            }
        }
    }

    public ChannelManagerConstructor(Network network, UserConfig config, byte[] current_blockchain_tip_hash, int current_blockchain_tip_height, EntropySource entropy_source, NodeSigner node_signer, SignerProvider signer_provider, FeeEstimator fee_estimator, ChainMonitor chain_monitor, NetworkGraph net_graph, ProbabilisticScoringDecayParameters scoring_decay_params, ProbabilisticScoringFeeParameters scoring_fee_params, final @Nullable RouterWrapper router_wrapper, BroadcasterInterface tx_broadcaster, Logger logger) {
        this.entropy_source = entropy_source;
        this.node_signer = node_signer;
        this.net_graph = net_graph;
        assert (scoring_decay_params != null);
        this.prob_scorer = ProbabilisticScorer.of(scoring_decay_params, net_graph, logger);
        this.scorer = MultiThreadedLockableScore.of(this.prob_scorer.as_Score());
        assert (scoring_fee_params != null);
        final DefaultRouter default_router = DefaultRouter.of(this.net_graph, logger, entropy_source, this.scorer.as_LockableScore(), scoring_fee_params);
        this.router = router_wrapper != null ? Router.new_impl(new Router.RouterInterface(){

            @Override
            public Result_RouteLightningErrorZ find_route(byte[] payer, RouteParameters route_params, ChannelDetails[] first_hops, InFlightHtlcs inflight_htlcs) {
                return router_wrapper.find_route(payer, route_params, first_hops, inflight_htlcs, null, null, default_router);
            }

            @Override
            public Result_RouteLightningErrorZ find_route_with_id(byte[] payer, RouteParameters route_params, ChannelDetails[] first_hops, InFlightHtlcs inflight_htlcs, byte[] payment_hash, byte[] payment_id) {
                return router_wrapper.find_route(payer, route_params, first_hops, inflight_htlcs, payment_hash, payment_id, default_router);
            }

            @Override
            public Result_CVec_BlindedPaymentPathZNoneZ create_blinded_payment_paths(byte[] recipient, ChannelDetails[] first_hops, ReceiveTlvs tlvs, long amount_msats) {
                return default_router.as_Router().create_blinded_payment_paths(recipient, first_hops, tlvs, amount_msats);
            }
        }) : default_router.as_Router();
        this.msg_router = DefaultMessageRouter.of(this.net_graph, entropy_source);
        this.channel_monitors = new TwoTuple_ThirtyTwoBytesChannelMonitorZ[0];
        this.channel_manager_latest_block_hash = null;
        this.chain_monitor = chain_monitor;
        BestBlock block = BestBlock.of(current_blockchain_tip_hash, current_blockchain_tip_height);
        ChainParameters params = ChainParameters.of(network, block);
        this.channel_manager = ChannelManager.of(fee_estimator, chain_monitor.as_Watch(), tx_broadcaster, this.router, this.msg_router.as_MessageRouter(), logger, entropy_source, node_signer, signer_provider, config, params, (int)(System.currentTimeMillis() / 1000L));
        this.logger = logger;
    }

    public void chain_sync_completed(final EventHandler event_handler, boolean use_p2p_graph_sync) {
        if (this.background_processor != null) {
            return;
        }
        for (TwoTuple_ThirtyTwoBytesChannelMonitorZ monitor : this.channel_monitors) {
            this.chain_monitor.as_Watch().watch_channel(monitor.get_b().get_funding_txo().get_a(), monitor.get_b());
        }
        org.ldk.structs.EventHandler ldk_handler = org.ldk.structs.EventHandler.new_impl(event_handler::handle_event);
        IgnoringMessageHandler ignoring_handler = IgnoringMessageHandler.of();
        P2PGossipSync graph_msg_handler = P2PGossipSync.of(this.net_graph, Option_UtxoLookupZ.none(), this.logger);
        RoutingMessageHandler routing_msg_handler = use_p2p_graph_sync ? graph_msg_handler.as_RoutingMessageHandler() : ignoring_handler.as_RoutingMessageHandler();
        OnionMessenger messenger = OnionMessenger.of(this.entropy_source, this.node_signer, this.logger, this.channel_manager.as_NodeIdLookUp(), this.msg_router.as_MessageRouter(), this.channel_manager.as_OffersMessageHandler(), IgnoringMessageHandler.of().as_AsyncPaymentsMessageHandler(), this.channel_manager.as_DNSResolverMessageHandler(), IgnoringMessageHandler.of().as_CustomOnionMessageHandler());
        this.peer_manager = PeerManager.of(this.channel_manager.as_ChannelMessageHandler(), routing_msg_handler, messenger.as_OnionMessageHandler(), ignoring_handler.as_CustomMessageHandler(), (int)(System.currentTimeMillis() / 1000L), this.entropy_source.get_secure_random_bytes(), this.logger, this.node_signer);
        try {
            this.nio_peer_handler = new NioPeerHandler(this.peer_manager);
        }
        catch (IOException e) {
            throw new IllegalStateException("We should never fail to construct nio objects unless we're on a platform that cannot run LDK.");
        }
        GossipSync gossip_sync = use_p2p_graph_sync ? GossipSync.p2_p(graph_msg_handler) : GossipSync.none();
        Option_WriteableScoreZ writeable_score = Option_WriteableScoreZ.some(this.scorer.as_WriteableScore());
        this.background_processor = BackgroundProcessor.start(Persister.new_impl(new Persister.PersisterInterface(){

            @Override
            public Result_NoneIOErrorZ persist_manager(ChannelManager channel_manager) {
                event_handler.persist_manager(channel_manager.write());
                return Result_NoneIOErrorZ.ok();
            }

            @Override
            public Result_NoneIOErrorZ persist_graph(NetworkGraph network_graph) {
                event_handler.persist_network_graph(network_graph.write());
                return Result_NoneIOErrorZ.ok();
            }

            @Override
            public Result_NoneIOErrorZ persist_scorer(WriteableScore scorer) {
                event_handler.persist_scorer(scorer.write());
                return Result_NoneIOErrorZ.ok();
            }
        }), ldk_handler, this.chain_monitor, this.channel_manager, messenger, gossip_sync, this.peer_manager, this.logger, writeable_score);
    }

    public void interrupt() {
        if (this.nio_peer_handler != null) {
            this.nio_peer_handler.interrupt();
        }
        this.background_processor.stop();
    }

    public class ScorerWrapper
    implements AutoCloseable {
        private final ScoreUpdate lock;
        public final ProbabilisticScorer prob_scorer;

        private ScorerWrapper(ScoreUpdate lock, ProbabilisticScorer prob_scorer) {
            this.lock = lock;
            this.prob_scorer = prob_scorer;
        }

        @Override
        public void close() throws Exception {
            this.lock.destroy();
        }
    }

    public static class InvalidSerializedDataException
    extends Exception {
        InvalidSerializedDataException(String reason) {
            super(reason);
        }
    }

    public static interface RouterWrapper {
        public Result_RouteLightningErrorZ find_route(byte[] var1, RouteParameters var2, ChannelDetails[] var3, InFlightHtlcs var4, @Nullable byte[] var5, @Nullable byte[] var6, DefaultRouter var7);
    }

    public static interface EventHandler {
        public Result_NoneReplayEventZ handle_event(Event var1);

        public void persist_manager(byte[] var1);

        public void persist_network_graph(byte[] var1);

        public void persist_scorer(byte[] var1);
    }
}

