/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.batteries;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import org.ldk.structs.Option_SocketAddressZ;
import org.ldk.structs.PeerManager;
import org.ldk.structs.Result_CVec_u8ZPeerHandleErrorZ;
import org.ldk.structs.Result_NonePeerHandleErrorZ;
import org.ldk.structs.Result_boolPeerHandleErrorZ;
import org.ldk.structs.SocketDescriptor;

public class NioPeerHandler {
    private static boolean IS_ANDROID = System.getProperty("java.vendor").toLowerCase().contains("android");
    private boolean wakeup_selector = false;
    private static Method ResultBoolPeerHandleError_Free;
    PeerManager peer_manager;
    Thread io_thread;
    final Selector selector;
    long socket_id;
    volatile boolean shutdown = false;
    private LinkedList<ServerSocketChannel> listening_sockets = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void do_selector_action(SelectorCall meth) throws IOException {
        if (IS_ANDROID) {
            this.wakeup_selector = true;
            this.selector.wakeup();
            Selector selector = this.selector;
            synchronized (selector) {
                meth.meth();
                this.wakeup_selector = false;
            }
        } else {
            meth.meth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Peer setup_socket(final SocketChannel chan) throws IOException {
        SocketDescriptor descriptor;
        long our_id;
        chan.configureBlocking(false);
        chan.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
        NioPeerHandler nioPeerHandler = this;
        synchronized (nioPeerHandler) {
            ++this.socket_id;
            our_id = this.socket_id;
        }
        final Peer peer = new Peer();
        peer.descriptor = descriptor = SocketDescriptor.new_impl(new SocketDescriptor.SocketDescriptorInterface(){

            @Override
            public long send_data(byte[] data, boolean resume_read) {
                try {
                    long written = chan.write(ByteBuffer.wrap(data));
                    if (written != (long)data.length) {
                        NioPeerHandler.this.do_selector_action(() -> peer2.key.interestOps((peer2.key.interestOps() | 4) & 0xFFFFFFFE));
                    } else if (resume_read) {
                        NioPeerHandler.this.do_selector_action(() -> peer2.key.interestOps((peer2.key.interestOps() | 1) & 0xFFFFFFFB));
                    }
                    return written;
                }
                catch (IOException | CancelledKeyException ignored) {
                    return 0L;
                }
            }

            @Override
            public void disconnect_socket() {
                try {
                    NioPeerHandler.this.do_selector_action(() -> {
                        try {
                            peer2.key.cancel();
                        }
                        catch (CancelledKeyException cancelledKeyException) {
                            // empty catch block
                        }
                        peer2.key.channel().close();
                    });
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public boolean eq(SocketDescriptor other_arg) {
                return other_arg.hash() == our_id;
            }

            @Override
            public long hash() {
                return our_id;
            }
        });
        return peer;
    }

    private static Option_SocketAddressZ get_netaddr_from_sockaddr(SocketAddress sockaddr) {
        if (sockaddr instanceof InetSocketAddress) {
            InetAddress addr = ((InetSocketAddress)sockaddr).getAddress();
            short port = (short)((InetSocketAddress)sockaddr).getPort();
            if (addr instanceof Inet4Address) {
                return Option_SocketAddressZ.some(org.ldk.structs.SocketAddress.tcp_ip_v4(addr.getAddress(), port));
            }
            if (addr instanceof Inet6Address) {
                return Option_SocketAddressZ.some(org.ldk.structs.SocketAddress.tcp_ip_v6(addr.getAddress(), port));
            }
        }
        return Option_SocketAddressZ.none();
    }

    public NioPeerHandler(PeerManager manager) throws IOException {
        this.peer_manager = manager;
        this.selector = Selector.open();
        this.io_thread = new Thread(() -> {
            int BUF_SZ = 16384;
            byte[] max_buf_byte_object = new byte[BUF_SZ];
            ByteBuffer buf = ByteBuffer.allocate(BUF_SZ);
            while (true) {
                block31: {
                    try {
                        if (IS_ANDROID) {
                            while (true) {
                                Selector selector = this.selector;
                                synchronized (selector) {
                                    if (!this.wakeup_selector) {
                                        this.selector.select(1000L);
                                        break block31;
                                    }
                                }
                            }
                        }
                        this.selector.select(1000L);
                    }
                    catch (IOException ignored) {
                        System.err.println("java.nio threw an unexpected IOException. Stopping PeerHandler thread!");
                        return;
                    }
                }
                if (this.shutdown) {
                    return;
                }
                if (Thread.interrupted()) {
                    return;
                }
                for (SelectionKey key : this.selector.selectedKeys()) {
                    try {
                        if ((key.interestOps() & 0x10) != 0) {
                            SocketChannel chan;
                            if (!key.isAcceptable()) continue;
                            try {
                                chan = ((ServerSocketChannel)key.channel()).accept();
                            }
                            catch (IOException ignored) {
                                key.cancel();
                                continue;
                            }
                            if (chan == null) continue;
                            try {
                                Peer peer = this.setup_socket(chan);
                                peer.key = chan.register(this.selector, 1, peer);
                                Option_SocketAddressZ netaddr = NioPeerHandler.get_netaddr_from_sockaddr(chan.getRemoteAddress());
                                Result_NonePeerHandleErrorZ res = this.peer_manager.new_inbound_connection(peer.descriptor, netaddr);
                                if (!(res instanceof Result_NonePeerHandleErrorZ.Result_NonePeerHandleErrorZ_Err)) continue;
                                peer.descriptor.disconnect_socket();
                            }
                            catch (IOException peer) {}
                            continue;
                        }
                        Peer peer = (Peer)key.attachment();
                        try {
                            Result_NonePeerHandleErrorZ res;
                            if (key.isValid() && (key.interestOps() & 4) != 0 && key.isWritable() && (res = this.peer_manager.write_buffer_space_avail(peer.descriptor)) instanceof Result_NonePeerHandleErrorZ.Result_NonePeerHandleErrorZ_Err) {
                                key.cancel();
                                key.channel().close();
                            }
                            if (!key.isValid() || (key.interestOps() & 1) == 0 || !key.isReadable()) continue;
                            ((Buffer)buf).clear();
                            int read = ((SocketChannel)key.channel()).read(buf);
                            if (read == -1) {
                                this.peer_manager.socket_disconnected(peer.descriptor);
                                key.cancel();
                                key.channel().close();
                                continue;
                            }
                            if (read <= 0) continue;
                            ((Buffer)buf).flip();
                            byte[] read_bytes = read == BUF_SZ ? max_buf_byte_object : new byte[read];
                            buf.get(read_bytes, 0, read);
                            Result_boolPeerHandleErrorZ read_res = this.peer_manager.read_event(peer.descriptor, read_bytes);
                            if (read_res instanceof Result_boolPeerHandleErrorZ.Result_boolPeerHandleErrorZ_OK) {
                                if (((Result_boolPeerHandleErrorZ.Result_boolPeerHandleErrorZ_OK)read_res).res) {
                                    key.interestOps(key.interestOps() & 0xFFFFFFFE);
                                }
                                try {
                                    ResultBoolPeerHandleError_Free.invoke((Object)read_res, new Object[0]);
                                }
                                catch (Exception exception) {}
                                continue;
                            }
                            key.cancel();
                            key.channel().close();
                        }
                        catch (IOException ignored) {
                            key.cancel();
                            try {
                                key.channel().close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            this.peer_manager.socket_disconnected(peer.descriptor);
                        }
                    }
                    catch (CancelledKeyException e) {
                        try {
                            key.channel().close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                this.peer_manager.process_events();
            }
        }, "NioPeerHandler NIO Thread");
        this.io_thread.start();
    }

    public void connect(byte[] their_node_id, SocketAddress remote, int timeout_ms) throws IOException {
        boolean connected;
        if (this.peer_manager.peer_by_node_id(their_node_id) != null) {
            return;
        }
        SocketChannel chan = SocketChannel.open();
        try {
            chan.configureBlocking(false);
            Selector open_selector = Selector.open();
            chan.register(open_selector, 8);
            if (!chan.connect(remote)) {
                open_selector.select(timeout_ms);
            }
            connected = chan.finishConnect();
        }
        catch (IOException e) {
            try {
                chan.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        if (!connected) {
            try {
                chan.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw new IOException("Timed out");
        }
        Peer peer = this.setup_socket(chan);
        this.do_selector_action(() -> {
            peer.key = chan.register(this.selector, 1, peer);
        });
        Result_CVec_u8ZPeerHandleErrorZ res = this.peer_manager.new_outbound_connection(their_node_id, peer.descriptor, NioPeerHandler.get_netaddr_from_sockaddr(remote));
        if (res instanceof Result_CVec_u8ZPeerHandleErrorZ.Result_CVec_u8ZPeerHandleErrorZ_OK) {
            byte[] initial_bytes = ((Result_CVec_u8ZPeerHandleErrorZ.Result_CVec_u8ZPeerHandleErrorZ_OK)res).res;
            if (chan.write(ByteBuffer.wrap(initial_bytes)) != initial_bytes.length) {
                peer.descriptor.disconnect_socket();
                this.peer_manager.socket_disconnected(peer.descriptor);
                throw new IOException("We assume TCP socket buffer is at least a single packet in length");
            }
        } else {
            peer.descriptor.disconnect_socket();
            throw new IOException("LDK rejected outbound connection. This likely shouldn't ever happen.");
        }
    }

    public void disconnect(byte[] their_node_id) {
        this.peer_manager.disconnect_by_node_id(their_node_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind_listener(SocketAddress socket_address) throws IOException {
        ServerSocketChannel listen_channel = ServerSocketChannel.open();
        listen_channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        listen_channel.bind(socket_address);
        listen_channel.configureBlocking(false);
        this.do_selector_action(() -> listen_channel.register(this.selector, 16));
        LinkedList<ServerSocketChannel> linkedList = this.listening_sockets;
        synchronized (linkedList) {
            this.listening_sockets.add(listen_channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        this.peer_manager.disconnect_all_peers();
        this.shutdown = true;
        this.selector.wakeup();
        try {
            this.io_thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LinkedList<ServerSocketChannel> linkedList = this.listening_sockets;
        synchronized (linkedList) {
            try {
                this.selector.close();
                for (ServerSocketChannel chan : this.listening_sockets) {
                    chan.close();
                }
                this.listening_sockets.clear();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Reference.reachabilityFence(this.peer_manager);
    }

    public void check_events() {
        this.selector.wakeup();
    }

    static {
        try {
            Class<Result_boolPeerHandleErrorZ> c = Result_boolPeerHandleErrorZ.class;
            ResultBoolPeerHandleError_Free = c.getDeclaredMethod("force_free", new Class[0]);
            ResultBoolPeerHandleError_Free.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("We currently use reflection to access protected fields as Java has no reasonable access controls", e);
        }
    }

    private static interface SelectorCall {
        public void meth() throws IOException;
    }

    private static class Peer {
        SocketDescriptor descriptor;
        SelectionKey key;

        private Peer() {
        }
    }
}

