/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.ShutdownScript;

public class APIError
extends CommonBase {
    private APIError(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.APIError_free(this.ptr);
        }
    }

    static APIError constr_from_ptr(long ptr) {
        bindings.LDKAPIError raw_val = bindings.LDKAPIError_ref_from_ptr(ptr);
        if (raw_val.getClass() == bindings.LDKAPIError.APIMisuseError.class) {
            return new APIMisuseError(ptr, (bindings.LDKAPIError.APIMisuseError)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKAPIError.FeeRateTooHigh.class) {
            return new FeeRateTooHigh(ptr, (bindings.LDKAPIError.FeeRateTooHigh)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKAPIError.InvalidRoute.class) {
            return new InvalidRoute(ptr, (bindings.LDKAPIError.InvalidRoute)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKAPIError.ChannelUnavailable.class) {
            return new ChannelUnavailable(ptr, (bindings.LDKAPIError.ChannelUnavailable)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKAPIError.MonitorUpdateInProgress.class) {
            return new MonitorUpdateInProgress(ptr, (bindings.LDKAPIError.MonitorUpdateInProgress)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKAPIError.IncompatibleShutdownScript.class) {
            return new IncompatibleShutdownScript(ptr, (bindings.LDKAPIError.IncompatibleShutdownScript)raw_val);
        }
        assert (false);
        return null;
    }

    long clone_ptr() {
        long ret = bindings.APIError_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public APIError clone() {
        long ret = bindings.APIError_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        APIError ret_hu_conv = APIError.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static APIError apimisuse_error(String err) {
        long ret = bindings.APIError_apimisuse_error(err);
        Reference.reachabilityFence(err);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        APIError ret_hu_conv = APIError.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static APIError fee_rate_too_high(String err, int feerate) {
        long ret = bindings.APIError_fee_rate_too_high(err, feerate);
        Reference.reachabilityFence(err);
        Reference.reachabilityFence(feerate);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        APIError ret_hu_conv = APIError.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static APIError invalid_route(String err) {
        long ret = bindings.APIError_invalid_route(err);
        Reference.reachabilityFence(err);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        APIError ret_hu_conv = APIError.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static APIError channel_unavailable(String err) {
        long ret = bindings.APIError_channel_unavailable(err);
        Reference.reachabilityFence(err);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        APIError ret_hu_conv = APIError.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static APIError monitor_update_in_progress() {
        long ret = bindings.APIError_monitor_update_in_progress();
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        APIError ret_hu_conv = APIError.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static APIError incompatible_shutdown_script(ShutdownScript script) {
        long ret = bindings.APIError_incompatible_shutdown_script(script.ptr);
        Reference.reachabilityFence(script);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        APIError ret_hu_conv = APIError.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public boolean eq(APIError b) {
        boolean ret = bindings.APIError_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof APIError)) {
            return false;
        }
        return this.eq((APIError)o);
    }

    public byte[] write() {
        byte[] ret = bindings.APIError_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static final class APIMisuseError
    extends APIError {
        public final String err;

        private APIMisuseError(long ptr, bindings.LDKAPIError.APIMisuseError obj) {
            super(null, ptr);
            this.err = obj.err;
        }
    }

    public static final class FeeRateTooHigh
    extends APIError {
        public final String err;
        public final int feerate;

        private FeeRateTooHigh(long ptr, bindings.LDKAPIError.FeeRateTooHigh obj) {
            super(null, ptr);
            this.err = obj.err;
            this.feerate = obj.feerate;
        }
    }

    public static final class InvalidRoute
    extends APIError {
        public final String err;

        private InvalidRoute(long ptr, bindings.LDKAPIError.InvalidRoute obj) {
            super(null, ptr);
            this.err = obj.err;
        }
    }

    public static final class ChannelUnavailable
    extends APIError {
        public final String err;

        private ChannelUnavailable(long ptr, bindings.LDKAPIError.ChannelUnavailable obj) {
            super(null, ptr);
            this.err = obj.err;
        }
    }

    public static final class MonitorUpdateInProgress
    extends APIError {
        private MonitorUpdateInProgress(long ptr, bindings.LDKAPIError.MonitorUpdateInProgress obj) {
            super(null, ptr);
        }
    }

    public static final class IncompatibleShutdownScript
    extends APIError {
        public final ShutdownScript script;

        private IncompatibleShutdownScript(long ptr, bindings.LDKAPIError.IncompatibleShutdownScript obj) {
            super(null, ptr);
            long script = obj.script;
            ShutdownScript script_hu_conv = null;
            if (script < 0L || script > 4096L) {
                script_hu_conv = new ShutdownScript(null, script);
            }
            if (script_hu_conv != null) {
                script_hu_conv.ptrs_to.add(this);
            }
            this.script = script_hu_conv;
        }
    }
}

