/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.util.InternalUtils;

public class Amount
extends CommonBase {
    private Amount(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.Amount_free(this.ptr);
        }
    }

    static Amount constr_from_ptr(long ptr) {
        bindings.LDKAmount raw_val = bindings.LDKAmount_ref_from_ptr(ptr);
        if (raw_val.getClass() == bindings.LDKAmount.Bitcoin.class) {
            return new Bitcoin(ptr, (bindings.LDKAmount.Bitcoin)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKAmount.Currency.class) {
            return new Currency(ptr, (bindings.LDKAmount.Currency)raw_val);
        }
        assert (false);
        return null;
    }

    long clone_ptr() {
        long ret = bindings.Amount_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public Amount clone() {
        long ret = bindings.Amount_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Amount ret_hu_conv = Amount.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static Amount bitcoin(long amount_msats) {
        long ret = bindings.Amount_bitcoin(amount_msats);
        Reference.reachabilityFence(amount_msats);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Amount ret_hu_conv = Amount.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Amount currency(byte[] iso4217_code, long amount) {
        long ret = bindings.Amount_currency(InternalUtils.check_arr_len(iso4217_code, 3), amount);
        Reference.reachabilityFence(iso4217_code);
        Reference.reachabilityFence(amount);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Amount ret_hu_conv = Amount.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static final class Bitcoin
    extends Amount {
        public final long amount_msats;

        private Bitcoin(long ptr, bindings.LDKAmount.Bitcoin obj) {
            super(null, ptr);
            this.amount_msats = obj.amount_msats;
        }
    }

    public static final class Currency
    extends Amount {
        public final byte[] iso4217_code;
        public final long amount;

        private Currency(long ptr, bindings.LDKAmount.Currency obj) {
            super(null, ptr);
            this.iso4217_code = obj.iso4217_code;
            this.amount = obj.amount;
        }
    }
}

