/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Nonce;
import org.ldk.structs.Result_AsyncPaymentsContextDecodeErrorZ;
import org.ldk.util.InternalUtils;

public class AsyncPaymentsContext
extends CommonBase {
    private AsyncPaymentsContext(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.AsyncPaymentsContext_free(this.ptr);
        }
    }

    static AsyncPaymentsContext constr_from_ptr(long ptr) {
        bindings.LDKAsyncPaymentsContext raw_val = bindings.LDKAsyncPaymentsContext_ref_from_ptr(ptr);
        if (raw_val.getClass() == bindings.LDKAsyncPaymentsContext.OutboundPayment.class) {
            return new OutboundPayment(ptr, (bindings.LDKAsyncPaymentsContext.OutboundPayment)raw_val);
        }
        assert (false);
        return null;
    }

    long clone_ptr() {
        long ret = bindings.AsyncPaymentsContext_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public AsyncPaymentsContext clone() {
        long ret = bindings.AsyncPaymentsContext_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        AsyncPaymentsContext ret_hu_conv = AsyncPaymentsContext.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static AsyncPaymentsContext outbound_payment(byte[] payment_id, Nonce nonce, byte[] hmac) {
        long ret = bindings.AsyncPaymentsContext_outbound_payment(InternalUtils.check_arr_len(payment_id, 32), nonce.ptr, InternalUtils.check_arr_len(hmac, 32));
        Reference.reachabilityFence(payment_id);
        Reference.reachabilityFence(nonce);
        Reference.reachabilityFence(hmac);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        AsyncPaymentsContext ret_hu_conv = AsyncPaymentsContext.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public byte[] write() {
        byte[] ret = bindings.AsyncPaymentsContext_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_AsyncPaymentsContextDecodeErrorZ read(byte[] ser) {
        long ret = bindings.AsyncPaymentsContext_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_AsyncPaymentsContextDecodeErrorZ ret_hu_conv = Result_AsyncPaymentsContextDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static final class OutboundPayment
    extends AsyncPaymentsContext {
        public final byte[] payment_id;
        public final Nonce nonce;
        public final byte[] hmac;

        private OutboundPayment(long ptr, bindings.LDKAsyncPaymentsContext.OutboundPayment obj) {
            super(null, ptr);
            this.payment_id = obj.payment_id;
            long nonce = obj.nonce;
            Nonce nonce_hu_conv = null;
            if (nonce < 0L || nonce > 4096L) {
                nonce_hu_conv = new Nonce(null, nonce);
            }
            if (nonce_hu_conv != null) {
                nonce_hu_conv.ptrs_to.add(this);
            }
            this.nonce = nonce_hu_conv;
            this.hmac = obj.hmac;
        }
    }
}

