/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.enums.BalanceSource;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.util.InternalUtils;

public class Balance
extends CommonBase {
    private Balance(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.Balance_free(this.ptr);
        }
    }

    static Balance constr_from_ptr(long ptr) {
        bindings.LDKBalance raw_val = bindings.LDKBalance_ref_from_ptr(ptr);
        if (raw_val.getClass() == bindings.LDKBalance.ClaimableOnChannelClose.class) {
            return new ClaimableOnChannelClose(ptr, (bindings.LDKBalance.ClaimableOnChannelClose)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKBalance.ClaimableAwaitingConfirmations.class) {
            return new ClaimableAwaitingConfirmations(ptr, (bindings.LDKBalance.ClaimableAwaitingConfirmations)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKBalance.ContentiousClaimable.class) {
            return new ContentiousClaimable(ptr, (bindings.LDKBalance.ContentiousClaimable)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKBalance.MaybeTimeoutClaimableHTLC.class) {
            return new MaybeTimeoutClaimableHTLC(ptr, (bindings.LDKBalance.MaybeTimeoutClaimableHTLC)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKBalance.MaybePreimageClaimableHTLC.class) {
            return new MaybePreimageClaimableHTLC(ptr, (bindings.LDKBalance.MaybePreimageClaimableHTLC)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKBalance.CounterpartyRevokedOutputClaimable.class) {
            return new CounterpartyRevokedOutputClaimable(ptr, (bindings.LDKBalance.CounterpartyRevokedOutputClaimable)raw_val);
        }
        assert (false);
        return null;
    }

    long clone_ptr() {
        long ret = bindings.Balance_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public Balance clone() {
        long ret = bindings.Balance_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Balance ret_hu_conv = Balance.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static Balance claimable_on_channel_close(long amount_satoshis, long transaction_fee_satoshis, long outbound_payment_htlc_rounded_msat, long outbound_forwarded_htlc_rounded_msat, long inbound_claiming_htlc_rounded_msat, long inbound_htlc_rounded_msat) {
        long ret = bindings.Balance_claimable_on_channel_close(amount_satoshis, transaction_fee_satoshis, outbound_payment_htlc_rounded_msat, outbound_forwarded_htlc_rounded_msat, inbound_claiming_htlc_rounded_msat, inbound_htlc_rounded_msat);
        Reference.reachabilityFence(amount_satoshis);
        Reference.reachabilityFence(transaction_fee_satoshis);
        Reference.reachabilityFence(outbound_payment_htlc_rounded_msat);
        Reference.reachabilityFence(outbound_forwarded_htlc_rounded_msat);
        Reference.reachabilityFence(inbound_claiming_htlc_rounded_msat);
        Reference.reachabilityFence(inbound_htlc_rounded_msat);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Balance ret_hu_conv = Balance.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Balance claimable_awaiting_confirmations(long amount_satoshis, int confirmation_height, BalanceSource source) {
        long ret = bindings.Balance_claimable_awaiting_confirmations(amount_satoshis, confirmation_height, source);
        Reference.reachabilityFence(amount_satoshis);
        Reference.reachabilityFence(confirmation_height);
        Reference.reachabilityFence((Object)source);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Balance ret_hu_conv = Balance.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Balance contentious_claimable(long amount_satoshis, int timeout_height, byte[] payment_hash, byte[] payment_preimage) {
        long ret = bindings.Balance_contentious_claimable(amount_satoshis, timeout_height, InternalUtils.check_arr_len(payment_hash, 32), InternalUtils.check_arr_len(payment_preimage, 32));
        Reference.reachabilityFence(amount_satoshis);
        Reference.reachabilityFence(timeout_height);
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(payment_preimage);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Balance ret_hu_conv = Balance.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Balance maybe_timeout_claimable_htlc(long amount_satoshis, int claimable_height, byte[] payment_hash, boolean outbound_payment) {
        long ret = bindings.Balance_maybe_timeout_claimable_htlc(amount_satoshis, claimable_height, InternalUtils.check_arr_len(payment_hash, 32), outbound_payment);
        Reference.reachabilityFence(amount_satoshis);
        Reference.reachabilityFence(claimable_height);
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(outbound_payment);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Balance ret_hu_conv = Balance.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Balance maybe_preimage_claimable_htlc(long amount_satoshis, int expiry_height, byte[] payment_hash) {
        long ret = bindings.Balance_maybe_preimage_claimable_htlc(amount_satoshis, expiry_height, InternalUtils.check_arr_len(payment_hash, 32));
        Reference.reachabilityFence(amount_satoshis);
        Reference.reachabilityFence(expiry_height);
        Reference.reachabilityFence(payment_hash);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Balance ret_hu_conv = Balance.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Balance counterparty_revoked_output_claimable(long amount_satoshis) {
        long ret = bindings.Balance_counterparty_revoked_output_claimable(amount_satoshis);
        Reference.reachabilityFence(amount_satoshis);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Balance ret_hu_conv = Balance.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public boolean eq(Balance b) {
        boolean ret = bindings.Balance_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Balance)) {
            return false;
        }
        return this.eq((Balance)o);
    }

    public long claimable_amount_satoshis() {
        long ret = bindings.Balance_claimable_amount_satoshis(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static final class ClaimableOnChannelClose
    extends Balance {
        public final long amount_satoshis;
        public final long transaction_fee_satoshis;
        public final long outbound_payment_htlc_rounded_msat;
        public final long outbound_forwarded_htlc_rounded_msat;
        public final long inbound_claiming_htlc_rounded_msat;
        public final long inbound_htlc_rounded_msat;

        private ClaimableOnChannelClose(long ptr, bindings.LDKBalance.ClaimableOnChannelClose obj) {
            super(null, ptr);
            this.amount_satoshis = obj.amount_satoshis;
            this.transaction_fee_satoshis = obj.transaction_fee_satoshis;
            this.outbound_payment_htlc_rounded_msat = obj.outbound_payment_htlc_rounded_msat;
            this.outbound_forwarded_htlc_rounded_msat = obj.outbound_forwarded_htlc_rounded_msat;
            this.inbound_claiming_htlc_rounded_msat = obj.inbound_claiming_htlc_rounded_msat;
            this.inbound_htlc_rounded_msat = obj.inbound_htlc_rounded_msat;
        }
    }

    public static final class ClaimableAwaitingConfirmations
    extends Balance {
        public final long amount_satoshis;
        public final int confirmation_height;
        public final BalanceSource source;

        private ClaimableAwaitingConfirmations(long ptr, bindings.LDKBalance.ClaimableAwaitingConfirmations obj) {
            super(null, ptr);
            this.amount_satoshis = obj.amount_satoshis;
            this.confirmation_height = obj.confirmation_height;
            this.source = obj.source;
        }
    }

    public static final class ContentiousClaimable
    extends Balance {
        public final long amount_satoshis;
        public final int timeout_height;
        public final byte[] payment_hash;
        public final byte[] payment_preimage;

        private ContentiousClaimable(long ptr, bindings.LDKBalance.ContentiousClaimable obj) {
            super(null, ptr);
            this.amount_satoshis = obj.amount_satoshis;
            this.timeout_height = obj.timeout_height;
            this.payment_hash = obj.payment_hash;
            this.payment_preimage = obj.payment_preimage;
        }
    }

    public static final class MaybeTimeoutClaimableHTLC
    extends Balance {
        public final long amount_satoshis;
        public final int claimable_height;
        public final byte[] payment_hash;
        public final boolean outbound_payment;

        private MaybeTimeoutClaimableHTLC(long ptr, bindings.LDKBalance.MaybeTimeoutClaimableHTLC obj) {
            super(null, ptr);
            this.amount_satoshis = obj.amount_satoshis;
            this.claimable_height = obj.claimable_height;
            this.payment_hash = obj.payment_hash;
            this.outbound_payment = obj.outbound_payment;
        }
    }

    public static final class MaybePreimageClaimableHTLC
    extends Balance {
        public final long amount_satoshis;
        public final int expiry_height;
        public final byte[] payment_hash;

        private MaybePreimageClaimableHTLC(long ptr, bindings.LDKBalance.MaybePreimageClaimableHTLC obj) {
            super(null, ptr);
            this.amount_satoshis = obj.amount_satoshis;
            this.expiry_height = obj.expiry_height;
            this.payment_hash = obj.payment_hash;
        }
    }

    public static final class CounterpartyRevokedOutputClaimable
    extends Balance {
        public final long amount_satoshis;

        private CounterpartyRevokedOutputClaimable(long ptr, bindings.LDKBalance.CounterpartyRevokedOutputClaimable obj) {
            super(null, ptr);
            this.amount_satoshis = obj.amount_satoshis;
        }
    }
}

