/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.ldk.impl.bindings;
import org.ldk.structs.BlindedHop;
import org.ldk.structs.CommonBase;
import org.ldk.structs.EntropySource;
import org.ldk.structs.IntroductionNode;
import org.ldk.structs.MessageContext;
import org.ldk.structs.MessageForwardNode;
import org.ldk.structs.NodeId;
import org.ldk.structs.NodeIdLookUp;
import org.ldk.structs.NodeSigner;
import org.ldk.structs.ReadOnlyNetworkGraph;
import org.ldk.structs.Result_BlindedMessagePathDecodeErrorZ;
import org.ldk.structs.Result_BlindedMessagePathNoneZ;
import org.ldk.structs.Result_NoneNoneZ;
import org.ldk.util.InternalUtils;

public class BlindedMessagePath
extends CommonBase {
    BlindedMessagePath(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.BlindedMessagePath_free(this.ptr);
        }
    }

    long clone_ptr() {
        long ret = bindings.BlindedMessagePath_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public BlindedMessagePath clone() {
        long ret = bindings.BlindedMessagePath_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        BlindedMessagePath ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new BlindedMessagePath(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public long hash() {
        long ret = bindings.BlindedMessagePath_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public int hashCode() {
        return (int)this.hash();
    }

    public boolean eq(BlindedMessagePath b) {
        boolean ret = bindings.BlindedMessagePath_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        if (this != null) {
            this.ptrs_to.add(b);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BlindedMessagePath)) {
            return false;
        }
        return this.eq((BlindedMessagePath)o);
    }

    public byte[] write() {
        byte[] ret = bindings.BlindedMessagePath_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_BlindedMessagePathDecodeErrorZ read(byte[] ser) {
        long ret = bindings.BlindedMessagePath_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_BlindedMessagePathDecodeErrorZ ret_hu_conv = Result_BlindedMessagePathDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static Result_BlindedMessagePathNoneZ one_hop(byte[] recipient_node_id, MessageContext context, EntropySource entropy_source) {
        long ret = bindings.BlindedMessagePath_one_hop(InternalUtils.check_arr_len(recipient_node_id, 33), context.ptr, entropy_source.ptr);
        Reference.reachabilityFence(recipient_node_id);
        Reference.reachabilityFence(context);
        Reference.reachabilityFence(entropy_source);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_BlindedMessagePathNoneZ ret_hu_conv = Result_BlindedMessagePathNoneZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(entropy_source);
        }
        return ret_hu_conv;
    }

    public static Result_BlindedMessagePathNoneZ of(MessageForwardNode[] intermediate_nodes, byte[] recipient_node_id, MessageContext context, EntropySource entropy_source) {
        long ret = bindings.BlindedMessagePath_new(intermediate_nodes != null ? Arrays.stream(intermediate_nodes).mapToLong(intermediate_nodes_conv_20 -> intermediate_nodes_conv_20.ptr).toArray() : null, InternalUtils.check_arr_len(recipient_node_id, 33), context.ptr, entropy_source.ptr);
        Reference.reachabilityFence(intermediate_nodes);
        Reference.reachabilityFence(recipient_node_id);
        Reference.reachabilityFence(context);
        Reference.reachabilityFence(entropy_source);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_BlindedMessagePathNoneZ ret_hu_conv = Result_BlindedMessagePathNoneZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(entropy_source);
        }
        return ret_hu_conv;
    }

    public void use_compact_introduction_node(ReadOnlyNetworkGraph network_graph) {
        bindings.BlindedMessagePath_use_compact_introduction_node(this.ptr, network_graph.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(network_graph);
        if (this != null) {
            this.ptrs_to.add(network_graph);
        }
    }

    @Nullable
    public NodeId public_introduction_node_id(ReadOnlyNetworkGraph network_graph) {
        long ret = bindings.BlindedMessagePath_public_introduction_node_id(this.ptr, network_graph.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(network_graph);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        NodeId ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new NodeId(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        if (this != null) {
            this.ptrs_to.add(network_graph);
        }
        return ret_hu_conv;
    }

    public IntroductionNode introduction_node() {
        long ret = bindings.BlindedMessagePath_introduction_node(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        IntroductionNode ret_hu_conv = IntroductionNode.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public byte[] blinding_point() {
        byte[] ret = bindings.BlindedMessagePath_blinding_point(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public BlindedHop[] blinded_hops() {
        long[] ret = bindings.BlindedMessagePath_blinded_hops(this.ptr);
        Reference.reachabilityFence(this);
        int ret_conv_12_len = ret.length;
        BlindedHop[] ret_conv_12_arr = new BlindedHop[ret_conv_12_len];
        for (int m = 0; m < ret_conv_12_len; ++m) {
            long ret_conv_12 = ret[m];
            BlindedHop ret_conv_12_hu_conv = null;
            if (ret_conv_12 < 0L || ret_conv_12 > 4096L) {
                ret_conv_12_hu_conv = new BlindedHop(null, ret_conv_12);
            }
            if (ret_conv_12_hu_conv != null) {
                ret_conv_12_hu_conv.ptrs_to.add(this);
            }
            ret_conv_12_arr[m] = ret_conv_12_hu_conv;
        }
        return ret_conv_12_arr;
    }

    public Result_NoneNoneZ advance_path_by_one(NodeSigner node_signer, NodeIdLookUp node_id_lookup) {
        long ret = bindings.BlindedMessagePath_advance_path_by_one(this.ptr, node_signer.ptr, node_id_lookup.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(node_signer);
        Reference.reachabilityFence(node_id_lookup);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneNoneZ ret_hu_conv = Result_NoneNoneZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(node_signer);
        }
        if (this != null) {
            this.ptrs_to.add(node_id_lookup);
        }
        return ret_hu_conv;
    }
}

