/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import javax.annotation.Nullable;
import org.ldk.enums.Currency;
import org.ldk.impl.bindings;
import org.ldk.structs.Bolt11InvoiceFeatures;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Option_CVec_u8ZZ;
import org.ldk.structs.Option_u64Z;
import org.ldk.structs.PrivateRoute;
import org.ldk.structs.Result_Bolt11InvoiceBolt11SemanticErrorZ;
import org.ldk.structs.Result_Bolt11InvoiceParseOrSemanticErrorZ;
import org.ldk.structs.Result_NoneBolt11SemanticErrorZ;
import org.ldk.structs.RouteHint;
import org.ldk.structs.SignedRawBolt11Invoice;

public class Bolt11Invoice
extends CommonBase {
    Bolt11Invoice(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.Bolt11Invoice_free(this.ptr);
        }
    }

    public boolean eq(Bolt11Invoice b) {
        boolean ret = bindings.Bolt11Invoice_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        if (this != null) {
            this.ptrs_to.add(b);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Bolt11Invoice)) {
            return false;
        }
        return this.eq((Bolt11Invoice)o);
    }

    long clone_ptr() {
        long ret = bindings.Bolt11Invoice_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public Bolt11Invoice clone() {
        long ret = bindings.Bolt11Invoice_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Bolt11Invoice ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new Bolt11Invoice(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public long hash() {
        long ret = bindings.Bolt11Invoice_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public int hashCode() {
        return (int)this.hash();
    }

    public byte[] signable_hash() {
        byte[] ret = bindings.Bolt11Invoice_signable_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public SignedRawBolt11Invoice into_signed_raw() {
        long ret = bindings.Bolt11Invoice_into_signed_raw(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        SignedRawBolt11Invoice ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new SignedRawBolt11Invoice(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Result_NoneBolt11SemanticErrorZ check_signature() {
        long ret = bindings.Bolt11Invoice_check_signature(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneBolt11SemanticErrorZ ret_hu_conv = Result_NoneBolt11SemanticErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public static Result_Bolt11InvoiceBolt11SemanticErrorZ from_signed(SignedRawBolt11Invoice signed_invoice) {
        long ret = bindings.Bolt11Invoice_from_signed(signed_invoice.ptr);
        Reference.reachabilityFence(signed_invoice);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_Bolt11InvoiceBolt11SemanticErrorZ ret_hu_conv = Result_Bolt11InvoiceBolt11SemanticErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public long timestamp() {
        long ret = bindings.Bolt11Invoice_timestamp(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public long duration_since_epoch() {
        long ret = bindings.Bolt11Invoice_duration_since_epoch(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public byte[] payment_hash() {
        byte[] ret = bindings.Bolt11Invoice_payment_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    @Nullable
    public byte[] payee_pub_key() {
        byte[] ret = bindings.Bolt11Invoice_payee_pub_key(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public byte[] payment_secret() {
        byte[] ret = bindings.Bolt11Invoice_payment_secret(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public Option_CVec_u8ZZ payment_metadata() {
        long ret = bindings.Bolt11Invoice_payment_metadata(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_CVec_u8ZZ ret_hu_conv = Option_CVec_u8ZZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    @Nullable
    public Bolt11InvoiceFeatures features() {
        long ret = bindings.Bolt11Invoice_features(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Bolt11InvoiceFeatures ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new Bolt11InvoiceFeatures(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public byte[] recover_payee_pub_key() {
        byte[] ret = bindings.Bolt11Invoice_recover_payee_pub_key(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public byte[] get_payee_pub_key() {
        byte[] ret = bindings.Bolt11Invoice_get_payee_pub_key(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public Option_u64Z expires_at() {
        long ret = bindings.Bolt11Invoice_expires_at(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public long expiry_time() {
        long ret = bindings.Bolt11Invoice_expiry_time(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public boolean is_expired() {
        boolean ret = bindings.Bolt11Invoice_is_expired(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public long duration_until_expiry() {
        long ret = bindings.Bolt11Invoice_duration_until_expiry(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public long expiration_remaining_from_epoch(long time) {
        long ret = bindings.Bolt11Invoice_expiration_remaining_from_epoch(this.ptr, time);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(time);
        return ret;
    }

    public boolean would_expire(long at_time) {
        boolean ret = bindings.Bolt11Invoice_would_expire(this.ptr, at_time);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(at_time);
        return ret;
    }

    public long min_final_cltv_expiry_delta() {
        long ret = bindings.Bolt11Invoice_min_final_cltv_expiry_delta(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public String[] fallback_addresses() {
        String[] ret = bindings.Bolt11Invoice_fallback_addresses(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public PrivateRoute[] private_routes() {
        long[] ret = bindings.Bolt11Invoice_private_routes(this.ptr);
        Reference.reachabilityFence(this);
        int ret_conv_14_len = ret.length;
        PrivateRoute[] ret_conv_14_arr = new PrivateRoute[ret_conv_14_len];
        for (int o = 0; o < ret_conv_14_len; ++o) {
            long ret_conv_14 = ret[o];
            PrivateRoute ret_conv_14_hu_conv = null;
            if (ret_conv_14 < 0L || ret_conv_14 > 4096L) {
                ret_conv_14_hu_conv = new PrivateRoute(null, ret_conv_14);
            }
            if (ret_conv_14_hu_conv != null) {
                ret_conv_14_hu_conv.ptrs_to.add(this);
            }
            ret_conv_14_arr[o] = ret_conv_14_hu_conv;
        }
        return ret_conv_14_arr;
    }

    public RouteHint[] route_hints() {
        long[] ret = bindings.Bolt11Invoice_route_hints(this.ptr);
        Reference.reachabilityFence(this);
        int ret_conv_11_len = ret.length;
        RouteHint[] ret_conv_11_arr = new RouteHint[ret_conv_11_len];
        for (int l = 0; l < ret_conv_11_len; ++l) {
            long ret_conv_11 = ret[l];
            RouteHint ret_conv_11_hu_conv = null;
            if (ret_conv_11 < 0L || ret_conv_11 > 4096L) {
                ret_conv_11_hu_conv = new RouteHint(null, ret_conv_11);
            }
            if (ret_conv_11_hu_conv != null) {
                ret_conv_11_hu_conv.ptrs_to.add(this);
            }
            ret_conv_11_arr[l] = ret_conv_11_hu_conv;
        }
        return ret_conv_11_arr;
    }

    public Currency currency() {
        Currency ret = bindings.Bolt11Invoice_currency(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public Option_u64Z amount_milli_satoshis() {
        long ret = bindings.Bolt11Invoice_amount_milli_satoshis(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static Result_Bolt11InvoiceParseOrSemanticErrorZ from_str(String s) {
        long ret = bindings.Bolt11Invoice_from_str(s);
        Reference.reachabilityFence(s);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_Bolt11InvoiceParseOrSemanticErrorZ ret_hu_conv = Result_Bolt11InvoiceParseOrSemanticErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public String to_str() {
        String ret = bindings.Bolt11Invoice_to_str(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }
}

