/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.Bolt11InvoiceDescription;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Option_ThirtyTwoBytesZ;
import org.ldk.structs.Option_u16Z;
import org.ldk.structs.Option_u32Z;
import org.ldk.structs.Option_u64Z;

public class Bolt11InvoiceParameters
extends CommonBase {
    Bolt11InvoiceParameters(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.Bolt11InvoiceParameters_free(this.ptr);
        }
    }

    public Option_u64Z get_amount_msats() {
        long ret = bindings.Bolt11InvoiceParameters_get_amount_msats(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_amount_msats(Option_u64Z val) {
        bindings.Bolt11InvoiceParameters_set_amount_msats(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Bolt11InvoiceDescription get_description() {
        long ret = bindings.Bolt11InvoiceParameters_get_description(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Bolt11InvoiceDescription ret_hu_conv = Bolt11InvoiceDescription.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_description(Bolt11InvoiceDescription val) {
        bindings.Bolt11InvoiceParameters_set_description(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_u32Z get_invoice_expiry_delta_secs() {
        long ret = bindings.Bolt11InvoiceParameters_get_invoice_expiry_delta_secs(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u32Z ret_hu_conv = Option_u32Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_invoice_expiry_delta_secs(Option_u32Z val) {
        bindings.Bolt11InvoiceParameters_set_invoice_expiry_delta_secs(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_u16Z get_min_final_cltv_expiry_delta() {
        long ret = bindings.Bolt11InvoiceParameters_get_min_final_cltv_expiry_delta(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u16Z ret_hu_conv = Option_u16Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_min_final_cltv_expiry_delta(Option_u16Z val) {
        bindings.Bolt11InvoiceParameters_set_min_final_cltv_expiry_delta(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_ThirtyTwoBytesZ get_payment_hash() {
        long ret = bindings.Bolt11InvoiceParameters_get_payment_hash(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_ThirtyTwoBytesZ ret_hu_conv = Option_ThirtyTwoBytesZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_payment_hash(Option_ThirtyTwoBytesZ val) {
        bindings.Bolt11InvoiceParameters_set_payment_hash(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public static Bolt11InvoiceParameters of(Option_u64Z amount_msats_arg, Bolt11InvoiceDescription description_arg, Option_u32Z invoice_expiry_delta_secs_arg, Option_u16Z min_final_cltv_expiry_delta_arg, Option_ThirtyTwoBytesZ payment_hash_arg) {
        long ret = bindings.Bolt11InvoiceParameters_new(amount_msats_arg.ptr, description_arg.ptr, invoice_expiry_delta_secs_arg.ptr, min_final_cltv_expiry_delta_arg.ptr, payment_hash_arg.ptr);
        Reference.reachabilityFence(amount_msats_arg);
        Reference.reachabilityFence(description_arg);
        Reference.reachabilityFence(invoice_expiry_delta_secs_arg);
        Reference.reachabilityFence(min_final_cltv_expiry_delta_arg);
        Reference.reachabilityFence(payment_hash_arg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Bolt11InvoiceParameters ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new Bolt11InvoiceParameters(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Bolt11InvoiceParameters with_default() {
        long ret = bindings.Bolt11InvoiceParameters_default();
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Bolt11InvoiceParameters ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new Bolt11InvoiceParameters(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }
}

