/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import java.util.Arrays;
import org.ldk.impl.bindings;
import org.ldk.structs.AnchorDescriptor;
import org.ldk.structs.ChannelId;
import org.ldk.structs.CommonBase;
import org.ldk.structs.HTLCDescriptor;
import org.ldk.structs.HTLCOutputInCommitment;
import org.ldk.util.InternalUtils;

public class BumpTransactionEvent
extends CommonBase {
    private BumpTransactionEvent(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.BumpTransactionEvent_free(this.ptr);
        }
    }

    static BumpTransactionEvent constr_from_ptr(long ptr) {
        bindings.LDKBumpTransactionEvent raw_val = bindings.LDKBumpTransactionEvent_ref_from_ptr(ptr);
        if (raw_val.getClass() == bindings.LDKBumpTransactionEvent.ChannelClose.class) {
            return new ChannelClose(ptr, (bindings.LDKBumpTransactionEvent.ChannelClose)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKBumpTransactionEvent.HTLCResolution.class) {
            return new HTLCResolution(ptr, (bindings.LDKBumpTransactionEvent.HTLCResolution)raw_val);
        }
        assert (false);
        return null;
    }

    long clone_ptr() {
        long ret = bindings.BumpTransactionEvent_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public BumpTransactionEvent clone() {
        long ret = bindings.BumpTransactionEvent_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        BumpTransactionEvent ret_hu_conv = BumpTransactionEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static BumpTransactionEvent channel_close(ChannelId channel_id, byte[] counterparty_node_id, byte[] claim_id, int package_target_feerate_sat_per_1000_weight, byte[] commitment_tx, long commitment_tx_fee_satoshis, AnchorDescriptor anchor_descriptor, HTLCOutputInCommitment[] pending_htlcs) {
        long ret = bindings.BumpTransactionEvent_channel_close(channel_id.ptr, InternalUtils.check_arr_len(counterparty_node_id, 33), InternalUtils.check_arr_len(claim_id, 32), package_target_feerate_sat_per_1000_weight, commitment_tx, commitment_tx_fee_satoshis, anchor_descriptor.ptr, pending_htlcs != null ? Arrays.stream(pending_htlcs).mapToLong(pending_htlcs_conv_24 -> pending_htlcs_conv_24.ptr).toArray() : null);
        Reference.reachabilityFence(channel_id);
        Reference.reachabilityFence(counterparty_node_id);
        Reference.reachabilityFence(claim_id);
        Reference.reachabilityFence(package_target_feerate_sat_per_1000_weight);
        Reference.reachabilityFence(commitment_tx);
        Reference.reachabilityFence(commitment_tx_fee_satoshis);
        Reference.reachabilityFence(anchor_descriptor);
        Reference.reachabilityFence(pending_htlcs);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        BumpTransactionEvent ret_hu_conv = BumpTransactionEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static BumpTransactionEvent htlcresolution(ChannelId channel_id, byte[] counterparty_node_id, byte[] claim_id, int target_feerate_sat_per_1000_weight, HTLCDescriptor[] htlc_descriptors, int tx_lock_time) {
        long ret = bindings.BumpTransactionEvent_htlcresolution(channel_id.ptr, InternalUtils.check_arr_len(counterparty_node_id, 33), InternalUtils.check_arr_len(claim_id, 32), target_feerate_sat_per_1000_weight, htlc_descriptors != null ? Arrays.stream(htlc_descriptors).mapToLong(htlc_descriptors_conv_16 -> htlc_descriptors_conv_16.ptr).toArray() : null, tx_lock_time);
        Reference.reachabilityFence(channel_id);
        Reference.reachabilityFence(counterparty_node_id);
        Reference.reachabilityFence(claim_id);
        Reference.reachabilityFence(target_feerate_sat_per_1000_weight);
        Reference.reachabilityFence(htlc_descriptors);
        Reference.reachabilityFence(tx_lock_time);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        BumpTransactionEvent ret_hu_conv = BumpTransactionEvent.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public boolean eq(BumpTransactionEvent b) {
        boolean ret = bindings.BumpTransactionEvent_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BumpTransactionEvent)) {
            return false;
        }
        return this.eq((BumpTransactionEvent)o);
    }

    public static final class ChannelClose
    extends BumpTransactionEvent {
        public final ChannelId channel_id;
        public final byte[] counterparty_node_id;
        public final byte[] claim_id;
        public final int package_target_feerate_sat_per_1000_weight;
        public final byte[] commitment_tx;
        public final long commitment_tx_fee_satoshis;
        public final AnchorDescriptor anchor_descriptor;
        public final HTLCOutputInCommitment[] pending_htlcs;

        private ChannelClose(long ptr, bindings.LDKBumpTransactionEvent.ChannelClose obj) {
            super(null, ptr);
            long channel_id = obj.channel_id;
            ChannelId channel_id_hu_conv = null;
            if (channel_id < 0L || channel_id > 4096L) {
                channel_id_hu_conv = new ChannelId(null, channel_id);
            }
            if (channel_id_hu_conv != null) {
                channel_id_hu_conv.ptrs_to.add(this);
            }
            this.channel_id = channel_id_hu_conv;
            this.counterparty_node_id = obj.counterparty_node_id;
            this.claim_id = obj.claim_id;
            this.package_target_feerate_sat_per_1000_weight = obj.package_target_feerate_sat_per_1000_weight;
            this.commitment_tx = obj.commitment_tx;
            this.commitment_tx_fee_satoshis = obj.commitment_tx_fee_satoshis;
            long anchor_descriptor = obj.anchor_descriptor;
            AnchorDescriptor anchor_descriptor_hu_conv = null;
            if (anchor_descriptor < 0L || anchor_descriptor > 4096L) {
                anchor_descriptor_hu_conv = new AnchorDescriptor(null, anchor_descriptor);
            }
            if (anchor_descriptor_hu_conv != null) {
                anchor_descriptor_hu_conv.ptrs_to.add(this);
            }
            this.anchor_descriptor = anchor_descriptor_hu_conv;
            long[] pending_htlcs = obj.pending_htlcs;
            int pending_htlcs_conv_24_len = pending_htlcs.length;
            HTLCOutputInCommitment[] pending_htlcs_conv_24_arr = new HTLCOutputInCommitment[pending_htlcs_conv_24_len];
            for (int y = 0; y < pending_htlcs_conv_24_len; ++y) {
                long pending_htlcs_conv_24 = pending_htlcs[y];
                HTLCOutputInCommitment pending_htlcs_conv_24_hu_conv = null;
                if (pending_htlcs_conv_24 < 0L || pending_htlcs_conv_24 > 4096L) {
                    pending_htlcs_conv_24_hu_conv = new HTLCOutputInCommitment(null, pending_htlcs_conv_24);
                }
                if (pending_htlcs_conv_24_hu_conv != null) {
                    pending_htlcs_conv_24_hu_conv.ptrs_to.add(this);
                }
                pending_htlcs_conv_24_arr[y] = pending_htlcs_conv_24_hu_conv;
            }
            this.pending_htlcs = pending_htlcs_conv_24_arr;
        }
    }

    public static final class HTLCResolution
    extends BumpTransactionEvent {
        public final ChannelId channel_id;
        public final byte[] counterparty_node_id;
        public final byte[] claim_id;
        public final int target_feerate_sat_per_1000_weight;
        public final HTLCDescriptor[] htlc_descriptors;
        public final int tx_lock_time;

        private HTLCResolution(long ptr, bindings.LDKBumpTransactionEvent.HTLCResolution obj) {
            super(null, ptr);
            long channel_id = obj.channel_id;
            ChannelId channel_id_hu_conv = null;
            if (channel_id < 0L || channel_id > 4096L) {
                channel_id_hu_conv = new ChannelId(null, channel_id);
            }
            if (channel_id_hu_conv != null) {
                channel_id_hu_conv.ptrs_to.add(this);
            }
            this.channel_id = channel_id_hu_conv;
            this.counterparty_node_id = obj.counterparty_node_id;
            this.claim_id = obj.claim_id;
            this.target_feerate_sat_per_1000_weight = obj.target_feerate_sat_per_1000_weight;
            long[] htlc_descriptors = obj.htlc_descriptors;
            int htlc_descriptors_conv_16_len = htlc_descriptors.length;
            HTLCDescriptor[] htlc_descriptors_conv_16_arr = new HTLCDescriptor[htlc_descriptors_conv_16_len];
            for (int q = 0; q < htlc_descriptors_conv_16_len; ++q) {
                long htlc_descriptors_conv_16 = htlc_descriptors[q];
                HTLCDescriptor htlc_descriptors_conv_16_hu_conv = null;
                if (htlc_descriptors_conv_16 < 0L || htlc_descriptors_conv_16 > 4096L) {
                    htlc_descriptors_conv_16_hu_conv = new HTLCDescriptor(null, htlc_descriptors_conv_16);
                }
                if (htlc_descriptors_conv_16_hu_conv != null) {
                    htlc_descriptors_conv_16_hu_conv.ptrs_to.add(this);
                }
                htlc_descriptors_conv_16_arr[q] = htlc_descriptors_conv_16_hu_conv;
            }
            this.htlc_descriptors = htlc_descriptors_conv_16_arr;
            this.tx_lock_time = obj.tx_lock_time;
        }
    }
}

