/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.ldk.impl.bindings;
import org.ldk.structs.Balance;
import org.ldk.structs.BroadcasterInterface;
import org.ldk.structs.ChannelDetails;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Confirm;
import org.ldk.structs.EventsProvider;
import org.ldk.structs.FeeEstimator;
import org.ldk.structs.Future;
import org.ldk.structs.Listen;
import org.ldk.structs.Logger;
import org.ldk.structs.Option_FilterZ;
import org.ldk.structs.OutPoint;
import org.ldk.structs.Persist;
import org.ldk.structs.Result_LockedChannelMonitorNoneZ;
import org.ldk.structs.Result_NoneAPIErrorZ;
import org.ldk.structs.TwoTuple_OutPointCVec_u64ZZ;
import org.ldk.structs.TwoTuple_OutPointChannelIdZ;
import org.ldk.structs.Watch;

public class ChainMonitor
extends CommonBase {
    ChainMonitor(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.ChainMonitor_free(this.ptr);
        }
    }

    public static ChainMonitor of(Option_FilterZ chain_source, BroadcasterInterface broadcaster, Logger logger, FeeEstimator feeest, Persist persister) {
        long ret = bindings.ChainMonitor_new(chain_source.ptr, broadcaster.ptr, logger.ptr, feeest.ptr, persister.ptr);
        Reference.reachabilityFence(chain_source);
        Reference.reachabilityFence(broadcaster);
        Reference.reachabilityFence(logger);
        Reference.reachabilityFence(feeest);
        Reference.reachabilityFence(persister);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChainMonitor ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChainMonitor(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(chain_source);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(broadcaster);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(logger);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(feeest);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(persister);
        }
        return ret_hu_conv;
    }

    public Balance[] get_claimable_balances(ChannelDetails[] ignored_channels) {
        long[] ret = bindings.ChainMonitor_get_claimable_balances(this.ptr, ignored_channels != null ? Arrays.stream(ignored_channels).mapToLong(ignored_channels_conv_16 -> ignored_channels_conv_16.ptr).toArray() : null);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(ignored_channels);
        int ret_conv_9_len = ret.length;
        Balance[] ret_conv_9_arr = new Balance[ret_conv_9_len];
        for (int j = 0; j < ret_conv_9_len; ++j) {
            long ret_conv_9 = ret[j];
            Balance ret_conv_9_hu_conv = Balance.constr_from_ptr(ret_conv_9);
            if (ret_conv_9_hu_conv != null) {
                ret_conv_9_hu_conv.ptrs_to.add(this);
            }
            ret_conv_9_arr[j] = ret_conv_9_hu_conv;
        }
        return ret_conv_9_arr;
    }

    public Result_LockedChannelMonitorNoneZ get_monitor(OutPoint funding_txo) {
        long ret = bindings.ChainMonitor_get_monitor(this.ptr, funding_txo.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(funding_txo);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_LockedChannelMonitorNoneZ ret_hu_conv = Result_LockedChannelMonitorNoneZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public TwoTuple_OutPointChannelIdZ[] list_monitors() {
        long[] ret = bindings.ChainMonitor_list_monitors(this.ptr);
        Reference.reachabilityFence(this);
        int ret_conv_29_len = ret.length;
        TwoTuple_OutPointChannelIdZ[] ret_conv_29_arr = new TwoTuple_OutPointChannelIdZ[ret_conv_29_len];
        for (int d = 0; d < ret_conv_29_len; ++d) {
            long ret_conv_29 = ret[d];
            TwoTuple_OutPointChannelIdZ ret_conv_29_hu_conv = new TwoTuple_OutPointChannelIdZ(null, ret_conv_29);
            if (ret_conv_29_hu_conv != null) {
                ret_conv_29_hu_conv.ptrs_to.add(this);
            }
            ret_conv_29_arr[d] = ret_conv_29_hu_conv;
        }
        return ret_conv_29_arr;
    }

    public TwoTuple_OutPointCVec_u64ZZ[] list_pending_monitor_updates() {
        long[] ret = bindings.ChainMonitor_list_pending_monitor_updates(this.ptr);
        Reference.reachabilityFence(this);
        int ret_conv_29_len = ret.length;
        TwoTuple_OutPointCVec_u64ZZ[] ret_conv_29_arr = new TwoTuple_OutPointCVec_u64ZZ[ret_conv_29_len];
        for (int d = 0; d < ret_conv_29_len; ++d) {
            long ret_conv_29 = ret[d];
            TwoTuple_OutPointCVec_u64ZZ ret_conv_29_hu_conv = new TwoTuple_OutPointCVec_u64ZZ(null, ret_conv_29);
            if (ret_conv_29_hu_conv != null) {
                ret_conv_29_hu_conv.ptrs_to.add(this);
            }
            ret_conv_29_arr[d] = ret_conv_29_hu_conv;
        }
        return ret_conv_29_arr;
    }

    public Result_NoneAPIErrorZ channel_monitor_updated(OutPoint funding_txo, long completed_update_id) {
        long ret = bindings.ChainMonitor_channel_monitor_updated(this.ptr, funding_txo.ptr, completed_update_id);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(funding_txo);
        Reference.reachabilityFence(completed_update_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneAPIErrorZ ret_hu_conv = Result_NoneAPIErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Future get_update_future() {
        long ret = bindings.ChainMonitor_get_update_future(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Future ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new Future(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void rebroadcast_pending_claims() {
        bindings.ChainMonitor_rebroadcast_pending_claims(this.ptr);
        Reference.reachabilityFence(this);
    }

    public void signer_unblocked(@Nullable OutPoint monitor_opt) {
        bindings.ChainMonitor_signer_unblocked(this.ptr, monitor_opt == null ? 0L : monitor_opt.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(monitor_opt);
    }

    public void archive_fully_resolved_channel_monitors() {
        bindings.ChainMonitor_archive_fully_resolved_channel_monitors(this.ptr);
        Reference.reachabilityFence(this);
    }

    public Listen as_Listen() {
        long ret = bindings.ChainMonitor_as_Listen(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Listen ret_hu_conv = new Listen(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Confirm as_Confirm() {
        long ret = bindings.ChainMonitor_as_Confirm(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Confirm ret_hu_conv = new Confirm(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Watch as_Watch() {
        long ret = bindings.ChainMonitor_as_Watch(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Watch ret_hu_conv = new Watch(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public EventsProvider as_EventsProvider() {
        long ret = bindings.ChainMonitor_as_EventsProvider(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        EventsProvider ret_hu_conv = new EventsProvider(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }
}

