/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import javax.annotation.Nullable;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.CounterpartyForwardingInfo;
import org.ldk.structs.InitFeatures;
import org.ldk.structs.Option_u64Z;
import org.ldk.structs.Result_ChannelCounterpartyDecodeErrorZ;
import org.ldk.util.InternalUtils;

public class ChannelCounterparty
extends CommonBase {
    ChannelCounterparty(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.ChannelCounterparty_free(this.ptr);
        }
    }

    public byte[] get_node_id() {
        byte[] ret = bindings.ChannelCounterparty_get_node_id(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_node_id(byte[] val) {
        bindings.ChannelCounterparty_set_node_id(this.ptr, InternalUtils.check_arr_len(val, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public InitFeatures get_features() {
        long ret = bindings.ChannelCounterparty_get_features(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        InitFeatures ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new InitFeatures(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_features(InitFeatures val) {
        bindings.ChannelCounterparty_set_features(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public long get_unspendable_punishment_reserve() {
        long ret = bindings.ChannelCounterparty_get_unspendable_punishment_reserve(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_unspendable_punishment_reserve(long val) {
        bindings.ChannelCounterparty_set_unspendable_punishment_reserve(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    @Nullable
    public CounterpartyForwardingInfo get_forwarding_info() {
        long ret = bindings.ChannelCounterparty_get_forwarding_info(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        CounterpartyForwardingInfo ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new CounterpartyForwardingInfo(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_forwarding_info(@Nullable CounterpartyForwardingInfo val) {
        bindings.ChannelCounterparty_set_forwarding_info(this.ptr, val == null ? 0L : val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_u64Z get_outbound_htlc_minimum_msat() {
        long ret = bindings.ChannelCounterparty_get_outbound_htlc_minimum_msat(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_outbound_htlc_minimum_msat(Option_u64Z val) {
        bindings.ChannelCounterparty_set_outbound_htlc_minimum_msat(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_u64Z get_outbound_htlc_maximum_msat() {
        long ret = bindings.ChannelCounterparty_get_outbound_htlc_maximum_msat(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_outbound_htlc_maximum_msat(Option_u64Z val) {
        bindings.ChannelCounterparty_set_outbound_htlc_maximum_msat(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public static ChannelCounterparty of(byte[] node_id_arg, InitFeatures features_arg, long unspendable_punishment_reserve_arg, @Nullable CounterpartyForwardingInfo forwarding_info_arg, Option_u64Z outbound_htlc_minimum_msat_arg, Option_u64Z outbound_htlc_maximum_msat_arg) {
        long ret = bindings.ChannelCounterparty_new(InternalUtils.check_arr_len(node_id_arg, 33), features_arg.ptr, unspendable_punishment_reserve_arg, forwarding_info_arg == null ? 0L : forwarding_info_arg.ptr, outbound_htlc_minimum_msat_arg.ptr, outbound_htlc_maximum_msat_arg.ptr);
        Reference.reachabilityFence(node_id_arg);
        Reference.reachabilityFence(features_arg);
        Reference.reachabilityFence(unspendable_punishment_reserve_arg);
        Reference.reachabilityFence(forwarding_info_arg);
        Reference.reachabilityFence(outbound_htlc_minimum_msat_arg);
        Reference.reachabilityFence(outbound_htlc_maximum_msat_arg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelCounterparty ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelCounterparty(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    long clone_ptr() {
        long ret = bindings.ChannelCounterparty_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public ChannelCounterparty clone() {
        long ret = bindings.ChannelCounterparty_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelCounterparty ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelCounterparty(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public byte[] write() {
        byte[] ret = bindings.ChannelCounterparty_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_ChannelCounterpartyDecodeErrorZ read(byte[] ser) {
        long ret = bindings.ChannelCounterparty_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_ChannelCounterpartyDecodeErrorZ ret_hu_conv = Result_ChannelCounterpartyDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }
}

