/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.ldk.impl.bindings;
import org.ldk.structs.ChannelConfig;
import org.ldk.structs.ChannelCounterparty;
import org.ldk.structs.ChannelId;
import org.ldk.structs.ChannelTypeFeatures;
import org.ldk.structs.CommonBase;
import org.ldk.structs.InboundHTLCDetails;
import org.ldk.structs.Option_ChannelShutdownStateZ;
import org.ldk.structs.Option_u16Z;
import org.ldk.structs.Option_u32Z;
import org.ldk.structs.Option_u64Z;
import org.ldk.structs.OutPoint;
import org.ldk.structs.OutboundHTLCDetails;
import org.ldk.structs.Result_ChannelDetailsDecodeErrorZ;
import org.ldk.util.UInt128;

public class ChannelDetails
extends CommonBase {
    ChannelDetails(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.ChannelDetails_free(this.ptr);
        }
    }

    public ChannelId get_channel_id() {
        long ret = bindings.ChannelDetails_get_channel_id(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelId ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelId(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_channel_id(ChannelId val) {
        bindings.ChannelDetails_set_channel_id(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public ChannelCounterparty get_counterparty() {
        long ret = bindings.ChannelDetails_get_counterparty(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelCounterparty ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelCounterparty(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_counterparty(ChannelCounterparty val) {
        bindings.ChannelDetails_set_counterparty(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    @Nullable
    public OutPoint get_funding_txo() {
        long ret = bindings.ChannelDetails_get_funding_txo(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OutPoint ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new OutPoint(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_funding_txo(@Nullable OutPoint val) {
        bindings.ChannelDetails_set_funding_txo(this.ptr, val == null ? 0L : val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    @Nullable
    public ChannelTypeFeatures get_channel_type() {
        long ret = bindings.ChannelDetails_get_channel_type(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelTypeFeatures ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelTypeFeatures(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_channel_type(@Nullable ChannelTypeFeatures val) {
        bindings.ChannelDetails_set_channel_type(this.ptr, val == null ? 0L : val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_u64Z get_short_channel_id() {
        long ret = bindings.ChannelDetails_get_short_channel_id(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_short_channel_id(Option_u64Z val) {
        bindings.ChannelDetails_set_short_channel_id(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_u64Z get_outbound_scid_alias() {
        long ret = bindings.ChannelDetails_get_outbound_scid_alias(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_outbound_scid_alias(Option_u64Z val) {
        bindings.ChannelDetails_set_outbound_scid_alias(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_u64Z get_inbound_scid_alias() {
        long ret = bindings.ChannelDetails_get_inbound_scid_alias(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_inbound_scid_alias(Option_u64Z val) {
        bindings.ChannelDetails_set_inbound_scid_alias(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public long get_channel_value_satoshis() {
        long ret = bindings.ChannelDetails_get_channel_value_satoshis(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_channel_value_satoshis(long val) {
        bindings.ChannelDetails_set_channel_value_satoshis(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_u64Z get_unspendable_punishment_reserve() {
        long ret = bindings.ChannelDetails_get_unspendable_punishment_reserve(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_unspendable_punishment_reserve(Option_u64Z val) {
        bindings.ChannelDetails_set_unspendable_punishment_reserve(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public UInt128 get_user_channel_id() {
        byte[] ret = bindings.ChannelDetails_get_user_channel_id(this.ptr);
        Reference.reachabilityFence(this);
        UInt128 ret_conv = new UInt128(ret);
        return ret_conv;
    }

    public void set_user_channel_id(UInt128 val) {
        bindings.ChannelDetails_set_user_channel_id(this.ptr, val.getLEBytes());
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_u32Z get_feerate_sat_per_1000_weight() {
        long ret = bindings.ChannelDetails_get_feerate_sat_per_1000_weight(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u32Z ret_hu_conv = Option_u32Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_feerate_sat_per_1000_weight(Option_u32Z val) {
        bindings.ChannelDetails_set_feerate_sat_per_1000_weight(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public long get_outbound_capacity_msat() {
        long ret = bindings.ChannelDetails_get_outbound_capacity_msat(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_outbound_capacity_msat(long val) {
        bindings.ChannelDetails_set_outbound_capacity_msat(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public long get_next_outbound_htlc_limit_msat() {
        long ret = bindings.ChannelDetails_get_next_outbound_htlc_limit_msat(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_next_outbound_htlc_limit_msat(long val) {
        bindings.ChannelDetails_set_next_outbound_htlc_limit_msat(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public long get_next_outbound_htlc_minimum_msat() {
        long ret = bindings.ChannelDetails_get_next_outbound_htlc_minimum_msat(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_next_outbound_htlc_minimum_msat(long val) {
        bindings.ChannelDetails_set_next_outbound_htlc_minimum_msat(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public long get_inbound_capacity_msat() {
        long ret = bindings.ChannelDetails_get_inbound_capacity_msat(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_inbound_capacity_msat(long val) {
        bindings.ChannelDetails_set_inbound_capacity_msat(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_u32Z get_confirmations_required() {
        long ret = bindings.ChannelDetails_get_confirmations_required(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u32Z ret_hu_conv = Option_u32Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_confirmations_required(Option_u32Z val) {
        bindings.ChannelDetails_set_confirmations_required(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_u32Z get_confirmations() {
        long ret = bindings.ChannelDetails_get_confirmations(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u32Z ret_hu_conv = Option_u32Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_confirmations(Option_u32Z val) {
        bindings.ChannelDetails_set_confirmations(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_u16Z get_force_close_spend_delay() {
        long ret = bindings.ChannelDetails_get_force_close_spend_delay(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u16Z ret_hu_conv = Option_u16Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_force_close_spend_delay(Option_u16Z val) {
        bindings.ChannelDetails_set_force_close_spend_delay(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public boolean get_is_outbound() {
        boolean ret = bindings.ChannelDetails_get_is_outbound(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_is_outbound(boolean val) {
        bindings.ChannelDetails_set_is_outbound(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public boolean get_is_channel_ready() {
        boolean ret = bindings.ChannelDetails_get_is_channel_ready(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_is_channel_ready(boolean val) {
        bindings.ChannelDetails_set_is_channel_ready(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_ChannelShutdownStateZ get_channel_shutdown_state() {
        long ret = bindings.ChannelDetails_get_channel_shutdown_state(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_ChannelShutdownStateZ ret_hu_conv = Option_ChannelShutdownStateZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_channel_shutdown_state(Option_ChannelShutdownStateZ val) {
        bindings.ChannelDetails_set_channel_shutdown_state(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public boolean get_is_usable() {
        boolean ret = bindings.ChannelDetails_get_is_usable(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_is_usable(boolean val) {
        bindings.ChannelDetails_set_is_usable(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public boolean get_is_announced() {
        boolean ret = bindings.ChannelDetails_get_is_announced(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_is_announced(boolean val) {
        bindings.ChannelDetails_set_is_announced(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_u64Z get_inbound_htlc_minimum_msat() {
        long ret = bindings.ChannelDetails_get_inbound_htlc_minimum_msat(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_inbound_htlc_minimum_msat(Option_u64Z val) {
        bindings.ChannelDetails_set_inbound_htlc_minimum_msat(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_u64Z get_inbound_htlc_maximum_msat() {
        long ret = bindings.ChannelDetails_get_inbound_htlc_maximum_msat(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_inbound_htlc_maximum_msat(Option_u64Z val) {
        bindings.ChannelDetails_set_inbound_htlc_maximum_msat(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    @Nullable
    public ChannelConfig get_config() {
        long ret = bindings.ChannelDetails_get_config(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelConfig ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelConfig(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_config(@Nullable ChannelConfig val) {
        bindings.ChannelDetails_set_config(this.ptr, val == null ? 0L : val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public InboundHTLCDetails[] get_pending_inbound_htlcs() {
        long[] ret = bindings.ChannelDetails_get_pending_inbound_htlcs(this.ptr);
        Reference.reachabilityFence(this);
        int ret_conv_20_len = ret.length;
        InboundHTLCDetails[] ret_conv_20_arr = new InboundHTLCDetails[ret_conv_20_len];
        for (int u = 0; u < ret_conv_20_len; ++u) {
            long ret_conv_20 = ret[u];
            InboundHTLCDetails ret_conv_20_hu_conv = null;
            if (ret_conv_20 < 0L || ret_conv_20 > 4096L) {
                ret_conv_20_hu_conv = new InboundHTLCDetails(null, ret_conv_20);
            }
            if (ret_conv_20_hu_conv != null) {
                ret_conv_20_hu_conv.ptrs_to.add(this);
            }
            ret_conv_20_arr[u] = ret_conv_20_hu_conv;
        }
        return ret_conv_20_arr;
    }

    public void set_pending_inbound_htlcs(InboundHTLCDetails[] val) {
        bindings.ChannelDetails_set_pending_inbound_htlcs(this.ptr, val != null ? Arrays.stream(val).mapToLong(val_conv_20 -> val_conv_20.ptr).toArray() : null);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public OutboundHTLCDetails[] get_pending_outbound_htlcs() {
        long[] ret = bindings.ChannelDetails_get_pending_outbound_htlcs(this.ptr);
        Reference.reachabilityFence(this);
        int ret_conv_21_len = ret.length;
        OutboundHTLCDetails[] ret_conv_21_arr = new OutboundHTLCDetails[ret_conv_21_len];
        for (int v = 0; v < ret_conv_21_len; ++v) {
            long ret_conv_21 = ret[v];
            OutboundHTLCDetails ret_conv_21_hu_conv = null;
            if (ret_conv_21 < 0L || ret_conv_21 > 4096L) {
                ret_conv_21_hu_conv = new OutboundHTLCDetails(null, ret_conv_21);
            }
            if (ret_conv_21_hu_conv != null) {
                ret_conv_21_hu_conv.ptrs_to.add(this);
            }
            ret_conv_21_arr[v] = ret_conv_21_hu_conv;
        }
        return ret_conv_21_arr;
    }

    public void set_pending_outbound_htlcs(OutboundHTLCDetails[] val) {
        bindings.ChannelDetails_set_pending_outbound_htlcs(this.ptr, val != null ? Arrays.stream(val).mapToLong(val_conv_21 -> val_conv_21.ptr).toArray() : null);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public static ChannelDetails of(ChannelId channel_id_arg, ChannelCounterparty counterparty_arg, @Nullable OutPoint funding_txo_arg, @Nullable ChannelTypeFeatures channel_type_arg, Option_u64Z short_channel_id_arg, Option_u64Z outbound_scid_alias_arg, Option_u64Z inbound_scid_alias_arg, long channel_value_satoshis_arg, Option_u64Z unspendable_punishment_reserve_arg, UInt128 user_channel_id_arg, Option_u32Z feerate_sat_per_1000_weight_arg, long outbound_capacity_msat_arg, long next_outbound_htlc_limit_msat_arg, long next_outbound_htlc_minimum_msat_arg, long inbound_capacity_msat_arg, Option_u32Z confirmations_required_arg, Option_u32Z confirmations_arg, Option_u16Z force_close_spend_delay_arg, boolean is_outbound_arg, boolean is_channel_ready_arg, Option_ChannelShutdownStateZ channel_shutdown_state_arg, boolean is_usable_arg, boolean is_announced_arg, Option_u64Z inbound_htlc_minimum_msat_arg, Option_u64Z inbound_htlc_maximum_msat_arg, @Nullable ChannelConfig config_arg, InboundHTLCDetails[] pending_inbound_htlcs_arg, OutboundHTLCDetails[] pending_outbound_htlcs_arg) {
        long ret = bindings.ChannelDetails_new(channel_id_arg.ptr, counterparty_arg.ptr, funding_txo_arg == null ? 0L : funding_txo_arg.ptr, channel_type_arg == null ? 0L : channel_type_arg.ptr, short_channel_id_arg.ptr, outbound_scid_alias_arg.ptr, inbound_scid_alias_arg.ptr, channel_value_satoshis_arg, unspendable_punishment_reserve_arg.ptr, user_channel_id_arg.getLEBytes(), feerate_sat_per_1000_weight_arg.ptr, outbound_capacity_msat_arg, next_outbound_htlc_limit_msat_arg, next_outbound_htlc_minimum_msat_arg, inbound_capacity_msat_arg, confirmations_required_arg.ptr, confirmations_arg.ptr, force_close_spend_delay_arg.ptr, is_outbound_arg, is_channel_ready_arg, channel_shutdown_state_arg.ptr, is_usable_arg, is_announced_arg, inbound_htlc_minimum_msat_arg.ptr, inbound_htlc_maximum_msat_arg.ptr, config_arg == null ? 0L : config_arg.ptr, pending_inbound_htlcs_arg != null ? Arrays.stream(pending_inbound_htlcs_arg).mapToLong(pending_inbound_htlcs_arg_conv_20 -> pending_inbound_htlcs_arg_conv_20.ptr).toArray() : null, pending_outbound_htlcs_arg != null ? Arrays.stream(pending_outbound_htlcs_arg).mapToLong(pending_outbound_htlcs_arg_conv_21 -> pending_outbound_htlcs_arg_conv_21.ptr).toArray() : null);
        Reference.reachabilityFence(channel_id_arg);
        Reference.reachabilityFence(counterparty_arg);
        Reference.reachabilityFence(funding_txo_arg);
        Reference.reachabilityFence(channel_type_arg);
        Reference.reachabilityFence(short_channel_id_arg);
        Reference.reachabilityFence(outbound_scid_alias_arg);
        Reference.reachabilityFence(inbound_scid_alias_arg);
        Reference.reachabilityFence(channel_value_satoshis_arg);
        Reference.reachabilityFence(unspendable_punishment_reserve_arg);
        Reference.reachabilityFence(user_channel_id_arg);
        Reference.reachabilityFence(feerate_sat_per_1000_weight_arg);
        Reference.reachabilityFence(outbound_capacity_msat_arg);
        Reference.reachabilityFence(next_outbound_htlc_limit_msat_arg);
        Reference.reachabilityFence(next_outbound_htlc_minimum_msat_arg);
        Reference.reachabilityFence(inbound_capacity_msat_arg);
        Reference.reachabilityFence(confirmations_required_arg);
        Reference.reachabilityFence(confirmations_arg);
        Reference.reachabilityFence(force_close_spend_delay_arg);
        Reference.reachabilityFence(is_outbound_arg);
        Reference.reachabilityFence(is_channel_ready_arg);
        Reference.reachabilityFence(channel_shutdown_state_arg);
        Reference.reachabilityFence(is_usable_arg);
        Reference.reachabilityFence(is_announced_arg);
        Reference.reachabilityFence(inbound_htlc_minimum_msat_arg);
        Reference.reachabilityFence(inbound_htlc_maximum_msat_arg);
        Reference.reachabilityFence(config_arg);
        Reference.reachabilityFence(pending_inbound_htlcs_arg);
        Reference.reachabilityFence(pending_outbound_htlcs_arg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelDetails ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelDetails(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    long clone_ptr() {
        long ret = bindings.ChannelDetails_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public ChannelDetails clone() {
        long ret = bindings.ChannelDetails_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelDetails ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelDetails(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Option_u64Z get_inbound_payment_scid() {
        long ret = bindings.ChannelDetails_get_inbound_payment_scid(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Option_u64Z get_outbound_payment_scid() {
        long ret = bindings.ChannelDetails_get_outbound_payment_scid(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public byte[] write() {
        byte[] ret = bindings.ChannelDetails_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_ChannelDetailsDecodeErrorZ read(byte[] ser) {
        long ret = bindings.ChannelDetails_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_ChannelDetailsDecodeErrorZ ret_hu_conv = Result_ChannelDetailsDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }
}

