/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.ldk.impl.bindings;
import org.ldk.structs.AsyncPaymentsMessageHandler;
import org.ldk.structs.BestBlock;
import org.ldk.structs.Bolt11InvoiceDescription;
import org.ldk.structs.Bolt12Invoice;
import org.ldk.structs.BroadcasterInterface;
import org.ldk.structs.ChainParameters;
import org.ldk.structs.ChannelConfig;
import org.ldk.structs.ChannelConfigUpdate;
import org.ldk.structs.ChannelDetails;
import org.ldk.structs.ChannelFeatures;
import org.ldk.structs.ChannelId;
import org.ldk.structs.ChannelMessageHandler;
import org.ldk.structs.ChannelTypeFeatures;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Confirm;
import org.ldk.structs.DNSResolverMessageHandler;
import org.ldk.structs.Destination;
import org.ldk.structs.EntropySource;
import org.ldk.structs.EventsProvider;
import org.ldk.structs.FailureCode;
import org.ldk.structs.FeeEstimator;
import org.ldk.structs.Future;
import org.ldk.structs.HumanReadableName;
import org.ldk.structs.InFlightHtlcs;
import org.ldk.structs.InitFeatures;
import org.ldk.structs.Listen;
import org.ldk.structs.Logger;
import org.ldk.structs.MessageRouter;
import org.ldk.structs.MessageSendEventsProvider;
import org.ldk.structs.NodeFeatures;
import org.ldk.structs.NodeIdLookUp;
import org.ldk.structs.NodeSigner;
import org.ldk.structs.Offer;
import org.ldk.structs.OffersMessageHandler;
import org.ldk.structs.Option_C2Tuple_PublicKeyChannelIdZZ;
import org.ldk.structs.Option_OffersContextZ;
import org.ldk.structs.Option_StrZ;
import org.ldk.structs.Option_ThirtyTwoBytesZ;
import org.ldk.structs.Option_u16Z;
import org.ldk.structs.Option_u32Z;
import org.ldk.structs.Option_u64Z;
import org.ldk.structs.OutPoint;
import org.ldk.structs.Path;
import org.ldk.structs.PhantomRouteHints;
import org.ldk.structs.RecentPaymentDetails;
import org.ldk.structs.RecipientOnionFields;
import org.ldk.structs.Refund;
import org.ldk.structs.Result_Bolt11InvoiceSignOrCreationErrorZ;
import org.ldk.structs.Result_Bolt12InvoiceBolt12SemanticErrorZ;
import org.ldk.structs.Result_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ;
import org.ldk.structs.Result_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ;
import org.ldk.structs.Result_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ;
import org.ldk.structs.Result_ChannelIdAPIErrorZ;
import org.ldk.structs.Result_NoneAPIErrorZ;
import org.ldk.structs.Result_NoneBolt12PaymentErrorZ;
import org.ldk.structs.Result_NoneBolt12SemanticErrorZ;
import org.ldk.structs.Result_NoneNoneZ;
import org.ldk.structs.Result_NoneRetryableSendFailureZ;
import org.ldk.structs.Result_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ;
import org.ldk.structs.Result_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ;
import org.ldk.structs.Result_ThirtyTwoBytesAPIErrorZ;
import org.ldk.structs.Result_ThirtyTwoBytesNoneZ;
import org.ldk.structs.Result_ThirtyTwoBytesRetryableSendFailureZ;
import org.ldk.structs.Retry;
import org.ldk.structs.Route;
import org.ldk.structs.RouteParameters;
import org.ldk.structs.Router;
import org.ldk.structs.ShutdownScript;
import org.ldk.structs.SignerProvider;
import org.ldk.structs.TwoTuple_ChannelIdPublicKeyZ;
import org.ldk.structs.UserConfig;
import org.ldk.structs.Watch;
import org.ldk.util.InternalUtils;
import org.ldk.util.UInt128;

public class ChannelManager
extends CommonBase {
    ChannelManager(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.ChannelManager_free(this.ptr);
        }
    }

    public static ChannelManager of(FeeEstimator fee_est, Watch chain_monitor, BroadcasterInterface tx_broadcaster, Router router, MessageRouter message_router, Logger logger, EntropySource entropy_source, NodeSigner node_signer, SignerProvider signer_provider, UserConfig config, ChainParameters params, int current_timestamp) {
        long ret = bindings.ChannelManager_new(fee_est.ptr, chain_monitor.ptr, tx_broadcaster.ptr, router.ptr, message_router.ptr, logger.ptr, entropy_source.ptr, node_signer.ptr, signer_provider.ptr, config.ptr, params.ptr, current_timestamp);
        Reference.reachabilityFence(fee_est);
        Reference.reachabilityFence(chain_monitor);
        Reference.reachabilityFence(tx_broadcaster);
        Reference.reachabilityFence(router);
        Reference.reachabilityFence(message_router);
        Reference.reachabilityFence(logger);
        Reference.reachabilityFence(entropy_source);
        Reference.reachabilityFence(node_signer);
        Reference.reachabilityFence(signer_provider);
        Reference.reachabilityFence(config);
        Reference.reachabilityFence(params);
        Reference.reachabilityFence(current_timestamp);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelManager ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelManager(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(fee_est);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(chain_monitor);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(tx_broadcaster);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(router);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(message_router);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(logger);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(entropy_source);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(node_signer);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(signer_provider);
        }
        return ret_hu_conv;
    }

    public UserConfig get_current_default_configuration() {
        long ret = bindings.ChannelManager_get_current_default_configuration(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        UserConfig ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new UserConfig(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Result_ChannelIdAPIErrorZ create_channel(byte[] their_network_key, long channel_value_satoshis, long push_msat, UInt128 user_channel_id, @Nullable ChannelId temporary_channel_id, @Nullable UserConfig override_config) {
        long ret = bindings.ChannelManager_create_channel(this.ptr, InternalUtils.check_arr_len(their_network_key, 33), channel_value_satoshis, push_msat, user_channel_id.getLEBytes(), temporary_channel_id == null ? 0L : temporary_channel_id.ptr, override_config == null ? 0L : override_config.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(their_network_key);
        Reference.reachabilityFence(channel_value_satoshis);
        Reference.reachabilityFence(push_msat);
        Reference.reachabilityFence(user_channel_id);
        Reference.reachabilityFence(temporary_channel_id);
        Reference.reachabilityFence(override_config);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_ChannelIdAPIErrorZ ret_hu_conv = Result_ChannelIdAPIErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public ChannelDetails[] list_channels() {
        long[] ret = bindings.ChannelManager_list_channels(this.ptr);
        Reference.reachabilityFence(this);
        int ret_conv_16_len = ret.length;
        ChannelDetails[] ret_conv_16_arr = new ChannelDetails[ret_conv_16_len];
        for (int q = 0; q < ret_conv_16_len; ++q) {
            long ret_conv_16 = ret[q];
            ChannelDetails ret_conv_16_hu_conv = null;
            if (ret_conv_16 < 0L || ret_conv_16 > 4096L) {
                ret_conv_16_hu_conv = new ChannelDetails(null, ret_conv_16);
            }
            if (ret_conv_16_hu_conv != null) {
                ret_conv_16_hu_conv.ptrs_to.add(this);
            }
            ret_conv_16_arr[q] = ret_conv_16_hu_conv;
        }
        return ret_conv_16_arr;
    }

    public ChannelDetails[] list_usable_channels() {
        long[] ret = bindings.ChannelManager_list_usable_channels(this.ptr);
        Reference.reachabilityFence(this);
        int ret_conv_16_len = ret.length;
        ChannelDetails[] ret_conv_16_arr = new ChannelDetails[ret_conv_16_len];
        for (int q = 0; q < ret_conv_16_len; ++q) {
            long ret_conv_16 = ret[q];
            ChannelDetails ret_conv_16_hu_conv = null;
            if (ret_conv_16 < 0L || ret_conv_16 > 4096L) {
                ret_conv_16_hu_conv = new ChannelDetails(null, ret_conv_16);
            }
            if (ret_conv_16_hu_conv != null) {
                ret_conv_16_hu_conv.ptrs_to.add(this);
            }
            ret_conv_16_arr[q] = ret_conv_16_hu_conv;
        }
        return ret_conv_16_arr;
    }

    public ChannelDetails[] list_channels_with_counterparty(byte[] counterparty_node_id) {
        long[] ret = bindings.ChannelManager_list_channels_with_counterparty(this.ptr, InternalUtils.check_arr_len(counterparty_node_id, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(counterparty_node_id);
        int ret_conv_16_len = ret.length;
        ChannelDetails[] ret_conv_16_arr = new ChannelDetails[ret_conv_16_len];
        for (int q = 0; q < ret_conv_16_len; ++q) {
            long ret_conv_16 = ret[q];
            ChannelDetails ret_conv_16_hu_conv = null;
            if (ret_conv_16 < 0L || ret_conv_16 > 4096L) {
                ret_conv_16_hu_conv = new ChannelDetails(null, ret_conv_16);
            }
            if (ret_conv_16_hu_conv != null) {
                ret_conv_16_hu_conv.ptrs_to.add(this);
            }
            ret_conv_16_arr[q] = ret_conv_16_hu_conv;
        }
        return ret_conv_16_arr;
    }

    public RecentPaymentDetails[] list_recent_payments() {
        long[] ret = bindings.ChannelManager_list_recent_payments(this.ptr);
        Reference.reachabilityFence(this);
        int ret_conv_22_len = ret.length;
        RecentPaymentDetails[] ret_conv_22_arr = new RecentPaymentDetails[ret_conv_22_len];
        for (int w = 0; w < ret_conv_22_len; ++w) {
            long ret_conv_22 = ret[w];
            RecentPaymentDetails ret_conv_22_hu_conv = RecentPaymentDetails.constr_from_ptr(ret_conv_22);
            if (ret_conv_22_hu_conv != null) {
                ret_conv_22_hu_conv.ptrs_to.add(this);
            }
            ret_conv_22_arr[w] = ret_conv_22_hu_conv;
        }
        return ret_conv_22_arr;
    }

    public Result_NoneAPIErrorZ close_channel(ChannelId channel_id, byte[] counterparty_node_id) {
        long ret = bindings.ChannelManager_close_channel(this.ptr, channel_id.ptr, InternalUtils.check_arr_len(counterparty_node_id, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(channel_id);
        Reference.reachabilityFence(counterparty_node_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneAPIErrorZ ret_hu_conv = Result_NoneAPIErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(channel_id);
        }
        return ret_hu_conv;
    }

    public Result_NoneAPIErrorZ close_channel_with_feerate_and_script(ChannelId channel_id, byte[] counterparty_node_id, Option_u32Z target_feerate_sats_per_1000_weight, @Nullable ShutdownScript shutdown_script) {
        long ret = bindings.ChannelManager_close_channel_with_feerate_and_script(this.ptr, channel_id.ptr, InternalUtils.check_arr_len(counterparty_node_id, 33), target_feerate_sats_per_1000_weight.ptr, shutdown_script == null ? 0L : shutdown_script.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(channel_id);
        Reference.reachabilityFence(counterparty_node_id);
        Reference.reachabilityFence(target_feerate_sats_per_1000_weight);
        Reference.reachabilityFence(shutdown_script);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneAPIErrorZ ret_hu_conv = Result_NoneAPIErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(channel_id);
        }
        return ret_hu_conv;
    }

    public Result_NoneAPIErrorZ force_close_broadcasting_latest_txn(ChannelId channel_id, byte[] counterparty_node_id, String error_message) {
        long ret = bindings.ChannelManager_force_close_broadcasting_latest_txn(this.ptr, channel_id.ptr, InternalUtils.check_arr_len(counterparty_node_id, 33), error_message);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(channel_id);
        Reference.reachabilityFence(counterparty_node_id);
        Reference.reachabilityFence(error_message);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneAPIErrorZ ret_hu_conv = Result_NoneAPIErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(channel_id);
        }
        return ret_hu_conv;
    }

    public Result_NoneAPIErrorZ force_close_without_broadcasting_txn(ChannelId channel_id, byte[] counterparty_node_id, String error_message) {
        long ret = bindings.ChannelManager_force_close_without_broadcasting_txn(this.ptr, channel_id.ptr, InternalUtils.check_arr_len(counterparty_node_id, 33), error_message);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(channel_id);
        Reference.reachabilityFence(counterparty_node_id);
        Reference.reachabilityFence(error_message);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneAPIErrorZ ret_hu_conv = Result_NoneAPIErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(channel_id);
        }
        return ret_hu_conv;
    }

    public void force_close_all_channels_broadcasting_latest_txn(String error_message) {
        bindings.ChannelManager_force_close_all_channels_broadcasting_latest_txn(this.ptr, error_message);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(error_message);
    }

    public void force_close_all_channels_without_broadcasting_txn(String error_message) {
        bindings.ChannelManager_force_close_all_channels_without_broadcasting_txn(this.ptr, error_message);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(error_message);
    }

    public Result_NoneRetryableSendFailureZ send_payment_with_route(Route route, byte[] payment_hash, RecipientOnionFields recipient_onion, byte[] payment_id) {
        long ret = bindings.ChannelManager_send_payment_with_route(this.ptr, route.ptr, InternalUtils.check_arr_len(payment_hash, 32), recipient_onion.ptr, InternalUtils.check_arr_len(payment_id, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(route);
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(recipient_onion);
        Reference.reachabilityFence(payment_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneRetryableSendFailureZ ret_hu_conv = Result_NoneRetryableSendFailureZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_NoneRetryableSendFailureZ send_payment(byte[] payment_hash, RecipientOnionFields recipient_onion, byte[] payment_id, RouteParameters route_params, Retry retry_strategy) {
        long ret = bindings.ChannelManager_send_payment(this.ptr, InternalUtils.check_arr_len(payment_hash, 32), recipient_onion.ptr, InternalUtils.check_arr_len(payment_id, 32), route_params.ptr, retry_strategy.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(recipient_onion);
        Reference.reachabilityFence(payment_id);
        Reference.reachabilityFence(route_params);
        Reference.reachabilityFence(retry_strategy);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneRetryableSendFailureZ ret_hu_conv = Result_NoneRetryableSendFailureZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_NoneBolt12PaymentErrorZ send_payment_for_bolt12_invoice(Bolt12Invoice invoice, Option_OffersContextZ context) {
        long ret = bindings.ChannelManager_send_payment_for_bolt12_invoice(this.ptr, invoice.ptr, context.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(invoice);
        Reference.reachabilityFence(context);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneBolt12PaymentErrorZ ret_hu_conv = Result_NoneBolt12PaymentErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(invoice);
        }
        return ret_hu_conv;
    }

    public void abandon_payment(byte[] payment_id) {
        bindings.ChannelManager_abandon_payment(this.ptr, InternalUtils.check_arr_len(payment_id, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(payment_id);
    }

    public Result_ThirtyTwoBytesRetryableSendFailureZ send_spontaneous_payment(Option_ThirtyTwoBytesZ payment_preimage, RecipientOnionFields recipient_onion, byte[] payment_id, RouteParameters route_params, Retry retry_strategy) {
        long ret = bindings.ChannelManager_send_spontaneous_payment(this.ptr, payment_preimage.ptr, recipient_onion.ptr, InternalUtils.check_arr_len(payment_id, 32), route_params.ptr, retry_strategy.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(payment_preimage);
        Reference.reachabilityFence(recipient_onion);
        Reference.reachabilityFence(payment_id);
        Reference.reachabilityFence(route_params);
        Reference.reachabilityFence(retry_strategy);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_ThirtyTwoBytesRetryableSendFailureZ ret_hu_conv = Result_ThirtyTwoBytesRetryableSendFailureZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ send_probe(Path path) {
        long ret = bindings.ChannelManager_send_probe(this.ptr, path.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(path);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ ret_hu_conv = Result_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZProbeSendFailureZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ send_spontaneous_preflight_probes(byte[] node_id, long amount_msat, int final_cltv_expiry_delta, Option_u64Z liquidity_limit_multiplier) {
        long ret = bindings.ChannelManager_send_spontaneous_preflight_probes(this.ptr, InternalUtils.check_arr_len(node_id, 33), amount_msat, final_cltv_expiry_delta, liquidity_limit_multiplier.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(amount_msat);
        Reference.reachabilityFence(final_cltv_expiry_delta);
        Reference.reachabilityFence(liquidity_limit_multiplier);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ ret_hu_conv = Result_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ send_preflight_probes(RouteParameters route_params, Option_u64Z liquidity_limit_multiplier) {
        long ret = bindings.ChannelManager_send_preflight_probes(this.ptr, route_params.ptr, liquidity_limit_multiplier.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(route_params);
        Reference.reachabilityFence(liquidity_limit_multiplier);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ ret_hu_conv = Result_CVec_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZZProbeSendFailureZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_NoneAPIErrorZ funding_transaction_generated(ChannelId temporary_channel_id, byte[] counterparty_node_id, byte[] funding_transaction) {
        long ret = bindings.ChannelManager_funding_transaction_generated(this.ptr, temporary_channel_id.ptr, InternalUtils.check_arr_len(counterparty_node_id, 33), funding_transaction);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(temporary_channel_id);
        Reference.reachabilityFence(counterparty_node_id);
        Reference.reachabilityFence(funding_transaction);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneAPIErrorZ ret_hu_conv = Result_NoneAPIErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_NoneAPIErrorZ unsafe_manual_funding_transaction_generated(ChannelId temporary_channel_id, byte[] counterparty_node_id, OutPoint funding) {
        long ret = bindings.ChannelManager_unsafe_manual_funding_transaction_generated(this.ptr, temporary_channel_id.ptr, InternalUtils.check_arr_len(counterparty_node_id, 33), funding.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(temporary_channel_id);
        Reference.reachabilityFence(counterparty_node_id);
        Reference.reachabilityFence(funding);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneAPIErrorZ ret_hu_conv = Result_NoneAPIErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_NoneAPIErrorZ batch_funding_transaction_generated(TwoTuple_ChannelIdPublicKeyZ[] temporary_channels, byte[] funding_transaction) {
        long ret = bindings.ChannelManager_batch_funding_transaction_generated(this.ptr, temporary_channels != null ? Arrays.stream(temporary_channels).mapToLong(temporary_channels_conv_30 -> temporary_channels_conv_30.ptr).toArray() : null, funding_transaction);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(temporary_channels);
        Reference.reachabilityFence(funding_transaction);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneAPIErrorZ ret_hu_conv = Result_NoneAPIErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_NoneAPIErrorZ update_partial_channel_config(byte[] counterparty_node_id, ChannelId[] channel_ids, ChannelConfigUpdate config_update) {
        long ret = bindings.ChannelManager_update_partial_channel_config(this.ptr, InternalUtils.check_arr_len(counterparty_node_id, 33), channel_ids != null ? Arrays.stream(channel_ids).mapToLong(channel_ids_conv_11 -> channel_ids_conv_11.ptr).toArray() : null, config_update.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(counterparty_node_id);
        Reference.reachabilityFence(channel_ids);
        Reference.reachabilityFence(config_update);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneAPIErrorZ ret_hu_conv = Result_NoneAPIErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(config_update);
        }
        return ret_hu_conv;
    }

    public Result_NoneAPIErrorZ update_channel_config(byte[] counterparty_node_id, ChannelId[] channel_ids, ChannelConfig config) {
        long ret = bindings.ChannelManager_update_channel_config(this.ptr, InternalUtils.check_arr_len(counterparty_node_id, 33), channel_ids != null ? Arrays.stream(channel_ids).mapToLong(channel_ids_conv_11 -> channel_ids_conv_11.ptr).toArray() : null, config.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(counterparty_node_id);
        Reference.reachabilityFence(channel_ids);
        Reference.reachabilityFence(config);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneAPIErrorZ ret_hu_conv = Result_NoneAPIErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(config);
        }
        return ret_hu_conv;
    }

    public Result_NoneAPIErrorZ forward_intercepted_htlc(byte[] intercept_id, ChannelId next_hop_channel_id, byte[] next_node_id, long amt_to_forward_msat) {
        long ret = bindings.ChannelManager_forward_intercepted_htlc(this.ptr, InternalUtils.check_arr_len(intercept_id, 32), next_hop_channel_id.ptr, InternalUtils.check_arr_len(next_node_id, 33), amt_to_forward_msat);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(intercept_id);
        Reference.reachabilityFence(next_hop_channel_id);
        Reference.reachabilityFence(next_node_id);
        Reference.reachabilityFence(amt_to_forward_msat);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneAPIErrorZ ret_hu_conv = Result_NoneAPIErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(next_hop_channel_id);
        }
        return ret_hu_conv;
    }

    public Result_NoneAPIErrorZ fail_intercepted_htlc(byte[] intercept_id) {
        long ret = bindings.ChannelManager_fail_intercepted_htlc(this.ptr, InternalUtils.check_arr_len(intercept_id, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(intercept_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneAPIErrorZ ret_hu_conv = Result_NoneAPIErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public void process_pending_htlc_forwards() {
        bindings.ChannelManager_process_pending_htlc_forwards(this.ptr);
        Reference.reachabilityFence(this);
    }

    public void timer_tick_occurred() {
        bindings.ChannelManager_timer_tick_occurred(this.ptr);
        Reference.reachabilityFence(this);
    }

    public void fail_htlc_backwards(byte[] payment_hash) {
        bindings.ChannelManager_fail_htlc_backwards(this.ptr, InternalUtils.check_arr_len(payment_hash, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(payment_hash);
    }

    public void fail_htlc_backwards_with_reason(byte[] payment_hash, FailureCode failure_code) {
        bindings.ChannelManager_fail_htlc_backwards_with_reason(this.ptr, InternalUtils.check_arr_len(payment_hash, 32), failure_code.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(failure_code);
    }

    public void claim_funds(byte[] payment_preimage) {
        bindings.ChannelManager_claim_funds(this.ptr, InternalUtils.check_arr_len(payment_preimage, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(payment_preimage);
    }

    public void claim_funds_with_known_custom_tlvs(byte[] payment_preimage) {
        bindings.ChannelManager_claim_funds_with_known_custom_tlvs(this.ptr, InternalUtils.check_arr_len(payment_preimage, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(payment_preimage);
    }

    public byte[] get_our_node_id() {
        byte[] ret = bindings.ChannelManager_get_our_node_id(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public Result_NoneAPIErrorZ accept_inbound_channel(ChannelId temporary_channel_id, byte[] counterparty_node_id, UInt128 user_channel_id) {
        long ret = bindings.ChannelManager_accept_inbound_channel(this.ptr, temporary_channel_id.ptr, InternalUtils.check_arr_len(counterparty_node_id, 33), user_channel_id.getLEBytes());
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(temporary_channel_id);
        Reference.reachabilityFence(counterparty_node_id);
        Reference.reachabilityFence(user_channel_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneAPIErrorZ ret_hu_conv = Result_NoneAPIErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(temporary_channel_id);
        }
        return ret_hu_conv;
    }

    public Result_NoneAPIErrorZ accept_inbound_channel_from_trusted_peer_0conf(ChannelId temporary_channel_id, byte[] counterparty_node_id, UInt128 user_channel_id) {
        long ret = bindings.ChannelManager_accept_inbound_channel_from_trusted_peer_0conf(this.ptr, temporary_channel_id.ptr, InternalUtils.check_arr_len(counterparty_node_id, 33), user_channel_id.getLEBytes());
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(temporary_channel_id);
        Reference.reachabilityFence(counterparty_node_id);
        Reference.reachabilityFence(user_channel_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneAPIErrorZ ret_hu_conv = Result_NoneAPIErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(temporary_channel_id);
        }
        return ret_hu_conv;
    }

    public void signer_unblocked(Option_C2Tuple_PublicKeyChannelIdZZ channel_opt) {
        bindings.ChannelManager_signer_unblocked(this.ptr, channel_opt.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(channel_opt);
    }

    public Result_Bolt11InvoiceSignOrCreationErrorZ create_bolt11_invoice(Option_u64Z params_amount_msats_arg, Bolt11InvoiceDescription params_description_arg, Option_u32Z params_invoice_expiry_delta_secs_arg, Option_u16Z params_min_final_cltv_expiry_delta_arg, Option_ThirtyTwoBytesZ params_payment_hash_arg) {
        long ret = bindings.ChannelManager_create_bolt11_invoice(this.ptr, bindings.Bolt11InvoiceParameters_new(params_amount_msats_arg.ptr, params_description_arg.ptr, params_invoice_expiry_delta_secs_arg.ptr, params_min_final_cltv_expiry_delta_arg.ptr, params_payment_hash_arg.ptr));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(params_amount_msats_arg);
        Reference.reachabilityFence(params_description_arg);
        Reference.reachabilityFence(params_invoice_expiry_delta_secs_arg);
        Reference.reachabilityFence(params_min_final_cltv_expiry_delta_arg);
        Reference.reachabilityFence(params_payment_hash_arg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_Bolt11InvoiceSignOrCreationErrorZ ret_hu_conv = Result_Bolt11InvoiceSignOrCreationErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ create_offer_builder(Option_u64Z absolute_expiry) {
        long ret = bindings.ChannelManager_create_offer_builder(this.ptr, absolute_expiry.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(absolute_expiry);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ ret_hu_conv = Result_OfferWithDerivedMetadataBuilderBolt12SemanticErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ create_refund_builder(long amount_msats, long absolute_expiry, byte[] payment_id, Retry retry_strategy, Option_u64Z max_total_routing_fee_msat) {
        long ret = bindings.ChannelManager_create_refund_builder(this.ptr, amount_msats, absolute_expiry, InternalUtils.check_arr_len(payment_id, 32), retry_strategy.ptr, max_total_routing_fee_msat.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(amount_msats);
        Reference.reachabilityFence(absolute_expiry);
        Reference.reachabilityFence(payment_id);
        Reference.reachabilityFence(retry_strategy);
        Reference.reachabilityFence(max_total_routing_fee_msat);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ ret_hu_conv = Result_RefundMaybeWithDerivedMetadataBuilderBolt12SemanticErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_NoneBolt12SemanticErrorZ pay_for_offer(Offer offer, Option_u64Z quantity, Option_u64Z amount_msats, Option_StrZ payer_note, byte[] payment_id, Retry retry_strategy, Option_u64Z max_total_routing_fee_msat) {
        long ret = bindings.ChannelManager_pay_for_offer(this.ptr, offer.ptr, quantity.ptr, amount_msats.ptr, payer_note.ptr, InternalUtils.check_arr_len(payment_id, 32), retry_strategy.ptr, max_total_routing_fee_msat.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(offer);
        Reference.reachabilityFence(quantity);
        Reference.reachabilityFence(amount_msats);
        Reference.reachabilityFence(payer_note);
        Reference.reachabilityFence(payment_id);
        Reference.reachabilityFence(retry_strategy);
        Reference.reachabilityFence(max_total_routing_fee_msat);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneBolt12SemanticErrorZ ret_hu_conv = Result_NoneBolt12SemanticErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(offer);
        }
        return ret_hu_conv;
    }

    public Result_Bolt12InvoiceBolt12SemanticErrorZ request_refund_payment(Refund refund) {
        long ret = bindings.ChannelManager_request_refund_payment(this.ptr, refund.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(refund);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_Bolt12InvoiceBolt12SemanticErrorZ ret_hu_conv = Result_Bolt12InvoiceBolt12SemanticErrorZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(refund);
        }
        return ret_hu_conv;
    }

    public Result_NoneNoneZ pay_for_offer_from_human_readable_name(HumanReadableName name, long amount_msats, byte[] payment_id, Retry retry_strategy, Option_u64Z max_total_routing_fee_msat, Destination[] dns_resolvers) {
        long ret = bindings.ChannelManager_pay_for_offer_from_human_readable_name(this.ptr, name.ptr, amount_msats, InternalUtils.check_arr_len(payment_id, 32), retry_strategy.ptr, max_total_routing_fee_msat.ptr, dns_resolvers != null ? Arrays.stream(dns_resolvers).mapToLong(dns_resolvers_conv_13 -> dns_resolvers_conv_13.ptr).toArray() : null);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(name);
        Reference.reachabilityFence(amount_msats);
        Reference.reachabilityFence(payment_id);
        Reference.reachabilityFence(retry_strategy);
        Reference.reachabilityFence(max_total_routing_fee_msat);
        Reference.reachabilityFence(dns_resolvers);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneNoneZ ret_hu_conv = Result_NoneNoneZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ create_inbound_payment(Option_u64Z min_value_msat, int invoice_expiry_delta_secs, Option_u16Z min_final_cltv_expiry_delta) {
        long ret = bindings.ChannelManager_create_inbound_payment(this.ptr, min_value_msat.ptr, invoice_expiry_delta_secs, min_final_cltv_expiry_delta.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(min_value_msat);
        Reference.reachabilityFence(invoice_expiry_delta_secs);
        Reference.reachabilityFence(min_final_cltv_expiry_delta);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ ret_hu_conv = Result_C2Tuple_ThirtyTwoBytesThirtyTwoBytesZNoneZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_ThirtyTwoBytesNoneZ create_inbound_payment_for_hash(byte[] payment_hash, Option_u64Z min_value_msat, int invoice_expiry_delta_secs, Option_u16Z min_final_cltv_expiry) {
        long ret = bindings.ChannelManager_create_inbound_payment_for_hash(this.ptr, InternalUtils.check_arr_len(payment_hash, 32), min_value_msat.ptr, invoice_expiry_delta_secs, min_final_cltv_expiry.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(min_value_msat);
        Reference.reachabilityFence(invoice_expiry_delta_secs);
        Reference.reachabilityFence(min_final_cltv_expiry);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_ThirtyTwoBytesNoneZ ret_hu_conv = Result_ThirtyTwoBytesNoneZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_ThirtyTwoBytesAPIErrorZ get_payment_preimage(byte[] payment_hash, byte[] payment_secret) {
        long ret = bindings.ChannelManager_get_payment_preimage(this.ptr, InternalUtils.check_arr_len(payment_hash, 32), InternalUtils.check_arr_len(payment_secret, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(payment_secret);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_ThirtyTwoBytesAPIErrorZ ret_hu_conv = Result_ThirtyTwoBytesAPIErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public long get_phantom_scid() {
        long ret = bindings.ChannelManager_get_phantom_scid(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public PhantomRouteHints get_phantom_route_hints() {
        long ret = bindings.ChannelManager_get_phantom_route_hints(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        PhantomRouteHints ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new PhantomRouteHints(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public long get_intercept_scid() {
        long ret = bindings.ChannelManager_get_intercept_scid(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public InFlightHtlcs compute_inflight_htlcs() {
        long ret = bindings.ChannelManager_compute_inflight_htlcs(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        InFlightHtlcs ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new InFlightHtlcs(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public MessageSendEventsProvider as_MessageSendEventsProvider() {
        long ret = bindings.ChannelManager_as_MessageSendEventsProvider(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        MessageSendEventsProvider ret_hu_conv = new MessageSendEventsProvider(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public EventsProvider as_EventsProvider() {
        long ret = bindings.ChannelManager_as_EventsProvider(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        EventsProvider ret_hu_conv = new EventsProvider(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Listen as_Listen() {
        long ret = bindings.ChannelManager_as_Listen(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Listen ret_hu_conv = new Listen(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Confirm as_Confirm() {
        long ret = bindings.ChannelManager_as_Confirm(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Confirm ret_hu_conv = new Confirm(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Future get_event_or_persistence_needed_future() {
        long ret = bindings.ChannelManager_get_event_or_persistence_needed_future(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Future ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new Future(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public boolean get_and_clear_needs_persistence() {
        boolean ret = bindings.ChannelManager_get_and_clear_needs_persistence(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public BestBlock current_best_block() {
        long ret = bindings.ChannelManager_current_best_block(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        BestBlock ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new BestBlock(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public NodeFeatures node_features() {
        long ret = bindings.ChannelManager_node_features(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        NodeFeatures ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new NodeFeatures(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public ChannelFeatures channel_features() {
        long ret = bindings.ChannelManager_channel_features(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelFeatures ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelFeatures(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public ChannelTypeFeatures channel_type_features() {
        long ret = bindings.ChannelManager_channel_type_features(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelTypeFeatures ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelTypeFeatures(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public InitFeatures init_features() {
        long ret = bindings.ChannelManager_init_features(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        InitFeatures ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new InitFeatures(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public ChannelMessageHandler as_ChannelMessageHandler() {
        long ret = bindings.ChannelManager_as_ChannelMessageHandler(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelMessageHandler ret_hu_conv = new ChannelMessageHandler(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public OffersMessageHandler as_OffersMessageHandler() {
        long ret = bindings.ChannelManager_as_OffersMessageHandler(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OffersMessageHandler ret_hu_conv = new OffersMessageHandler(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public AsyncPaymentsMessageHandler as_AsyncPaymentsMessageHandler() {
        long ret = bindings.ChannelManager_as_AsyncPaymentsMessageHandler(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        AsyncPaymentsMessageHandler ret_hu_conv = new AsyncPaymentsMessageHandler(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public DNSResolverMessageHandler as_DNSResolverMessageHandler() {
        long ret = bindings.ChannelManager_as_DNSResolverMessageHandler(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        DNSResolverMessageHandler ret_hu_conv = new DNSResolverMessageHandler(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public NodeIdLookUp as_NodeIdLookUp() {
        long ret = bindings.ChannelManager_as_NodeIdLookUp(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        NodeIdLookUp ret_hu_conv = new NodeIdLookUp(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public byte[] write() {
        byte[] ret = bindings.ChannelManager_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }
}

