/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.ldk.impl.bindings;
import org.ldk.structs.Balance;
import org.ldk.structs.BestBlock;
import org.ldk.structs.BroadcasterInterface;
import org.ldk.structs.ChannelId;
import org.ldk.structs.ChannelMonitorUpdate;
import org.ldk.structs.CommitmentTransaction;
import org.ldk.structs.CommonBase;
import org.ldk.structs.EventHandler;
import org.ldk.structs.FeeEstimator;
import org.ldk.structs.Filter;
import org.ldk.structs.Logger;
import org.ldk.structs.MonitorEvent;
import org.ldk.structs.Result_NoneNoneZ;
import org.ldk.structs.Result_NoneReplayEventZ;
import org.ldk.structs.Result_TransactionNoneZ;
import org.ldk.structs.SpendableOutputDescriptor;
import org.ldk.structs.ThreeTuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ;
import org.ldk.structs.TwoTuple_OutPointCVec_u8ZZ;
import org.ldk.structs.TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ;
import org.ldk.structs.TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ;
import org.ldk.structs.TwoTuple_boolboolZ;
import org.ldk.structs.TwoTuple_usizeTransactionZ;
import org.ldk.util.InternalUtils;

public class ChannelMonitor
extends CommonBase {
    ChannelMonitor(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.ChannelMonitor_free(this.ptr);
        }
    }

    long clone_ptr() {
        long ret = bindings.ChannelMonitor_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public ChannelMonitor clone() {
        long ret = bindings.ChannelMonitor_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelMonitor ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelMonitor(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public byte[] write() {
        byte[] ret = bindings.ChannelMonitor_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public Result_NoneNoneZ update_monitor(ChannelMonitorUpdate updates, BroadcasterInterface broadcaster, FeeEstimator fee_estimator, Logger logger) {
        long ret = bindings.ChannelMonitor_update_monitor(this.ptr, updates.ptr, broadcaster.ptr, fee_estimator.ptr, logger.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(updates);
        Reference.reachabilityFence(broadcaster);
        Reference.reachabilityFence(fee_estimator);
        Reference.reachabilityFence(logger);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneNoneZ ret_hu_conv = Result_NoneNoneZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(updates);
        }
        if (this != null) {
            this.ptrs_to.add(broadcaster);
        }
        if (this != null) {
            this.ptrs_to.add(fee_estimator);
        }
        if (this != null) {
            this.ptrs_to.add(logger);
        }
        return ret_hu_conv;
    }

    public long get_latest_update_id() {
        long ret = bindings.ChannelMonitor_get_latest_update_id(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public TwoTuple_OutPointCVec_u8ZZ get_funding_txo() {
        long ret = bindings.ChannelMonitor_get_funding_txo(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        TwoTuple_OutPointCVec_u8ZZ ret_hu_conv = new TwoTuple_OutPointCVec_u8ZZ(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public ChannelId channel_id() {
        long ret = bindings.ChannelMonitor_channel_id(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelId ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelId(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ[] get_outputs_to_watch() {
        long[] ret = bindings.ChannelMonitor_get_outputs_to_watch(this.ptr);
        Reference.reachabilityFence(this);
        int ret_conv_52_len = ret.length;
        TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ[] ret_conv_52_arr = new TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ[ret_conv_52_len];
        for (int a = 0; a < ret_conv_52_len; ++a) {
            long ret_conv_52 = ret[a];
            TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ ret_conv_52_hu_conv = new TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32CVec_u8ZZZZ(null, ret_conv_52);
            if (ret_conv_52_hu_conv != null) {
                ret_conv_52_hu_conv.ptrs_to.add(this);
            }
            ret_conv_52_arr[a] = ret_conv_52_hu_conv;
        }
        return ret_conv_52_arr;
    }

    public void load_outputs_to_watch(Filter filter, Logger logger) {
        bindings.ChannelMonitor_load_outputs_to_watch(this.ptr, filter.ptr, logger.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(filter);
        Reference.reachabilityFence(logger);
        if (this != null) {
            this.ptrs_to.add(filter);
        }
        if (this != null) {
            this.ptrs_to.add(logger);
        }
    }

    public MonitorEvent[] get_and_clear_pending_monitor_events() {
        long[] ret = bindings.ChannelMonitor_get_and_clear_pending_monitor_events(this.ptr);
        Reference.reachabilityFence(this);
        int ret_conv_14_len = ret.length;
        MonitorEvent[] ret_conv_14_arr = new MonitorEvent[ret_conv_14_len];
        for (int o = 0; o < ret_conv_14_len; ++o) {
            long ret_conv_14 = ret[o];
            MonitorEvent ret_conv_14_hu_conv = MonitorEvent.constr_from_ptr(ret_conv_14);
            if (ret_conv_14_hu_conv != null) {
                ret_conv_14_hu_conv.ptrs_to.add(this);
            }
            ret_conv_14_arr[o] = ret_conv_14_hu_conv;
        }
        return ret_conv_14_arr;
    }

    public Result_NoneReplayEventZ process_pending_events(EventHandler handler, Logger logger) {
        long ret = bindings.ChannelMonitor_process_pending_events(this.ptr, handler.ptr, logger.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(handler);
        Reference.reachabilityFence(logger);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneReplayEventZ ret_hu_conv = Result_NoneReplayEventZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(handler);
        }
        if (this != null) {
            this.ptrs_to.add(logger);
        }
        return ret_hu_conv;
    }

    @Nullable
    public CommitmentTransaction initial_counterparty_commitment_tx() {
        long ret = bindings.ChannelMonitor_initial_counterparty_commitment_tx(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        CommitmentTransaction ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new CommitmentTransaction(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public CommitmentTransaction[] counterparty_commitment_txs_from_update(ChannelMonitorUpdate update) {
        long[] ret = bindings.ChannelMonitor_counterparty_commitment_txs_from_update(this.ptr, update.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(update);
        int ret_conv_23_len = ret.length;
        CommitmentTransaction[] ret_conv_23_arr = new CommitmentTransaction[ret_conv_23_len];
        for (int x = 0; x < ret_conv_23_len; ++x) {
            long ret_conv_23 = ret[x];
            CommitmentTransaction ret_conv_23_hu_conv = null;
            if (ret_conv_23 < 0L || ret_conv_23 > 4096L) {
                ret_conv_23_hu_conv = new CommitmentTransaction(null, ret_conv_23);
            }
            if (ret_conv_23_hu_conv != null) {
                ret_conv_23_hu_conv.ptrs_to.add(this);
            }
            ret_conv_23_arr[x] = ret_conv_23_hu_conv;
        }
        if (this != null) {
            this.ptrs_to.add(update);
        }
        return ret_conv_23_arr;
    }

    public Result_TransactionNoneZ sign_to_local_justice_tx(byte[] justice_tx, long input_idx, long value, long commitment_number) {
        long ret = bindings.ChannelMonitor_sign_to_local_justice_tx(this.ptr, justice_tx, input_idx, value, commitment_number);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(justice_tx);
        Reference.reachabilityFence(input_idx);
        Reference.reachabilityFence(value);
        Reference.reachabilityFence(commitment_number);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_TransactionNoneZ ret_hu_conv = Result_TransactionNoneZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    @Nullable
    public byte[] get_counterparty_node_id() {
        byte[] ret = bindings.ChannelMonitor_get_counterparty_node_id(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void broadcast_latest_holder_commitment_txn(BroadcasterInterface broadcaster, FeeEstimator fee_estimator, Logger logger) {
        bindings.ChannelMonitor_broadcast_latest_holder_commitment_txn(this.ptr, broadcaster.ptr, fee_estimator.ptr, logger.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(broadcaster);
        Reference.reachabilityFence(fee_estimator);
        Reference.reachabilityFence(logger);
        if (this != null) {
            this.ptrs_to.add(broadcaster);
        }
        if (this != null) {
            this.ptrs_to.add(fee_estimator);
        }
        if (this != null) {
            this.ptrs_to.add(logger);
        }
    }

    public TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ[] block_connected(byte[] header, TwoTuple_usizeTransactionZ[] txdata, int height, BroadcasterInterface broadcaster, FeeEstimator fee_estimator, Logger logger) {
        long[] ret = bindings.ChannelMonitor_block_connected(this.ptr, InternalUtils.check_arr_len(header, 80), txdata != null ? Arrays.stream(txdata).mapToLong(txdata_conv_28 -> txdata_conv_28.ptr).toArray() : null, height, broadcaster.ptr, fee_estimator.ptr, logger.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(header);
        Reference.reachabilityFence(txdata);
        Reference.reachabilityFence(height);
        Reference.reachabilityFence(broadcaster);
        Reference.reachabilityFence(fee_estimator);
        Reference.reachabilityFence(logger);
        int ret_conv_49_len = ret.length;
        TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ[] ret_conv_49_arr = new TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ[ret_conv_49_len];
        for (int x = 0; x < ret_conv_49_len; ++x) {
            long ret_conv_49 = ret[x];
            TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ ret_conv_49_hu_conv = new TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ(null, ret_conv_49);
            if (ret_conv_49_hu_conv != null) {
                ret_conv_49_hu_conv.ptrs_to.add(this);
            }
            ret_conv_49_arr[x] = ret_conv_49_hu_conv;
        }
        if (this != null) {
            this.ptrs_to.add(broadcaster);
        }
        if (this != null) {
            this.ptrs_to.add(fee_estimator);
        }
        if (this != null) {
            this.ptrs_to.add(logger);
        }
        return ret_conv_49_arr;
    }

    public void block_disconnected(byte[] header, int height, BroadcasterInterface broadcaster, FeeEstimator fee_estimator, Logger logger) {
        bindings.ChannelMonitor_block_disconnected(this.ptr, InternalUtils.check_arr_len(header, 80), height, broadcaster.ptr, fee_estimator.ptr, logger.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(header);
        Reference.reachabilityFence(height);
        Reference.reachabilityFence(broadcaster);
        Reference.reachabilityFence(fee_estimator);
        Reference.reachabilityFence(logger);
        if (this != null) {
            this.ptrs_to.add(broadcaster);
        }
        if (this != null) {
            this.ptrs_to.add(fee_estimator);
        }
        if (this != null) {
            this.ptrs_to.add(logger);
        }
    }

    public TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ[] transactions_confirmed(byte[] header, TwoTuple_usizeTransactionZ[] txdata, int height, BroadcasterInterface broadcaster, FeeEstimator fee_estimator, Logger logger) {
        long[] ret = bindings.ChannelMonitor_transactions_confirmed(this.ptr, InternalUtils.check_arr_len(header, 80), txdata != null ? Arrays.stream(txdata).mapToLong(txdata_conv_28 -> txdata_conv_28.ptr).toArray() : null, height, broadcaster.ptr, fee_estimator.ptr, logger.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(header);
        Reference.reachabilityFence(txdata);
        Reference.reachabilityFence(height);
        Reference.reachabilityFence(broadcaster);
        Reference.reachabilityFence(fee_estimator);
        Reference.reachabilityFence(logger);
        int ret_conv_49_len = ret.length;
        TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ[] ret_conv_49_arr = new TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ[ret_conv_49_len];
        for (int x = 0; x < ret_conv_49_len; ++x) {
            long ret_conv_49 = ret[x];
            TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ ret_conv_49_hu_conv = new TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ(null, ret_conv_49);
            if (ret_conv_49_hu_conv != null) {
                ret_conv_49_hu_conv.ptrs_to.add(this);
            }
            ret_conv_49_arr[x] = ret_conv_49_hu_conv;
        }
        if (this != null) {
            this.ptrs_to.add(broadcaster);
        }
        if (this != null) {
            this.ptrs_to.add(fee_estimator);
        }
        if (this != null) {
            this.ptrs_to.add(logger);
        }
        return ret_conv_49_arr;
    }

    public void transaction_unconfirmed(byte[] txid, BroadcasterInterface broadcaster, FeeEstimator fee_estimator, Logger logger) {
        bindings.ChannelMonitor_transaction_unconfirmed(this.ptr, InternalUtils.check_arr_len(txid, 32), broadcaster.ptr, fee_estimator.ptr, logger.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(txid);
        Reference.reachabilityFence(broadcaster);
        Reference.reachabilityFence(fee_estimator);
        Reference.reachabilityFence(logger);
        if (this != null) {
            this.ptrs_to.add(broadcaster);
        }
        if (this != null) {
            this.ptrs_to.add(fee_estimator);
        }
        if (this != null) {
            this.ptrs_to.add(logger);
        }
    }

    public TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ[] best_block_updated(byte[] header, int height, BroadcasterInterface broadcaster, FeeEstimator fee_estimator, Logger logger) {
        long[] ret = bindings.ChannelMonitor_best_block_updated(this.ptr, InternalUtils.check_arr_len(header, 80), height, broadcaster.ptr, fee_estimator.ptr, logger.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(header);
        Reference.reachabilityFence(height);
        Reference.reachabilityFence(broadcaster);
        Reference.reachabilityFence(fee_estimator);
        Reference.reachabilityFence(logger);
        int ret_conv_49_len = ret.length;
        TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ[] ret_conv_49_arr = new TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ[ret_conv_49_len];
        for (int x = 0; x < ret_conv_49_len; ++x) {
            long ret_conv_49 = ret[x];
            TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ ret_conv_49_hu_conv = new TwoTuple_ThirtyTwoBytesCVec_C2Tuple_u32TxOutZZZ(null, ret_conv_49);
            if (ret_conv_49_hu_conv != null) {
                ret_conv_49_hu_conv.ptrs_to.add(this);
            }
            ret_conv_49_arr[x] = ret_conv_49_hu_conv;
        }
        if (this != null) {
            this.ptrs_to.add(broadcaster);
        }
        if (this != null) {
            this.ptrs_to.add(fee_estimator);
        }
        if (this != null) {
            this.ptrs_to.add(logger);
        }
        return ret_conv_49_arr;
    }

    public ThreeTuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ[] get_relevant_txids() {
        long[] ret = bindings.ChannelMonitor_get_relevant_txids(this.ptr);
        Reference.reachabilityFence(this);
        int ret_conv_54_len = ret.length;
        ThreeTuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ[] ret_conv_54_arr = new ThreeTuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ[ret_conv_54_len];
        for (int c = 0; c < ret_conv_54_len; ++c) {
            long ret_conv_54 = ret[c];
            ThreeTuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ ret_conv_54_hu_conv = new ThreeTuple_ThirtyTwoBytesu32COption_ThirtyTwoBytesZZ(null, ret_conv_54);
            if (ret_conv_54_hu_conv != null) {
                ret_conv_54_hu_conv.ptrs_to.add(this);
            }
            ret_conv_54_arr[c] = ret_conv_54_hu_conv;
        }
        return ret_conv_54_arr;
    }

    public BestBlock current_best_block() {
        long ret = bindings.ChannelMonitor_current_best_block(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        BestBlock ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new BestBlock(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void rebroadcast_pending_claims(BroadcasterInterface broadcaster, FeeEstimator fee_estimator, Logger logger) {
        bindings.ChannelMonitor_rebroadcast_pending_claims(this.ptr, broadcaster.ptr, fee_estimator.ptr, logger.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(broadcaster);
        Reference.reachabilityFence(fee_estimator);
        Reference.reachabilityFence(logger);
        if (this != null) {
            this.ptrs_to.add(broadcaster);
        }
        if (this != null) {
            this.ptrs_to.add(fee_estimator);
        }
        if (this != null) {
            this.ptrs_to.add(logger);
        }
    }

    public boolean has_pending_claims() {
        boolean ret = bindings.ChannelMonitor_has_pending_claims(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void signer_unblocked(BroadcasterInterface broadcaster, FeeEstimator fee_estimator, Logger logger) {
        bindings.ChannelMonitor_signer_unblocked(this.ptr, broadcaster.ptr, fee_estimator.ptr, logger.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(broadcaster);
        Reference.reachabilityFence(fee_estimator);
        Reference.reachabilityFence(logger);
        if (this != null) {
            this.ptrs_to.add(broadcaster);
        }
        if (this != null) {
            this.ptrs_to.add(fee_estimator);
        }
        if (this != null) {
            this.ptrs_to.add(logger);
        }
    }

    public SpendableOutputDescriptor[] get_spendable_outputs(byte[] tx, int confirmation_height) {
        long[] ret = bindings.ChannelMonitor_get_spendable_outputs(this.ptr, tx, confirmation_height);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(tx);
        Reference.reachabilityFence(confirmation_height);
        int ret_conv_27_len = ret.length;
        SpendableOutputDescriptor[] ret_conv_27_arr = new SpendableOutputDescriptor[ret_conv_27_len];
        for (int b = 0; b < ret_conv_27_len; ++b) {
            long ret_conv_27 = ret[b];
            SpendableOutputDescriptor ret_conv_27_hu_conv = SpendableOutputDescriptor.constr_from_ptr(ret_conv_27);
            if (ret_conv_27_hu_conv != null) {
                ret_conv_27_hu_conv.ptrs_to.add(this);
            }
            ret_conv_27_arr[b] = ret_conv_27_hu_conv;
        }
        return ret_conv_27_arr;
    }

    public TwoTuple_boolboolZ check_and_update_full_resolution_status(Logger logger) {
        long ret = bindings.ChannelMonitor_check_and_update_full_resolution_status(this.ptr, logger.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(logger);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        TwoTuple_boolboolZ ret_hu_conv = new TwoTuple_boolboolZ(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        if (this != null) {
            this.ptrs_to.add(logger);
        }
        return ret_hu_conv;
    }

    public Balance[] get_claimable_balances() {
        long[] ret = bindings.ChannelMonitor_get_claimable_balances(this.ptr);
        Reference.reachabilityFence(this);
        int ret_conv_9_len = ret.length;
        Balance[] ret_conv_9_arr = new Balance[ret_conv_9_len];
        for (int j = 0; j < ret_conv_9_len; ++j) {
            long ret_conv_9 = ret[j];
            Balance ret_conv_9_hu_conv = Balance.constr_from_ptr(ret_conv_9);
            if (ret_conv_9_hu_conv != null) {
                ret_conv_9_hu_conv.ptrs_to.add(this);
            }
            ret_conv_9_arr[j] = ret_conv_9_hu_conv;
        }
        return ret_conv_9_arr;
    }
}

