/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.DelayedPaymentBasepoint;
import org.ldk.structs.HtlcBasepoint;
import org.ldk.structs.Result_ChannelPublicKeysDecodeErrorZ;
import org.ldk.structs.RevocationBasepoint;
import org.ldk.util.InternalUtils;

public class ChannelPublicKeys
extends CommonBase {
    ChannelPublicKeys(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.ChannelPublicKeys_free(this.ptr);
        }
    }

    public byte[] get_funding_pubkey() {
        byte[] ret = bindings.ChannelPublicKeys_get_funding_pubkey(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_funding_pubkey(byte[] val) {
        bindings.ChannelPublicKeys_set_funding_pubkey(this.ptr, InternalUtils.check_arr_len(val, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public RevocationBasepoint get_revocation_basepoint() {
        long ret = bindings.ChannelPublicKeys_get_revocation_basepoint(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        RevocationBasepoint ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new RevocationBasepoint(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_revocation_basepoint(RevocationBasepoint val) {
        bindings.ChannelPublicKeys_set_revocation_basepoint(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_payment_point() {
        byte[] ret = bindings.ChannelPublicKeys_get_payment_point(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_payment_point(byte[] val) {
        bindings.ChannelPublicKeys_set_payment_point(this.ptr, InternalUtils.check_arr_len(val, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public DelayedPaymentBasepoint get_delayed_payment_basepoint() {
        long ret = bindings.ChannelPublicKeys_get_delayed_payment_basepoint(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        DelayedPaymentBasepoint ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new DelayedPaymentBasepoint(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_delayed_payment_basepoint(DelayedPaymentBasepoint val) {
        bindings.ChannelPublicKeys_set_delayed_payment_basepoint(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public HtlcBasepoint get_htlc_basepoint() {
        long ret = bindings.ChannelPublicKeys_get_htlc_basepoint(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        HtlcBasepoint ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new HtlcBasepoint(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_htlc_basepoint(HtlcBasepoint val) {
        bindings.ChannelPublicKeys_set_htlc_basepoint(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public static ChannelPublicKeys of(byte[] funding_pubkey_arg, RevocationBasepoint revocation_basepoint_arg, byte[] payment_point_arg, DelayedPaymentBasepoint delayed_payment_basepoint_arg, HtlcBasepoint htlc_basepoint_arg) {
        long ret = bindings.ChannelPublicKeys_new(InternalUtils.check_arr_len(funding_pubkey_arg, 33), revocation_basepoint_arg.ptr, InternalUtils.check_arr_len(payment_point_arg, 33), delayed_payment_basepoint_arg.ptr, htlc_basepoint_arg.ptr);
        Reference.reachabilityFence(funding_pubkey_arg);
        Reference.reachabilityFence(revocation_basepoint_arg);
        Reference.reachabilityFence(payment_point_arg);
        Reference.reachabilityFence(delayed_payment_basepoint_arg);
        Reference.reachabilityFence(htlc_basepoint_arg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelPublicKeys ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelPublicKeys(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    long clone_ptr() {
        long ret = bindings.ChannelPublicKeys_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public ChannelPublicKeys clone() {
        long ret = bindings.ChannelPublicKeys_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelPublicKeys ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelPublicKeys(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public long hash() {
        long ret = bindings.ChannelPublicKeys_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public int hashCode() {
        return (int)this.hash();
    }

    public boolean eq(ChannelPublicKeys b) {
        boolean ret = bindings.ChannelPublicKeys_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        if (this != null) {
            this.ptrs_to.add(b);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChannelPublicKeys)) {
            return false;
        }
        return this.eq((ChannelPublicKeys)o);
    }

    public byte[] write() {
        byte[] ret = bindings.ChannelPublicKeys_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_ChannelPublicKeysDecodeErrorZ read(byte[] ser) {
        long ret = bindings.ChannelPublicKeys_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_ChannelPublicKeysDecodeErrorZ ret_hu_conv = Result_ChannelPublicKeysDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }
}

