/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import java.util.Arrays;
import org.ldk.impl.bindings;
import org.ldk.structs.ChannelPublicKeys;
import org.ldk.structs.ChannelTransactionParameters;
import org.ldk.structs.CommonBase;
import org.ldk.structs.HolderCommitmentTransaction;
import org.ldk.structs.Result_NoneNoneZ;
import org.ldk.structs.Result_PublicKeyNoneZ;
import org.ldk.structs.Result__u832NoneZ;
import org.ldk.util.InternalUtils;

public class ChannelSigner
extends CommonBase {
    final bindings.LDKChannelSigner bindings_instance;

    ChannelSigner(Object _dummy, long ptr) {
        super(ptr);
        this.bindings_instance = null;
    }

    private ChannelSigner(bindings.LDKChannelSigner arg, ChannelPublicKeys pubkeys) {
        super(bindings.LDKChannelSigner_new(arg, pubkeys.clone_ptr()));
        this.ptrs_to.add(arg);
        this.bindings_instance = arg;
    }

    protected void finalize() throws Throwable {
        if (this.ptr != 0L) {
            bindings.ChannelSigner_free(this.ptr);
        }
        super.finalize();
    }

    public void destroy() {
        if (this.ptr != 0L) {
            bindings.ChannelSigner_free(this.ptr);
        }
        this.ptr = 0L;
    }

    public static ChannelSigner new_impl(final ChannelSignerInterface arg, ChannelPublicKeys pubkeys) {
        LDKChannelSignerHolder impl_holder = new LDKChannelSignerHolder();
        impl_holder.held = new ChannelSigner(new bindings.LDKChannelSigner(){

            @Override
            public long get_per_commitment_point(long idx) {
                Result_PublicKeyNoneZ ret = arg.get_per_commitment_point(idx);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long release_commitment_secret(long idx) {
                Result__u832NoneZ ret = arg.release_commitment_secret(idx);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long validate_holder_commitment(long holder_tx, byte[][] outbound_htlc_preimages) {
                HolderCommitmentTransaction holder_tx_hu_conv = null;
                if (holder_tx < 0L || holder_tx > 4096L) {
                    holder_tx_hu_conv = new HolderCommitmentTransaction(null, holder_tx);
                }
                Result_NoneNoneZ ret = arg.validate_holder_commitment(holder_tx_hu_conv, outbound_htlc_preimages);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long validate_counterparty_revocation(long idx, byte[] secret) {
                Result_NoneNoneZ ret = arg.validate_counterparty_revocation(idx, secret);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public byte[] channel_keys_id() {
                byte[] ret = arg.channel_keys_id();
                Reference.reachabilityFence(arg);
                byte[] result = InternalUtils.check_arr_len(ret, 32);
                return result;
            }

            @Override
            public void provide_channel_parameters(long channel_parameters) {
                ChannelTransactionParameters channel_parameters_hu_conv = null;
                if (channel_parameters < 0L || channel_parameters > 4096L) {
                    channel_parameters_hu_conv = new ChannelTransactionParameters(null, channel_parameters);
                }
                arg.provide_channel_parameters(channel_parameters_hu_conv);
                Reference.reachabilityFence(arg);
            }
        }, pubkeys);
        return impl_holder.held;
    }

    public Result_PublicKeyNoneZ get_per_commitment_point(long idx) {
        long ret = bindings.ChannelSigner_get_per_commitment_point(this.ptr, idx);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(idx);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_PublicKeyNoneZ ret_hu_conv = Result_PublicKeyNoneZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result__u832NoneZ release_commitment_secret(long idx) {
        long ret = bindings.ChannelSigner_release_commitment_secret(this.ptr, idx);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(idx);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result__u832NoneZ ret_hu_conv = Result__u832NoneZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_NoneNoneZ validate_holder_commitment(HolderCommitmentTransaction holder_tx, byte[][] outbound_htlc_preimages) {
        long ret = bindings.ChannelSigner_validate_holder_commitment(this.ptr, holder_tx.ptr, outbound_htlc_preimages != null ? (byte[][])Arrays.stream(outbound_htlc_preimages).map(outbound_htlc_preimages_conv_8 -> InternalUtils.check_arr_len(outbound_htlc_preimages_conv_8, 32)).toArray(x$0 -> new byte[x$0][]) : null);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(holder_tx);
        Reference.reachabilityFence(outbound_htlc_preimages);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneNoneZ ret_hu_conv = Result_NoneNoneZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(holder_tx);
        }
        return ret_hu_conv;
    }

    public Result_NoneNoneZ validate_counterparty_revocation(long idx, byte[] secret) {
        long ret = bindings.ChannelSigner_validate_counterparty_revocation(this.ptr, idx, InternalUtils.check_arr_len(secret, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(idx);
        Reference.reachabilityFence(secret);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneNoneZ ret_hu_conv = Result_NoneNoneZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public byte[] channel_keys_id() {
        byte[] ret = bindings.ChannelSigner_channel_keys_id(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void provide_channel_parameters(ChannelTransactionParameters channel_parameters) {
        bindings.ChannelSigner_provide_channel_parameters(this.ptr, channel_parameters.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(channel_parameters);
        if (this != null) {
            this.ptrs_to.add(channel_parameters);
        }
    }

    public ChannelPublicKeys get_pubkeys() {
        long ret = bindings.ChannelSigner_get_pubkeys(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelPublicKeys ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelPublicKeys(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    private static class LDKChannelSignerHolder {
        ChannelSigner held;

        private LDKChannelSignerHolder() {
        }
    }

    public static interface ChannelSignerInterface {
        public Result_PublicKeyNoneZ get_per_commitment_point(long var1);

        public Result__u832NoneZ release_commitment_secret(long var1);

        public Result_NoneNoneZ validate_holder_commitment(HolderCommitmentTransaction var1, byte[][] var2);

        public Result_NoneNoneZ validate_counterparty_revocation(long var1, byte[] var3);

        public byte[] channel_keys_id();

        public void provide_channel_parameters(ChannelTransactionParameters var1);
    }
}

