/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import javax.annotation.Nullable;
import org.ldk.impl.bindings;
import org.ldk.structs.ChannelId;
import org.ldk.structs.ChannelParameters;
import org.ldk.structs.ChannelTypeFeatures;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Option_CVec_u8ZZ;
import org.ldk.util.InternalUtils;

public class CommonOpenChannelFields
extends CommonBase {
    CommonOpenChannelFields(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.CommonOpenChannelFields_free(this.ptr);
        }
    }

    public byte[] get_chain_hash() {
        byte[] ret = bindings.CommonOpenChannelFields_get_chain_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_chain_hash(byte[] val) {
        bindings.CommonOpenChannelFields_set_chain_hash(this.ptr, InternalUtils.check_arr_len(val, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public ChannelId get_temporary_channel_id() {
        long ret = bindings.CommonOpenChannelFields_get_temporary_channel_id(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelId ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelId(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_temporary_channel_id(ChannelId val) {
        bindings.CommonOpenChannelFields_set_temporary_channel_id(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public long get_funding_satoshis() {
        long ret = bindings.CommonOpenChannelFields_get_funding_satoshis(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_funding_satoshis(long val) {
        bindings.CommonOpenChannelFields_set_funding_satoshis(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public long get_dust_limit_satoshis() {
        long ret = bindings.CommonOpenChannelFields_get_dust_limit_satoshis(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_dust_limit_satoshis(long val) {
        bindings.CommonOpenChannelFields_set_dust_limit_satoshis(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public long get_max_htlc_value_in_flight_msat() {
        long ret = bindings.CommonOpenChannelFields_get_max_htlc_value_in_flight_msat(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_max_htlc_value_in_flight_msat(long val) {
        bindings.CommonOpenChannelFields_set_max_htlc_value_in_flight_msat(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public long get_htlc_minimum_msat() {
        long ret = bindings.CommonOpenChannelFields_get_htlc_minimum_msat(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_htlc_minimum_msat(long val) {
        bindings.CommonOpenChannelFields_set_htlc_minimum_msat(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public int get_commitment_feerate_sat_per_1000_weight() {
        int ret = bindings.CommonOpenChannelFields_get_commitment_feerate_sat_per_1000_weight(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_commitment_feerate_sat_per_1000_weight(int val) {
        bindings.CommonOpenChannelFields_set_commitment_feerate_sat_per_1000_weight(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public short get_to_self_delay() {
        short ret = bindings.CommonOpenChannelFields_get_to_self_delay(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_to_self_delay(short val) {
        bindings.CommonOpenChannelFields_set_to_self_delay(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public short get_max_accepted_htlcs() {
        short ret = bindings.CommonOpenChannelFields_get_max_accepted_htlcs(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_max_accepted_htlcs(short val) {
        bindings.CommonOpenChannelFields_set_max_accepted_htlcs(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_funding_pubkey() {
        byte[] ret = bindings.CommonOpenChannelFields_get_funding_pubkey(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_funding_pubkey(byte[] val) {
        bindings.CommonOpenChannelFields_set_funding_pubkey(this.ptr, InternalUtils.check_arr_len(val, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_revocation_basepoint() {
        byte[] ret = bindings.CommonOpenChannelFields_get_revocation_basepoint(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_revocation_basepoint(byte[] val) {
        bindings.CommonOpenChannelFields_set_revocation_basepoint(this.ptr, InternalUtils.check_arr_len(val, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_payment_basepoint() {
        byte[] ret = bindings.CommonOpenChannelFields_get_payment_basepoint(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_payment_basepoint(byte[] val) {
        bindings.CommonOpenChannelFields_set_payment_basepoint(this.ptr, InternalUtils.check_arr_len(val, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_delayed_payment_basepoint() {
        byte[] ret = bindings.CommonOpenChannelFields_get_delayed_payment_basepoint(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_delayed_payment_basepoint(byte[] val) {
        bindings.CommonOpenChannelFields_set_delayed_payment_basepoint(this.ptr, InternalUtils.check_arr_len(val, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_htlc_basepoint() {
        byte[] ret = bindings.CommonOpenChannelFields_get_htlc_basepoint(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_htlc_basepoint(byte[] val) {
        bindings.CommonOpenChannelFields_set_htlc_basepoint(this.ptr, InternalUtils.check_arr_len(val, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_first_per_commitment_point() {
        byte[] ret = bindings.CommonOpenChannelFields_get_first_per_commitment_point(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_first_per_commitment_point(byte[] val) {
        bindings.CommonOpenChannelFields_set_first_per_commitment_point(this.ptr, InternalUtils.check_arr_len(val, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte get_channel_flags() {
        byte ret = bindings.CommonOpenChannelFields_get_channel_flags(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_channel_flags(byte val) {
        bindings.CommonOpenChannelFields_set_channel_flags(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_CVec_u8ZZ get_shutdown_scriptpubkey() {
        long ret = bindings.CommonOpenChannelFields_get_shutdown_scriptpubkey(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_CVec_u8ZZ ret_hu_conv = Option_CVec_u8ZZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_shutdown_scriptpubkey(Option_CVec_u8ZZ val) {
        bindings.CommonOpenChannelFields_set_shutdown_scriptpubkey(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    @Nullable
    public ChannelTypeFeatures get_channel_type() {
        long ret = bindings.CommonOpenChannelFields_get_channel_type(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelTypeFeatures ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelTypeFeatures(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_channel_type(@Nullable ChannelTypeFeatures val) {
        bindings.CommonOpenChannelFields_set_channel_type(this.ptr, val == null ? 0L : val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public static CommonOpenChannelFields of(byte[] chain_hash_arg, ChannelId temporary_channel_id_arg, long funding_satoshis_arg, long dust_limit_satoshis_arg, long max_htlc_value_in_flight_msat_arg, long htlc_minimum_msat_arg, int commitment_feerate_sat_per_1000_weight_arg, short to_self_delay_arg, short max_accepted_htlcs_arg, byte[] funding_pubkey_arg, byte[] revocation_basepoint_arg, byte[] payment_basepoint_arg, byte[] delayed_payment_basepoint_arg, byte[] htlc_basepoint_arg, byte[] first_per_commitment_point_arg, byte channel_flags_arg, Option_CVec_u8ZZ shutdown_scriptpubkey_arg, @Nullable ChannelTypeFeatures channel_type_arg) {
        long ret = bindings.CommonOpenChannelFields_new(InternalUtils.check_arr_len(chain_hash_arg, 32), temporary_channel_id_arg.ptr, funding_satoshis_arg, dust_limit_satoshis_arg, max_htlc_value_in_flight_msat_arg, htlc_minimum_msat_arg, commitment_feerate_sat_per_1000_weight_arg, to_self_delay_arg, max_accepted_htlcs_arg, InternalUtils.check_arr_len(funding_pubkey_arg, 33), InternalUtils.check_arr_len(revocation_basepoint_arg, 33), InternalUtils.check_arr_len(payment_basepoint_arg, 33), InternalUtils.check_arr_len(delayed_payment_basepoint_arg, 33), InternalUtils.check_arr_len(htlc_basepoint_arg, 33), InternalUtils.check_arr_len(first_per_commitment_point_arg, 33), channel_flags_arg, shutdown_scriptpubkey_arg.ptr, channel_type_arg == null ? 0L : channel_type_arg.ptr);
        Reference.reachabilityFence(chain_hash_arg);
        Reference.reachabilityFence(temporary_channel_id_arg);
        Reference.reachabilityFence(funding_satoshis_arg);
        Reference.reachabilityFence(dust_limit_satoshis_arg);
        Reference.reachabilityFence(max_htlc_value_in_flight_msat_arg);
        Reference.reachabilityFence(htlc_minimum_msat_arg);
        Reference.reachabilityFence(commitment_feerate_sat_per_1000_weight_arg);
        Reference.reachabilityFence(to_self_delay_arg);
        Reference.reachabilityFence(max_accepted_htlcs_arg);
        Reference.reachabilityFence(funding_pubkey_arg);
        Reference.reachabilityFence(revocation_basepoint_arg);
        Reference.reachabilityFence(payment_basepoint_arg);
        Reference.reachabilityFence(delayed_payment_basepoint_arg);
        Reference.reachabilityFence(htlc_basepoint_arg);
        Reference.reachabilityFence(first_per_commitment_point_arg);
        Reference.reachabilityFence(channel_flags_arg);
        Reference.reachabilityFence(shutdown_scriptpubkey_arg);
        Reference.reachabilityFence(channel_type_arg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        CommonOpenChannelFields ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new CommonOpenChannelFields(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    long clone_ptr() {
        long ret = bindings.CommonOpenChannelFields_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public CommonOpenChannelFields clone() {
        long ret = bindings.CommonOpenChannelFields_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        CommonOpenChannelFields ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new CommonOpenChannelFields(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public long hash() {
        long ret = bindings.CommonOpenChannelFields_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public int hashCode() {
        return (int)this.hash();
    }

    public boolean eq(CommonOpenChannelFields b) {
        boolean ret = bindings.CommonOpenChannelFields_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        if (this != null) {
            this.ptrs_to.add(b);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CommonOpenChannelFields)) {
            return false;
        }
        return this.eq((CommonOpenChannelFields)o);
    }

    public ChannelParameters channel_parameters() {
        long ret = bindings.CommonOpenChannelFields_channel_parameters(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelParameters ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelParameters(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }
}

