/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.DNSResolverContext;
import org.ldk.structs.DNSSECProof;
import org.ldk.structs.DNSSECQuery;
import org.ldk.structs.NodeFeatures;
import org.ldk.structs.Option_C2Tuple_DNSResolverMessageResponseInstructionZZ;
import org.ldk.structs.Responder;
import org.ldk.structs.TwoTuple_DNSResolverMessageMessageSendInstructionsZ;

public class DNSResolverMessageHandler
extends CommonBase {
    final bindings.LDKDNSResolverMessageHandler bindings_instance;

    DNSResolverMessageHandler(Object _dummy, long ptr) {
        super(ptr);
        this.bindings_instance = null;
    }

    private DNSResolverMessageHandler(bindings.LDKDNSResolverMessageHandler arg) {
        super(bindings.LDKDNSResolverMessageHandler_new(arg));
        this.ptrs_to.add(arg);
        this.bindings_instance = arg;
    }

    protected void finalize() throws Throwable {
        if (this.ptr != 0L) {
            bindings.DNSResolverMessageHandler_free(this.ptr);
        }
        super.finalize();
    }

    public void destroy() {
        if (this.ptr != 0L) {
            bindings.DNSResolverMessageHandler_free(this.ptr);
        }
        this.ptr = 0L;
    }

    public static DNSResolverMessageHandler new_impl(final DNSResolverMessageHandlerInterface arg) {
        LDKDNSResolverMessageHandlerHolder impl_holder = new LDKDNSResolverMessageHandlerHolder();
        impl_holder.held = new DNSResolverMessageHandler(new bindings.LDKDNSResolverMessageHandler(){

            @Override
            public long handle_dnssec_query(long message, long responder) {
                DNSSECQuery message_hu_conv = null;
                if (message < 0L || message > 4096L) {
                    message_hu_conv = new DNSSECQuery(null, message);
                }
                if (message_hu_conv != null) {
                    message_hu_conv.ptrs_to.add(this);
                }
                Responder responder_hu_conv = null;
                if (responder < 0L || responder > 4096L) {
                    responder_hu_conv = new Responder(null, responder);
                }
                if (responder_hu_conv != null) {
                    responder_hu_conv.ptrs_to.add(this);
                }
                Option_C2Tuple_DNSResolverMessageResponseInstructionZZ ret = arg.handle_dnssec_query(message_hu_conv, responder_hu_conv);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public void handle_dnssec_proof(long message, long context) {
                DNSSECProof message_hu_conv = null;
                if (message < 0L || message > 4096L) {
                    message_hu_conv = new DNSSECProof(null, message);
                }
                if (message_hu_conv != null) {
                    message_hu_conv.ptrs_to.add(this);
                }
                DNSResolverContext context_hu_conv = null;
                if (context < 0L || context > 4096L) {
                    context_hu_conv = new DNSResolverContext(null, context);
                }
                if (context_hu_conv != null) {
                    context_hu_conv.ptrs_to.add(this);
                }
                arg.handle_dnssec_proof(message_hu_conv, context_hu_conv);
                Reference.reachabilityFence(arg);
            }

            @Override
            public long provided_node_features() {
                NodeFeatures ret = arg.provided_node_features();
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long[] release_pending_messages() {
                TwoTuple_DNSResolverMessageMessageSendInstructionsZ[] ret = arg.release_pending_messages();
                Reference.reachabilityFence(arg);
                long[] result = ret != null ? Arrays.stream(ret).mapToLong(ret_conv_53 -> ret_conv_53.clone_ptr()).toArray() : null;
                return result;
            }
        });
        return impl_holder.held;
    }

    public Option_C2Tuple_DNSResolverMessageResponseInstructionZZ handle_dnssec_query(DNSSECQuery message, @Nullable Responder responder) {
        long ret = bindings.DNSResolverMessageHandler_handle_dnssec_query(this.ptr, message.ptr, responder == null ? 0L : responder.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(message);
        Reference.reachabilityFence(responder);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_C2Tuple_DNSResolverMessageResponseInstructionZZ ret_hu_conv = Option_C2Tuple_DNSResolverMessageResponseInstructionZZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void handle_dnssec_proof(DNSSECProof message, DNSResolverContext context) {
        bindings.DNSResolverMessageHandler_handle_dnssec_proof(this.ptr, message.ptr, context.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(message);
        Reference.reachabilityFence(context);
    }

    public NodeFeatures provided_node_features() {
        long ret = bindings.DNSResolverMessageHandler_provided_node_features(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        NodeFeatures ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new NodeFeatures(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public TwoTuple_DNSResolverMessageMessageSendInstructionsZ[] release_pending_messages() {
        long[] ret = bindings.DNSResolverMessageHandler_release_pending_messages(this.ptr);
        Reference.reachabilityFence(this);
        int ret_conv_53_len = ret.length;
        TwoTuple_DNSResolverMessageMessageSendInstructionsZ[] ret_conv_53_arr = new TwoTuple_DNSResolverMessageMessageSendInstructionsZ[ret_conv_53_len];
        for (int b = 0; b < ret_conv_53_len; ++b) {
            long ret_conv_53 = ret[b];
            TwoTuple_DNSResolverMessageMessageSendInstructionsZ ret_conv_53_hu_conv = new TwoTuple_DNSResolverMessageMessageSendInstructionsZ(null, ret_conv_53);
            if (ret_conv_53_hu_conv != null) {
                ret_conv_53_hu_conv.ptrs_to.add(this);
            }
            ret_conv_53_arr[b] = ret_conv_53_hu_conv;
        }
        return ret_conv_53_arr;
    }

    private static class LDKDNSResolverMessageHandlerHolder {
        DNSResolverMessageHandler held;

        private LDKDNSResolverMessageHandlerHolder() {
        }
    }

    public static interface DNSResolverMessageHandlerInterface {
        public Option_C2Tuple_DNSResolverMessageResponseInstructionZZ handle_dnssec_query(DNSSECQuery var1, Responder var2);

        public void handle_dnssec_proof(DNSSECProof var1, DNSResolverContext var2);

        public NodeFeatures provided_node_features();

        public TwoTuple_DNSResolverMessageMessageSendInstructionsZ[] release_pending_messages();
    }
}

