/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import java.util.Arrays;
import org.ldk.impl.bindings;
import org.ldk.structs.ChannelPublicKeys;
import org.ldk.structs.ChannelSigner;
import org.ldk.structs.ClosingTransaction;
import org.ldk.structs.CommitmentTransaction;
import org.ldk.structs.CommonBase;
import org.ldk.structs.HTLCDescriptor;
import org.ldk.structs.HTLCOutputInCommitment;
import org.ldk.structs.HolderCommitmentTransaction;
import org.ldk.structs.Result_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ;
import org.ldk.structs.Result_ECDSASignatureNoneZ;
import org.ldk.structs.UnsignedChannelAnnouncement;
import org.ldk.util.InternalUtils;

public class EcdsaChannelSigner
extends CommonBase {
    final bindings.LDKEcdsaChannelSigner bindings_instance;

    EcdsaChannelSigner(Object _dummy, long ptr) {
        super(ptr);
        this.bindings_instance = null;
    }

    private EcdsaChannelSigner(bindings.LDKEcdsaChannelSigner arg, bindings.LDKChannelSigner ChannelSigner2, ChannelPublicKeys pubkeys) {
        super(bindings.LDKEcdsaChannelSigner_new(arg, ChannelSigner2, pubkeys.clone_ptr()));
        this.ptrs_to.add(arg);
        this.ptrs_to.add(ChannelSigner2);
        this.bindings_instance = arg;
    }

    protected void finalize() throws Throwable {
        if (this.ptr != 0L) {
            bindings.EcdsaChannelSigner_free(this.ptr);
        }
        super.finalize();
    }

    public void destroy() {
        if (this.ptr != 0L) {
            bindings.EcdsaChannelSigner_free(this.ptr);
        }
        this.ptr = 0L;
    }

    public static EcdsaChannelSigner new_impl(final EcdsaChannelSignerInterface arg, ChannelSigner.ChannelSignerInterface ChannelSigner_impl, ChannelPublicKeys pubkeys) {
        LDKEcdsaChannelSignerHolder impl_holder = new LDKEcdsaChannelSignerHolder();
        impl_holder.held = new EcdsaChannelSigner(new bindings.LDKEcdsaChannelSigner(){

            @Override
            public long sign_counterparty_commitment(long commitment_tx, byte[][] inbound_htlc_preimages, byte[][] outbound_htlc_preimages) {
                CommitmentTransaction commitment_tx_hu_conv = null;
                if (commitment_tx < 0L || commitment_tx > 4096L) {
                    commitment_tx_hu_conv = new CommitmentTransaction(null, commitment_tx);
                }
                Result_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ ret = arg.sign_counterparty_commitment(commitment_tx_hu_conv, inbound_htlc_preimages, outbound_htlc_preimages);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long sign_holder_commitment(long commitment_tx) {
                HolderCommitmentTransaction commitment_tx_hu_conv = null;
                if (commitment_tx < 0L || commitment_tx > 4096L) {
                    commitment_tx_hu_conv = new HolderCommitmentTransaction(null, commitment_tx);
                }
                Result_ECDSASignatureNoneZ ret = arg.sign_holder_commitment(commitment_tx_hu_conv);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long sign_justice_revoked_output(byte[] justice_tx, long input, long amount, byte[] per_commitment_key) {
                Result_ECDSASignatureNoneZ ret = arg.sign_justice_revoked_output(justice_tx, input, amount, per_commitment_key);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long sign_justice_revoked_htlc(byte[] justice_tx, long input, long amount, byte[] per_commitment_key, long htlc) {
                HTLCOutputInCommitment htlc_hu_conv = null;
                if (htlc < 0L || htlc > 4096L) {
                    htlc_hu_conv = new HTLCOutputInCommitment(null, htlc);
                }
                Result_ECDSASignatureNoneZ ret = arg.sign_justice_revoked_htlc(justice_tx, input, amount, per_commitment_key, htlc_hu_conv);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long sign_holder_htlc_transaction(byte[] htlc_tx, long input, long htlc_descriptor) {
                HTLCDescriptor htlc_descriptor_hu_conv = null;
                if (htlc_descriptor < 0L || htlc_descriptor > 4096L) {
                    htlc_descriptor_hu_conv = new HTLCDescriptor(null, htlc_descriptor);
                }
                Result_ECDSASignatureNoneZ ret = arg.sign_holder_htlc_transaction(htlc_tx, input, htlc_descriptor_hu_conv);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long sign_counterparty_htlc_transaction(byte[] htlc_tx, long input, long amount, byte[] per_commitment_point, long htlc) {
                HTLCOutputInCommitment htlc_hu_conv = null;
                if (htlc < 0L || htlc > 4096L) {
                    htlc_hu_conv = new HTLCOutputInCommitment(null, htlc);
                }
                Result_ECDSASignatureNoneZ ret = arg.sign_counterparty_htlc_transaction(htlc_tx, input, amount, per_commitment_point, htlc_hu_conv);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long sign_closing_transaction(long closing_tx) {
                ClosingTransaction closing_tx_hu_conv = null;
                if (closing_tx < 0L || closing_tx > 4096L) {
                    closing_tx_hu_conv = new ClosingTransaction(null, closing_tx);
                }
                Result_ECDSASignatureNoneZ ret = arg.sign_closing_transaction(closing_tx_hu_conv);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long sign_holder_anchor_input(byte[] anchor_tx, long input) {
                Result_ECDSASignatureNoneZ ret = arg.sign_holder_anchor_input(anchor_tx, input);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long sign_channel_announcement_with_funding_key(long msg) {
                UnsignedChannelAnnouncement msg_hu_conv = null;
                if (msg < 0L || msg > 4096L) {
                    msg_hu_conv = new UnsignedChannelAnnouncement(null, msg);
                }
                Result_ECDSASignatureNoneZ ret = arg.sign_channel_announcement_with_funding_key(msg_hu_conv);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long sign_splicing_funding_input(byte[] tx, long input_index, long input_value) {
                Result_ECDSASignatureNoneZ ret = arg.sign_splicing_funding_input(tx, input_index, input_value);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }
        }, ChannelSigner.new_impl((ChannelSigner.ChannelSignerInterface)ChannelSigner_impl, (ChannelPublicKeys)pubkeys).bindings_instance, pubkeys);
        return impl_holder.held;
    }

    public ChannelSigner get_channel_signer() {
        ChannelSigner res = new ChannelSigner(null, bindings.LDKEcdsaChannelSigner_get_ChannelSigner(this.ptr));
        res.ptrs_to.add(this);
        return res;
    }

    public Result_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ sign_counterparty_commitment(CommitmentTransaction commitment_tx, byte[][] inbound_htlc_preimages, byte[][] outbound_htlc_preimages) {
        long ret = bindings.EcdsaChannelSigner_sign_counterparty_commitment(this.ptr, commitment_tx.ptr, inbound_htlc_preimages != null ? (byte[][])Arrays.stream(inbound_htlc_preimages).map(inbound_htlc_preimages_conv_8 -> InternalUtils.check_arr_len(inbound_htlc_preimages_conv_8, 32)).toArray(x$0 -> new byte[x$0][]) : null, outbound_htlc_preimages != null ? (byte[][])Arrays.stream(outbound_htlc_preimages).map(outbound_htlc_preimages_conv_8 -> InternalUtils.check_arr_len(outbound_htlc_preimages_conv_8, 32)).toArray(x$0 -> new byte[x$0][]) : null);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(commitment_tx);
        Reference.reachabilityFence(inbound_htlc_preimages);
        Reference.reachabilityFence(outbound_htlc_preimages);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ ret_hu_conv = Result_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(commitment_tx);
        }
        return ret_hu_conv;
    }

    public Result_ECDSASignatureNoneZ sign_holder_commitment(HolderCommitmentTransaction commitment_tx) {
        long ret = bindings.EcdsaChannelSigner_sign_holder_commitment(this.ptr, commitment_tx.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(commitment_tx);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_ECDSASignatureNoneZ ret_hu_conv = Result_ECDSASignatureNoneZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(commitment_tx);
        }
        return ret_hu_conv;
    }

    public Result_ECDSASignatureNoneZ sign_justice_revoked_output(byte[] justice_tx, long input, long amount, byte[] per_commitment_key) {
        long ret = bindings.EcdsaChannelSigner_sign_justice_revoked_output(this.ptr, justice_tx, input, amount, InternalUtils.check_arr_len(per_commitment_key, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(justice_tx);
        Reference.reachabilityFence(input);
        Reference.reachabilityFence(amount);
        Reference.reachabilityFence(per_commitment_key);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_ECDSASignatureNoneZ ret_hu_conv = Result_ECDSASignatureNoneZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_ECDSASignatureNoneZ sign_justice_revoked_htlc(byte[] justice_tx, long input, long amount, byte[] per_commitment_key, HTLCOutputInCommitment htlc) {
        long ret = bindings.EcdsaChannelSigner_sign_justice_revoked_htlc(this.ptr, justice_tx, input, amount, InternalUtils.check_arr_len(per_commitment_key, 32), htlc.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(justice_tx);
        Reference.reachabilityFence(input);
        Reference.reachabilityFence(amount);
        Reference.reachabilityFence(per_commitment_key);
        Reference.reachabilityFence(htlc);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_ECDSASignatureNoneZ ret_hu_conv = Result_ECDSASignatureNoneZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(htlc);
        }
        return ret_hu_conv;
    }

    public Result_ECDSASignatureNoneZ sign_holder_htlc_transaction(byte[] htlc_tx, long input, HTLCDescriptor htlc_descriptor) {
        long ret = bindings.EcdsaChannelSigner_sign_holder_htlc_transaction(this.ptr, htlc_tx, input, htlc_descriptor.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(htlc_tx);
        Reference.reachabilityFence(input);
        Reference.reachabilityFence(htlc_descriptor);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_ECDSASignatureNoneZ ret_hu_conv = Result_ECDSASignatureNoneZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(htlc_descriptor);
        }
        return ret_hu_conv;
    }

    public Result_ECDSASignatureNoneZ sign_counterparty_htlc_transaction(byte[] htlc_tx, long input, long amount, byte[] per_commitment_point, HTLCOutputInCommitment htlc) {
        long ret = bindings.EcdsaChannelSigner_sign_counterparty_htlc_transaction(this.ptr, htlc_tx, input, amount, InternalUtils.check_arr_len(per_commitment_point, 33), htlc.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(htlc_tx);
        Reference.reachabilityFence(input);
        Reference.reachabilityFence(amount);
        Reference.reachabilityFence(per_commitment_point);
        Reference.reachabilityFence(htlc);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_ECDSASignatureNoneZ ret_hu_conv = Result_ECDSASignatureNoneZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(htlc);
        }
        return ret_hu_conv;
    }

    public Result_ECDSASignatureNoneZ sign_closing_transaction(ClosingTransaction closing_tx) {
        long ret = bindings.EcdsaChannelSigner_sign_closing_transaction(this.ptr, closing_tx.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(closing_tx);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_ECDSASignatureNoneZ ret_hu_conv = Result_ECDSASignatureNoneZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(closing_tx);
        }
        return ret_hu_conv;
    }

    public Result_ECDSASignatureNoneZ sign_holder_anchor_input(byte[] anchor_tx, long input) {
        long ret = bindings.EcdsaChannelSigner_sign_holder_anchor_input(this.ptr, anchor_tx, input);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(anchor_tx);
        Reference.reachabilityFence(input);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_ECDSASignatureNoneZ ret_hu_conv = Result_ECDSASignatureNoneZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_ECDSASignatureNoneZ sign_channel_announcement_with_funding_key(UnsignedChannelAnnouncement msg) {
        long ret = bindings.EcdsaChannelSigner_sign_channel_announcement_with_funding_key(this.ptr, msg.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_ECDSASignatureNoneZ ret_hu_conv = Result_ECDSASignatureNoneZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(msg);
        }
        return ret_hu_conv;
    }

    public Result_ECDSASignatureNoneZ sign_splicing_funding_input(byte[] tx, long input_index, long input_value) {
        long ret = bindings.EcdsaChannelSigner_sign_splicing_funding_input(this.ptr, tx, input_index, input_value);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(tx);
        Reference.reachabilityFence(input_index);
        Reference.reachabilityFence(input_value);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_ECDSASignatureNoneZ ret_hu_conv = Result_ECDSASignatureNoneZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    long clone_ptr() {
        long ret = bindings.EcdsaChannelSigner_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public EcdsaChannelSigner clone() {
        long ret = bindings.EcdsaChannelSigner_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        EcdsaChannelSigner ret_hu_conv = new EcdsaChannelSigner(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    private static class LDKEcdsaChannelSignerHolder {
        EcdsaChannelSigner held;

        private LDKEcdsaChannelSignerHolder() {
        }
    }

    public static interface EcdsaChannelSignerInterface {
        public Result_C2Tuple_ECDSASignatureCVec_ECDSASignatureZZNoneZ sign_counterparty_commitment(CommitmentTransaction var1, byte[][] var2, byte[][] var3);

        public Result_ECDSASignatureNoneZ sign_holder_commitment(HolderCommitmentTransaction var1);

        public Result_ECDSASignatureNoneZ sign_justice_revoked_output(byte[] var1, long var2, long var4, byte[] var6);

        public Result_ECDSASignatureNoneZ sign_justice_revoked_htlc(byte[] var1, long var2, long var4, byte[] var6, HTLCOutputInCommitment var7);

        public Result_ECDSASignatureNoneZ sign_holder_htlc_transaction(byte[] var1, long var2, HTLCDescriptor var4);

        public Result_ECDSASignatureNoneZ sign_counterparty_htlc_transaction(byte[] var1, long var2, long var4, byte[] var6, HTLCOutputInCommitment var7);

        public Result_ECDSASignatureNoneZ sign_closing_transaction(ClosingTransaction var1);

        public Result_ECDSASignatureNoneZ sign_holder_anchor_input(byte[] var1, long var2);

        public Result_ECDSASignatureNoneZ sign_channel_announcement_with_funding_key(UnsignedChannelAnnouncement var1);

        public Result_ECDSASignatureNoneZ sign_splicing_funding_input(byte[] var1, long var2, long var4);
    }
}

