/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;

public class EffectiveCapacity
extends CommonBase {
    private EffectiveCapacity(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.EffectiveCapacity_free(this.ptr);
        }
    }

    static EffectiveCapacity constr_from_ptr(long ptr) {
        bindings.LDKEffectiveCapacity raw_val = bindings.LDKEffectiveCapacity_ref_from_ptr(ptr);
        if (raw_val.getClass() == bindings.LDKEffectiveCapacity.ExactLiquidity.class) {
            return new ExactLiquidity(ptr, (bindings.LDKEffectiveCapacity.ExactLiquidity)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEffectiveCapacity.AdvertisedMaxHTLC.class) {
            return new AdvertisedMaxHTLC(ptr, (bindings.LDKEffectiveCapacity.AdvertisedMaxHTLC)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEffectiveCapacity.Total.class) {
            return new Total(ptr, (bindings.LDKEffectiveCapacity.Total)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEffectiveCapacity.Infinite.class) {
            return new Infinite(ptr, (bindings.LDKEffectiveCapacity.Infinite)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEffectiveCapacity.HintMaxHTLC.class) {
            return new HintMaxHTLC(ptr, (bindings.LDKEffectiveCapacity.HintMaxHTLC)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEffectiveCapacity.Unknown.class) {
            return new Unknown(ptr, (bindings.LDKEffectiveCapacity.Unknown)raw_val);
        }
        assert (false);
        return null;
    }

    long clone_ptr() {
        long ret = bindings.EffectiveCapacity_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public EffectiveCapacity clone() {
        long ret = bindings.EffectiveCapacity_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        EffectiveCapacity ret_hu_conv = EffectiveCapacity.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static EffectiveCapacity exact_liquidity(long liquidity_msat) {
        long ret = bindings.EffectiveCapacity_exact_liquidity(liquidity_msat);
        Reference.reachabilityFence(liquidity_msat);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        EffectiveCapacity ret_hu_conv = EffectiveCapacity.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static EffectiveCapacity advertised_max_htlc(long amount_msat) {
        long ret = bindings.EffectiveCapacity_advertised_max_htlc(amount_msat);
        Reference.reachabilityFence(amount_msat);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        EffectiveCapacity ret_hu_conv = EffectiveCapacity.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static EffectiveCapacity total(long capacity_msat, long htlc_maximum_msat) {
        long ret = bindings.EffectiveCapacity_total(capacity_msat, htlc_maximum_msat);
        Reference.reachabilityFence(capacity_msat);
        Reference.reachabilityFence(htlc_maximum_msat);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        EffectiveCapacity ret_hu_conv = EffectiveCapacity.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static EffectiveCapacity infinite() {
        long ret = bindings.EffectiveCapacity_infinite();
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        EffectiveCapacity ret_hu_conv = EffectiveCapacity.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static EffectiveCapacity hint_max_htlc(long amount_msat) {
        long ret = bindings.EffectiveCapacity_hint_max_htlc(amount_msat);
        Reference.reachabilityFence(amount_msat);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        EffectiveCapacity ret_hu_conv = EffectiveCapacity.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static EffectiveCapacity unknown() {
        long ret = bindings.EffectiveCapacity_unknown();
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        EffectiveCapacity ret_hu_conv = EffectiveCapacity.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public long as_msat() {
        long ret = bindings.EffectiveCapacity_as_msat(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static final class ExactLiquidity
    extends EffectiveCapacity {
        public final long liquidity_msat;

        private ExactLiquidity(long ptr, bindings.LDKEffectiveCapacity.ExactLiquidity obj) {
            super(null, ptr);
            this.liquidity_msat = obj.liquidity_msat;
        }
    }

    public static final class AdvertisedMaxHTLC
    extends EffectiveCapacity {
        public final long amount_msat;

        private AdvertisedMaxHTLC(long ptr, bindings.LDKEffectiveCapacity.AdvertisedMaxHTLC obj) {
            super(null, ptr);
            this.amount_msat = obj.amount_msat;
        }
    }

    public static final class Total
    extends EffectiveCapacity {
        public final long capacity_msat;
        public final long htlc_maximum_msat;

        private Total(long ptr, bindings.LDKEffectiveCapacity.Total obj) {
            super(null, ptr);
            this.capacity_msat = obj.capacity_msat;
            this.htlc_maximum_msat = obj.htlc_maximum_msat;
        }
    }

    public static final class Infinite
    extends EffectiveCapacity {
        private Infinite(long ptr, bindings.LDKEffectiveCapacity.Infinite obj) {
            super(null, ptr);
        }
    }

    public static final class HintMaxHTLC
    extends EffectiveCapacity {
        public final long amount_msat;

        private HintMaxHTLC(long ptr, bindings.LDKEffectiveCapacity.HintMaxHTLC obj) {
            super(null, ptr);
            this.amount_msat = obj.amount_msat;
        }
    }

    public static final class Unknown
    extends EffectiveCapacity {
        private Unknown(long ptr, bindings.LDKEffectiveCapacity.Unknown obj) {
            super(null, ptr);
        }
    }
}

