/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import javax.annotation.Nullable;
import org.ldk.enums.Level;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.ErrorMessage;
import org.ldk.structs.WarningMessage;

public class ErrorAction
extends CommonBase {
    private ErrorAction(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.ErrorAction_free(this.ptr);
        }
    }

    static ErrorAction constr_from_ptr(long ptr) {
        bindings.LDKErrorAction raw_val = bindings.LDKErrorAction_ref_from_ptr(ptr);
        if (raw_val.getClass() == bindings.LDKErrorAction.DisconnectPeer.class) {
            return new DisconnectPeer(ptr, (bindings.LDKErrorAction.DisconnectPeer)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKErrorAction.DisconnectPeerWithWarning.class) {
            return new DisconnectPeerWithWarning(ptr, (bindings.LDKErrorAction.DisconnectPeerWithWarning)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKErrorAction.IgnoreError.class) {
            return new IgnoreError(ptr, (bindings.LDKErrorAction.IgnoreError)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKErrorAction.IgnoreAndLog.class) {
            return new IgnoreAndLog(ptr, (bindings.LDKErrorAction.IgnoreAndLog)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKErrorAction.IgnoreDuplicateGossip.class) {
            return new IgnoreDuplicateGossip(ptr, (bindings.LDKErrorAction.IgnoreDuplicateGossip)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKErrorAction.SendErrorMessage.class) {
            return new SendErrorMessage(ptr, (bindings.LDKErrorAction.SendErrorMessage)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKErrorAction.SendWarningMessage.class) {
            return new SendWarningMessage(ptr, (bindings.LDKErrorAction.SendWarningMessage)raw_val);
        }
        assert (false);
        return null;
    }

    long clone_ptr() {
        long ret = bindings.ErrorAction_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public ErrorAction clone() {
        long ret = bindings.ErrorAction_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ErrorAction ret_hu_conv = ErrorAction.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static ErrorAction disconnect_peer(ErrorMessage msg) {
        long ret = bindings.ErrorAction_disconnect_peer(msg.ptr);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ErrorAction ret_hu_conv = ErrorAction.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static ErrorAction disconnect_peer_with_warning(WarningMessage msg) {
        long ret = bindings.ErrorAction_disconnect_peer_with_warning(msg.ptr);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ErrorAction ret_hu_conv = ErrorAction.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static ErrorAction ignore_error() {
        long ret = bindings.ErrorAction_ignore_error();
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ErrorAction ret_hu_conv = ErrorAction.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static ErrorAction ignore_and_log(Level a) {
        long ret = bindings.ErrorAction_ignore_and_log(a);
        Reference.reachabilityFence((Object)a);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ErrorAction ret_hu_conv = ErrorAction.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static ErrorAction ignore_duplicate_gossip() {
        long ret = bindings.ErrorAction_ignore_duplicate_gossip();
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ErrorAction ret_hu_conv = ErrorAction.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static ErrorAction send_error_message(ErrorMessage msg) {
        long ret = bindings.ErrorAction_send_error_message(msg.ptr);
        Reference.reachabilityFence(msg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ErrorAction ret_hu_conv = ErrorAction.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static ErrorAction send_warning_message(WarningMessage msg, Level log_level) {
        long ret = bindings.ErrorAction_send_warning_message(msg.ptr, log_level);
        Reference.reachabilityFence(msg);
        Reference.reachabilityFence((Object)log_level);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ErrorAction ret_hu_conv = ErrorAction.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public long hash() {
        long ret = bindings.ErrorAction_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public int hashCode() {
        return (int)this.hash();
    }

    public static final class DisconnectPeer
    extends ErrorAction {
        @Nullable
        public final ErrorMessage msg;

        private DisconnectPeer(long ptr, bindings.LDKErrorAction.DisconnectPeer obj) {
            super(null, ptr);
            long msg = obj.msg;
            ErrorMessage msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new ErrorMessage(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class DisconnectPeerWithWarning
    extends ErrorAction {
        public final WarningMessage msg;

        private DisconnectPeerWithWarning(long ptr, bindings.LDKErrorAction.DisconnectPeerWithWarning obj) {
            super(null, ptr);
            long msg = obj.msg;
            WarningMessage msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new WarningMessage(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class IgnoreError
    extends ErrorAction {
        private IgnoreError(long ptr, bindings.LDKErrorAction.IgnoreError obj) {
            super(null, ptr);
        }
    }

    public static final class IgnoreAndLog
    extends ErrorAction {
        public final Level ignore_and_log;

        private IgnoreAndLog(long ptr, bindings.LDKErrorAction.IgnoreAndLog obj) {
            super(null, ptr);
            this.ignore_and_log = obj.ignore_and_log;
        }
    }

    public static final class IgnoreDuplicateGossip
    extends ErrorAction {
        private IgnoreDuplicateGossip(long ptr, bindings.LDKErrorAction.IgnoreDuplicateGossip obj) {
            super(null, ptr);
        }
    }

    public static final class SendErrorMessage
    extends ErrorAction {
        public final ErrorMessage msg;

        private SendErrorMessage(long ptr, bindings.LDKErrorAction.SendErrorMessage obj) {
            super(null, ptr);
            long msg = obj.msg;
            ErrorMessage msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new ErrorMessage(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
        }
    }

    public static final class SendWarningMessage
    extends ErrorAction {
        public final WarningMessage msg;
        public final Level log_level;

        private SendWarningMessage(long ptr, bindings.LDKErrorAction.SendWarningMessage obj) {
            super(null, ptr);
            long msg = obj.msg;
            WarningMessage msg_hu_conv = null;
            if (msg < 0L || msg > 4096L) {
                msg_hu_conv = new WarningMessage(null, msg);
            }
            if (msg_hu_conv != null) {
                msg_hu_conv.ptrs_to.add(this);
            }
            this.msg = msg_hu_conv;
            this.log_level = obj.log_level;
        }
    }
}

