/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.ldk.impl.bindings;
import org.ldk.structs.Bolt12Invoice;
import org.ldk.structs.BumpTransactionEvent;
import org.ldk.structs.ChannelId;
import org.ldk.structs.ChannelParameters;
import org.ldk.structs.ChannelTypeFeatures;
import org.ldk.structs.ClaimedHTLC;
import org.ldk.structs.ClosureReason;
import org.ldk.structs.CommonBase;
import org.ldk.structs.FundingInfo;
import org.ldk.structs.HTLCDestination;
import org.ldk.structs.InboundChannelFunds;
import org.ldk.structs.OnionMessage;
import org.ldk.structs.Option_OffersContextZ;
import org.ldk.structs.Option_PaymentFailureReasonZ;
import org.ldk.structs.Option_ThirtyTwoBytesZ;
import org.ldk.structs.Option_U128Z;
import org.ldk.structs.Option_u32Z;
import org.ldk.structs.Option_u64Z;
import org.ldk.structs.OutPoint;
import org.ldk.structs.Path;
import org.ldk.structs.PathFailure;
import org.ldk.structs.PaymentPurpose;
import org.ldk.structs.RecipientOnionFields;
import org.ldk.structs.Responder;
import org.ldk.structs.SocketAddress;
import org.ldk.structs.SpendableOutputDescriptor;
import org.ldk.util.InternalUtils;
import org.ldk.util.UInt128;

public class Event
extends CommonBase {
    private Event(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.Event_free(this.ptr);
        }
    }

    static Event constr_from_ptr(long ptr) {
        bindings.LDKEvent raw_val = bindings.LDKEvent_ref_from_ptr(ptr);
        if (raw_val.getClass() == bindings.LDKEvent.FundingGenerationReady.class) {
            return new FundingGenerationReady(ptr, (bindings.LDKEvent.FundingGenerationReady)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.FundingTxBroadcastSafe.class) {
            return new FundingTxBroadcastSafe(ptr, (bindings.LDKEvent.FundingTxBroadcastSafe)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.PaymentClaimable.class) {
            return new PaymentClaimable(ptr, (bindings.LDKEvent.PaymentClaimable)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.PaymentClaimed.class) {
            return new PaymentClaimed(ptr, (bindings.LDKEvent.PaymentClaimed)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.ConnectionNeeded.class) {
            return new ConnectionNeeded(ptr, (bindings.LDKEvent.ConnectionNeeded)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.InvoiceReceived.class) {
            return new InvoiceReceived(ptr, (bindings.LDKEvent.InvoiceReceived)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.PaymentSent.class) {
            return new PaymentSent(ptr, (bindings.LDKEvent.PaymentSent)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.PaymentFailed.class) {
            return new PaymentFailed(ptr, (bindings.LDKEvent.PaymentFailed)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.PaymentPathSuccessful.class) {
            return new PaymentPathSuccessful(ptr, (bindings.LDKEvent.PaymentPathSuccessful)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.PaymentPathFailed.class) {
            return new PaymentPathFailed(ptr, (bindings.LDKEvent.PaymentPathFailed)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.ProbeSuccessful.class) {
            return new ProbeSuccessful(ptr, (bindings.LDKEvent.ProbeSuccessful)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.ProbeFailed.class) {
            return new ProbeFailed(ptr, (bindings.LDKEvent.ProbeFailed)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.PendingHTLCsForwardable.class) {
            return new PendingHTLCsForwardable(ptr, (bindings.LDKEvent.PendingHTLCsForwardable)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.HTLCIntercepted.class) {
            return new HTLCIntercepted(ptr, (bindings.LDKEvent.HTLCIntercepted)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.SpendableOutputs.class) {
            return new SpendableOutputs(ptr, (bindings.LDKEvent.SpendableOutputs)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.PaymentForwarded.class) {
            return new PaymentForwarded(ptr, (bindings.LDKEvent.PaymentForwarded)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.ChannelPending.class) {
            return new ChannelPending(ptr, (bindings.LDKEvent.ChannelPending)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.ChannelReady.class) {
            return new ChannelReady(ptr, (bindings.LDKEvent.ChannelReady)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.ChannelClosed.class) {
            return new ChannelClosed(ptr, (bindings.LDKEvent.ChannelClosed)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.DiscardFunding.class) {
            return new DiscardFunding(ptr, (bindings.LDKEvent.DiscardFunding)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.OpenChannelRequest.class) {
            return new OpenChannelRequest(ptr, (bindings.LDKEvent.OpenChannelRequest)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.HTLCHandlingFailed.class) {
            return new HTLCHandlingFailed(ptr, (bindings.LDKEvent.HTLCHandlingFailed)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.BumpTransaction.class) {
            return new BumpTransaction(ptr, (bindings.LDKEvent.BumpTransaction)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.OnionMessageIntercepted.class) {
            return new OnionMessageIntercepted(ptr, (bindings.LDKEvent.OnionMessageIntercepted)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKEvent.OnionMessagePeerConnected.class) {
            return new OnionMessagePeerConnected(ptr, (bindings.LDKEvent.OnionMessagePeerConnected)raw_val);
        }
        assert (false);
        return null;
    }

    long clone_ptr() {
        long ret = bindings.Event_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public Event clone() {
        long ret = bindings.Event_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static Event funding_generation_ready(ChannelId temporary_channel_id, byte[] counterparty_node_id, long channel_value_satoshis, byte[] output_script, UInt128 user_channel_id) {
        long ret = bindings.Event_funding_generation_ready(temporary_channel_id.ptr, InternalUtils.check_arr_len(counterparty_node_id, 33), channel_value_satoshis, output_script, user_channel_id.getLEBytes());
        Reference.reachabilityFence(temporary_channel_id);
        Reference.reachabilityFence(counterparty_node_id);
        Reference.reachabilityFence(channel_value_satoshis);
        Reference.reachabilityFence(output_script);
        Reference.reachabilityFence(user_channel_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event funding_tx_broadcast_safe(ChannelId channel_id, UInt128 user_channel_id, OutPoint funding_txo, byte[] counterparty_node_id, ChannelId former_temporary_channel_id) {
        long ret = bindings.Event_funding_tx_broadcast_safe(channel_id.ptr, user_channel_id.getLEBytes(), funding_txo.ptr, InternalUtils.check_arr_len(counterparty_node_id, 33), former_temporary_channel_id.ptr);
        Reference.reachabilityFence(channel_id);
        Reference.reachabilityFence(user_channel_id);
        Reference.reachabilityFence(funding_txo);
        Reference.reachabilityFence(counterparty_node_id);
        Reference.reachabilityFence(former_temporary_channel_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event payment_claimable(byte[] receiver_node_id, byte[] payment_hash, RecipientOnionFields onion_fields, long amount_msat, long counterparty_skimmed_fee_msat, PaymentPurpose purpose, ChannelId via_channel_id, Option_U128Z via_user_channel_id, Option_u32Z claim_deadline, Option_ThirtyTwoBytesZ payment_id) {
        long ret = bindings.Event_payment_claimable(InternalUtils.check_arr_len(receiver_node_id, 33), InternalUtils.check_arr_len(payment_hash, 32), onion_fields.ptr, amount_msat, counterparty_skimmed_fee_msat, purpose.ptr, via_channel_id.ptr, via_user_channel_id.ptr, claim_deadline.ptr, payment_id.ptr);
        Reference.reachabilityFence(receiver_node_id);
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(onion_fields);
        Reference.reachabilityFence(amount_msat);
        Reference.reachabilityFence(counterparty_skimmed_fee_msat);
        Reference.reachabilityFence(purpose);
        Reference.reachabilityFence(via_channel_id);
        Reference.reachabilityFence(via_user_channel_id);
        Reference.reachabilityFence(claim_deadline);
        Reference.reachabilityFence(payment_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event payment_claimed(byte[] receiver_node_id, byte[] payment_hash, long amount_msat, PaymentPurpose purpose, ClaimedHTLC[] htlcs, Option_u64Z sender_intended_total_msat, RecipientOnionFields onion_fields, Option_ThirtyTwoBytesZ payment_id) {
        long ret = bindings.Event_payment_claimed(InternalUtils.check_arr_len(receiver_node_id, 33), InternalUtils.check_arr_len(payment_hash, 32), amount_msat, purpose.ptr, htlcs != null ? Arrays.stream(htlcs).mapToLong(htlcs_conv_13 -> htlcs_conv_13.ptr).toArray() : null, sender_intended_total_msat.ptr, onion_fields.ptr, payment_id.ptr);
        Reference.reachabilityFence(receiver_node_id);
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(amount_msat);
        Reference.reachabilityFence(purpose);
        Reference.reachabilityFence(htlcs);
        Reference.reachabilityFence(sender_intended_total_msat);
        Reference.reachabilityFence(onion_fields);
        Reference.reachabilityFence(payment_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event connection_needed(byte[] node_id, SocketAddress[] addresses) {
        long ret = bindings.Event_connection_needed(InternalUtils.check_arr_len(node_id, 33), addresses != null ? Arrays.stream(addresses).mapToLong(addresses_conv_15 -> addresses_conv_15.ptr).toArray() : null);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(addresses);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event invoice_received(byte[] payment_id, Bolt12Invoice invoice, Option_OffersContextZ context, Responder responder) {
        long ret = bindings.Event_invoice_received(InternalUtils.check_arr_len(payment_id, 32), invoice.ptr, context.ptr, responder.ptr);
        Reference.reachabilityFence(payment_id);
        Reference.reachabilityFence(invoice);
        Reference.reachabilityFence(context);
        Reference.reachabilityFence(responder);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event payment_sent(Option_ThirtyTwoBytesZ payment_id, byte[] payment_preimage, byte[] payment_hash, Option_u64Z fee_paid_msat) {
        long ret = bindings.Event_payment_sent(payment_id.ptr, InternalUtils.check_arr_len(payment_preimage, 32), InternalUtils.check_arr_len(payment_hash, 32), fee_paid_msat.ptr);
        Reference.reachabilityFence(payment_id);
        Reference.reachabilityFence(payment_preimage);
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(fee_paid_msat);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event payment_failed(byte[] payment_id, Option_ThirtyTwoBytesZ payment_hash, Option_PaymentFailureReasonZ reason) {
        long ret = bindings.Event_payment_failed(InternalUtils.check_arr_len(payment_id, 32), payment_hash.ptr, reason.ptr);
        Reference.reachabilityFence(payment_id);
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(reason);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event payment_path_successful(byte[] payment_id, Option_ThirtyTwoBytesZ payment_hash, Path path) {
        long ret = bindings.Event_payment_path_successful(InternalUtils.check_arr_len(payment_id, 32), payment_hash.ptr, path.ptr);
        Reference.reachabilityFence(payment_id);
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(path);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event payment_path_failed(Option_ThirtyTwoBytesZ payment_id, byte[] payment_hash, boolean payment_failed_permanently, PathFailure failure, Path path, Option_u64Z short_channel_id) {
        long ret = bindings.Event_payment_path_failed(payment_id.ptr, InternalUtils.check_arr_len(payment_hash, 32), payment_failed_permanently, failure.ptr, path.ptr, short_channel_id.ptr);
        Reference.reachabilityFence(payment_id);
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(payment_failed_permanently);
        Reference.reachabilityFence(failure);
        Reference.reachabilityFence(path);
        Reference.reachabilityFence(short_channel_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event probe_successful(byte[] payment_id, byte[] payment_hash, Path path) {
        long ret = bindings.Event_probe_successful(InternalUtils.check_arr_len(payment_id, 32), InternalUtils.check_arr_len(payment_hash, 32), path.ptr);
        Reference.reachabilityFence(payment_id);
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(path);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event probe_failed(byte[] payment_id, byte[] payment_hash, Path path, Option_u64Z short_channel_id) {
        long ret = bindings.Event_probe_failed(InternalUtils.check_arr_len(payment_id, 32), InternalUtils.check_arr_len(payment_hash, 32), path.ptr, short_channel_id.ptr);
        Reference.reachabilityFence(payment_id);
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(path);
        Reference.reachabilityFence(short_channel_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event pending_htlcs_forwardable(long time_forwardable) {
        long ret = bindings.Event_pending_htlcs_forwardable(time_forwardable);
        Reference.reachabilityFence(time_forwardable);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event htlcintercepted(byte[] intercept_id, long requested_next_hop_scid, byte[] payment_hash, long inbound_amount_msat, long expected_outbound_amount_msat) {
        long ret = bindings.Event_htlcintercepted(InternalUtils.check_arr_len(intercept_id, 32), requested_next_hop_scid, InternalUtils.check_arr_len(payment_hash, 32), inbound_amount_msat, expected_outbound_amount_msat);
        Reference.reachabilityFence(intercept_id);
        Reference.reachabilityFence(requested_next_hop_scid);
        Reference.reachabilityFence(payment_hash);
        Reference.reachabilityFence(inbound_amount_msat);
        Reference.reachabilityFence(expected_outbound_amount_msat);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event spendable_outputs(SpendableOutputDescriptor[] outputs, ChannelId channel_id) {
        long ret = bindings.Event_spendable_outputs(outputs != null ? Arrays.stream(outputs).mapToLong(outputs_conv_27 -> outputs_conv_27.ptr).toArray() : null, channel_id.ptr);
        Reference.reachabilityFence(outputs);
        Reference.reachabilityFence(channel_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event payment_forwarded(ChannelId prev_channel_id, ChannelId next_channel_id, Option_U128Z prev_user_channel_id, Option_U128Z next_user_channel_id, byte[] prev_node_id, byte[] next_node_id, Option_u64Z total_fee_earned_msat, Option_u64Z skimmed_fee_msat, boolean claim_from_onchain_tx, Option_u64Z outbound_amount_forwarded_msat) {
        long ret = bindings.Event_payment_forwarded(prev_channel_id.ptr, next_channel_id.ptr, prev_user_channel_id.ptr, next_user_channel_id.ptr, InternalUtils.check_arr_len(prev_node_id, 33), InternalUtils.check_arr_len(next_node_id, 33), total_fee_earned_msat.ptr, skimmed_fee_msat.ptr, claim_from_onchain_tx, outbound_amount_forwarded_msat.ptr);
        Reference.reachabilityFence(prev_channel_id);
        Reference.reachabilityFence(next_channel_id);
        Reference.reachabilityFence(prev_user_channel_id);
        Reference.reachabilityFence(next_user_channel_id);
        Reference.reachabilityFence(prev_node_id);
        Reference.reachabilityFence(next_node_id);
        Reference.reachabilityFence(total_fee_earned_msat);
        Reference.reachabilityFence(skimmed_fee_msat);
        Reference.reachabilityFence(claim_from_onchain_tx);
        Reference.reachabilityFence(outbound_amount_forwarded_msat);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event channel_pending(ChannelId channel_id, UInt128 user_channel_id, ChannelId former_temporary_channel_id, byte[] counterparty_node_id, OutPoint funding_txo, ChannelTypeFeatures channel_type) {
        long ret = bindings.Event_channel_pending(channel_id.ptr, user_channel_id.getLEBytes(), former_temporary_channel_id.ptr, InternalUtils.check_arr_len(counterparty_node_id, 33), funding_txo.ptr, channel_type.ptr);
        Reference.reachabilityFence(channel_id);
        Reference.reachabilityFence(user_channel_id);
        Reference.reachabilityFence(former_temporary_channel_id);
        Reference.reachabilityFence(counterparty_node_id);
        Reference.reachabilityFence(funding_txo);
        Reference.reachabilityFence(channel_type);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event channel_ready(ChannelId channel_id, UInt128 user_channel_id, byte[] counterparty_node_id, ChannelTypeFeatures channel_type) {
        long ret = bindings.Event_channel_ready(channel_id.ptr, user_channel_id.getLEBytes(), InternalUtils.check_arr_len(counterparty_node_id, 33), channel_type.ptr);
        Reference.reachabilityFence(channel_id);
        Reference.reachabilityFence(user_channel_id);
        Reference.reachabilityFence(counterparty_node_id);
        Reference.reachabilityFence(channel_type);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event channel_closed(ChannelId channel_id, UInt128 user_channel_id, ClosureReason reason, byte[] counterparty_node_id, Option_u64Z channel_capacity_sats, OutPoint channel_funding_txo, Option_u64Z last_local_balance_msat) {
        long ret = bindings.Event_channel_closed(channel_id.ptr, user_channel_id.getLEBytes(), reason.ptr, InternalUtils.check_arr_len(counterparty_node_id, 33), channel_capacity_sats.ptr, channel_funding_txo.ptr, last_local_balance_msat.ptr);
        Reference.reachabilityFence(channel_id);
        Reference.reachabilityFence(user_channel_id);
        Reference.reachabilityFence(reason);
        Reference.reachabilityFence(counterparty_node_id);
        Reference.reachabilityFence(channel_capacity_sats);
        Reference.reachabilityFence(channel_funding_txo);
        Reference.reachabilityFence(last_local_balance_msat);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event discard_funding(ChannelId channel_id, FundingInfo funding_info) {
        long ret = bindings.Event_discard_funding(channel_id.ptr, funding_info.ptr);
        Reference.reachabilityFence(channel_id);
        Reference.reachabilityFence(funding_info);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event open_channel_request(ChannelId temporary_channel_id, byte[] counterparty_node_id, long funding_satoshis, InboundChannelFunds channel_negotiation_type, ChannelTypeFeatures channel_type, boolean is_announced, ChannelParameters params) {
        long ret = bindings.Event_open_channel_request(temporary_channel_id.ptr, InternalUtils.check_arr_len(counterparty_node_id, 33), funding_satoshis, channel_negotiation_type.ptr, channel_type.ptr, is_announced, params.ptr);
        Reference.reachabilityFence(temporary_channel_id);
        Reference.reachabilityFence(counterparty_node_id);
        Reference.reachabilityFence(funding_satoshis);
        Reference.reachabilityFence(channel_negotiation_type);
        Reference.reachabilityFence(channel_type);
        Reference.reachabilityFence(is_announced);
        Reference.reachabilityFence(params);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event htlchandling_failed(ChannelId prev_channel_id, HTLCDestination failed_next_destination) {
        long ret = bindings.Event_htlchandling_failed(prev_channel_id.ptr, failed_next_destination.ptr);
        Reference.reachabilityFence(prev_channel_id);
        Reference.reachabilityFence(failed_next_destination);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event bump_transaction(BumpTransactionEvent a) {
        long ret = bindings.Event_bump_transaction(a.ptr);
        Reference.reachabilityFence(a);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event onion_message_intercepted(byte[] peer_node_id, OnionMessage message) {
        long ret = bindings.Event_onion_message_intercepted(InternalUtils.check_arr_len(peer_node_id, 33), message.ptr);
        Reference.reachabilityFence(peer_node_id);
        Reference.reachabilityFence(message);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Event onion_message_peer_connected(byte[] peer_node_id) {
        long ret = bindings.Event_onion_message_peer_connected(InternalUtils.check_arr_len(peer_node_id, 33));
        Reference.reachabilityFence(peer_node_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Event ret_hu_conv = Event.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public boolean eq(Event b) {
        boolean ret = bindings.Event_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Event)) {
            return false;
        }
        return this.eq((Event)o);
    }

    public byte[] write() {
        byte[] ret = bindings.Event_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static final class FundingGenerationReady
    extends Event {
        public final ChannelId temporary_channel_id;
        public final byte[] counterparty_node_id;
        public final long channel_value_satoshis;
        public final byte[] output_script;
        public final UInt128 user_channel_id;

        private FundingGenerationReady(long ptr, bindings.LDKEvent.FundingGenerationReady obj) {
            super(null, ptr);
            UInt128 user_channel_id_conv;
            long temporary_channel_id = obj.temporary_channel_id;
            ChannelId temporary_channel_id_hu_conv = null;
            if (temporary_channel_id < 0L || temporary_channel_id > 4096L) {
                temporary_channel_id_hu_conv = new ChannelId(null, temporary_channel_id);
            }
            if (temporary_channel_id_hu_conv != null) {
                temporary_channel_id_hu_conv.ptrs_to.add(this);
            }
            this.temporary_channel_id = temporary_channel_id_hu_conv;
            this.counterparty_node_id = obj.counterparty_node_id;
            this.channel_value_satoshis = obj.channel_value_satoshis;
            this.output_script = obj.output_script;
            byte[] user_channel_id = obj.user_channel_id;
            this.user_channel_id = user_channel_id_conv = new UInt128(user_channel_id);
        }
    }

    public static final class FundingTxBroadcastSafe
    extends Event {
        public final ChannelId channel_id;
        public final UInt128 user_channel_id;
        public final OutPoint funding_txo;
        public final byte[] counterparty_node_id;
        public final ChannelId former_temporary_channel_id;

        private FundingTxBroadcastSafe(long ptr, bindings.LDKEvent.FundingTxBroadcastSafe obj) {
            super(null, ptr);
            UInt128 user_channel_id_conv;
            long channel_id = obj.channel_id;
            ChannelId channel_id_hu_conv = null;
            if (channel_id < 0L || channel_id > 4096L) {
                channel_id_hu_conv = new ChannelId(null, channel_id);
            }
            if (channel_id_hu_conv != null) {
                channel_id_hu_conv.ptrs_to.add(this);
            }
            this.channel_id = channel_id_hu_conv;
            byte[] user_channel_id = obj.user_channel_id;
            this.user_channel_id = user_channel_id_conv = new UInt128(user_channel_id);
            long funding_txo = obj.funding_txo;
            OutPoint funding_txo_hu_conv = null;
            if (funding_txo < 0L || funding_txo > 4096L) {
                funding_txo_hu_conv = new OutPoint(null, funding_txo);
            }
            if (funding_txo_hu_conv != null) {
                funding_txo_hu_conv.ptrs_to.add(this);
            }
            this.funding_txo = funding_txo_hu_conv;
            this.counterparty_node_id = obj.counterparty_node_id;
            long former_temporary_channel_id = obj.former_temporary_channel_id;
            ChannelId former_temporary_channel_id_hu_conv = null;
            if (former_temporary_channel_id < 0L || former_temporary_channel_id > 4096L) {
                former_temporary_channel_id_hu_conv = new ChannelId(null, former_temporary_channel_id);
            }
            if (former_temporary_channel_id_hu_conv != null) {
                former_temporary_channel_id_hu_conv.ptrs_to.add(this);
            }
            this.former_temporary_channel_id = former_temporary_channel_id_hu_conv;
        }
    }

    public static final class PaymentClaimable
    extends Event {
        @Nullable
        public final byte[] receiver_node_id;
        public final byte[] payment_hash;
        @Nullable
        public final RecipientOnionFields onion_fields;
        public final long amount_msat;
        public final long counterparty_skimmed_fee_msat;
        public final PaymentPurpose purpose;
        @Nullable
        public final ChannelId via_channel_id;
        public final Option_U128Z via_user_channel_id;
        public final Option_u32Z claim_deadline;
        public final Option_ThirtyTwoBytesZ payment_id;

        private PaymentClaimable(long ptr, bindings.LDKEvent.PaymentClaimable obj) {
            super(null, ptr);
            this.receiver_node_id = obj.receiver_node_id;
            this.payment_hash = obj.payment_hash;
            long onion_fields = obj.onion_fields;
            RecipientOnionFields onion_fields_hu_conv = null;
            if (onion_fields < 0L || onion_fields > 4096L) {
                onion_fields_hu_conv = new RecipientOnionFields(null, onion_fields);
            }
            if (onion_fields_hu_conv != null) {
                onion_fields_hu_conv.ptrs_to.add(this);
            }
            this.onion_fields = onion_fields_hu_conv;
            this.amount_msat = obj.amount_msat;
            this.counterparty_skimmed_fee_msat = obj.counterparty_skimmed_fee_msat;
            long purpose = obj.purpose;
            PaymentPurpose purpose_hu_conv = PaymentPurpose.constr_from_ptr(purpose);
            if (purpose_hu_conv != null) {
                purpose_hu_conv.ptrs_to.add(this);
            }
            this.purpose = purpose_hu_conv;
            long via_channel_id = obj.via_channel_id;
            ChannelId via_channel_id_hu_conv = null;
            if (via_channel_id < 0L || via_channel_id > 4096L) {
                via_channel_id_hu_conv = new ChannelId(null, via_channel_id);
            }
            if (via_channel_id_hu_conv != null) {
                via_channel_id_hu_conv.ptrs_to.add(this);
            }
            this.via_channel_id = via_channel_id_hu_conv;
            long via_user_channel_id = obj.via_user_channel_id;
            Option_U128Z via_user_channel_id_hu_conv = Option_U128Z.constr_from_ptr(via_user_channel_id);
            if (via_user_channel_id_hu_conv != null) {
                via_user_channel_id_hu_conv.ptrs_to.add(this);
            }
            this.via_user_channel_id = via_user_channel_id_hu_conv;
            long claim_deadline = obj.claim_deadline;
            Option_u32Z claim_deadline_hu_conv = Option_u32Z.constr_from_ptr(claim_deadline);
            if (claim_deadline_hu_conv != null) {
                claim_deadline_hu_conv.ptrs_to.add(this);
            }
            this.claim_deadline = claim_deadline_hu_conv;
            long payment_id = obj.payment_id;
            Option_ThirtyTwoBytesZ payment_id_hu_conv = Option_ThirtyTwoBytesZ.constr_from_ptr(payment_id);
            if (payment_id_hu_conv != null) {
                payment_id_hu_conv.ptrs_to.add(this);
            }
            this.payment_id = payment_id_hu_conv;
        }
    }

    public static final class PaymentClaimed
    extends Event {
        @Nullable
        public final byte[] receiver_node_id;
        public final byte[] payment_hash;
        public final long amount_msat;
        public final PaymentPurpose purpose;
        public final ClaimedHTLC[] htlcs;
        public final Option_u64Z sender_intended_total_msat;
        @Nullable
        public final RecipientOnionFields onion_fields;
        public final Option_ThirtyTwoBytesZ payment_id;

        private PaymentClaimed(long ptr, bindings.LDKEvent.PaymentClaimed obj) {
            super(null, ptr);
            this.receiver_node_id = obj.receiver_node_id;
            this.payment_hash = obj.payment_hash;
            this.amount_msat = obj.amount_msat;
            long purpose = obj.purpose;
            PaymentPurpose purpose_hu_conv = PaymentPurpose.constr_from_ptr(purpose);
            if (purpose_hu_conv != null) {
                purpose_hu_conv.ptrs_to.add(this);
            }
            this.purpose = purpose_hu_conv;
            long[] htlcs = obj.htlcs;
            int htlcs_conv_13_len = htlcs.length;
            ClaimedHTLC[] htlcs_conv_13_arr = new ClaimedHTLC[htlcs_conv_13_len];
            for (int n = 0; n < htlcs_conv_13_len; ++n) {
                long htlcs_conv_13 = htlcs[n];
                ClaimedHTLC htlcs_conv_13_hu_conv = null;
                if (htlcs_conv_13 < 0L || htlcs_conv_13 > 4096L) {
                    htlcs_conv_13_hu_conv = new ClaimedHTLC(null, htlcs_conv_13);
                }
                if (htlcs_conv_13_hu_conv != null) {
                    htlcs_conv_13_hu_conv.ptrs_to.add(this);
                }
                htlcs_conv_13_arr[n] = htlcs_conv_13_hu_conv;
            }
            this.htlcs = htlcs_conv_13_arr;
            long sender_intended_total_msat = obj.sender_intended_total_msat;
            Option_u64Z sender_intended_total_msat_hu_conv = Option_u64Z.constr_from_ptr(sender_intended_total_msat);
            if (sender_intended_total_msat_hu_conv != null) {
                sender_intended_total_msat_hu_conv.ptrs_to.add(this);
            }
            this.sender_intended_total_msat = sender_intended_total_msat_hu_conv;
            long onion_fields = obj.onion_fields;
            RecipientOnionFields onion_fields_hu_conv = null;
            if (onion_fields < 0L || onion_fields > 4096L) {
                onion_fields_hu_conv = new RecipientOnionFields(null, onion_fields);
            }
            if (onion_fields_hu_conv != null) {
                onion_fields_hu_conv.ptrs_to.add(this);
            }
            this.onion_fields = onion_fields_hu_conv;
            long payment_id = obj.payment_id;
            Option_ThirtyTwoBytesZ payment_id_hu_conv = Option_ThirtyTwoBytesZ.constr_from_ptr(payment_id);
            if (payment_id_hu_conv != null) {
                payment_id_hu_conv.ptrs_to.add(this);
            }
            this.payment_id = payment_id_hu_conv;
        }
    }

    public static final class ConnectionNeeded
    extends Event {
        public final byte[] node_id;
        public final SocketAddress[] addresses;

        private ConnectionNeeded(long ptr, bindings.LDKEvent.ConnectionNeeded obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long[] addresses = obj.addresses;
            int addresses_conv_15_len = addresses.length;
            SocketAddress[] addresses_conv_15_arr = new SocketAddress[addresses_conv_15_len];
            for (int p = 0; p < addresses_conv_15_len; ++p) {
                long addresses_conv_15 = addresses[p];
                SocketAddress addresses_conv_15_hu_conv = SocketAddress.constr_from_ptr(addresses_conv_15);
                if (addresses_conv_15_hu_conv != null) {
                    addresses_conv_15_hu_conv.ptrs_to.add(this);
                }
                addresses_conv_15_arr[p] = addresses_conv_15_hu_conv;
            }
            this.addresses = addresses_conv_15_arr;
        }
    }

    public static final class InvoiceReceived
    extends Event {
        public final byte[] payment_id;
        public final Bolt12Invoice invoice;
        public final Option_OffersContextZ context;
        @Nullable
        public final Responder responder;

        private InvoiceReceived(long ptr, bindings.LDKEvent.InvoiceReceived obj) {
            super(null, ptr);
            this.payment_id = obj.payment_id;
            long invoice = obj.invoice;
            Bolt12Invoice invoice_hu_conv = null;
            if (invoice < 0L || invoice > 4096L) {
                invoice_hu_conv = new Bolt12Invoice(null, invoice);
            }
            if (invoice_hu_conv != null) {
                invoice_hu_conv.ptrs_to.add(this);
            }
            this.invoice = invoice_hu_conv;
            long context = obj.context;
            Option_OffersContextZ context_hu_conv = Option_OffersContextZ.constr_from_ptr(context);
            if (context_hu_conv != null) {
                context_hu_conv.ptrs_to.add(this);
            }
            this.context = context_hu_conv;
            long responder = obj.responder;
            Responder responder_hu_conv = null;
            if (responder < 0L || responder > 4096L) {
                responder_hu_conv = new Responder(null, responder);
            }
            if (responder_hu_conv != null) {
                responder_hu_conv.ptrs_to.add(this);
            }
            this.responder = responder_hu_conv;
        }
    }

    public static final class PaymentSent
    extends Event {
        public final Option_ThirtyTwoBytesZ payment_id;
        public final byte[] payment_preimage;
        public final byte[] payment_hash;
        public final Option_u64Z fee_paid_msat;

        private PaymentSent(long ptr, bindings.LDKEvent.PaymentSent obj) {
            super(null, ptr);
            long payment_id = obj.payment_id;
            Option_ThirtyTwoBytesZ payment_id_hu_conv = Option_ThirtyTwoBytesZ.constr_from_ptr(payment_id);
            if (payment_id_hu_conv != null) {
                payment_id_hu_conv.ptrs_to.add(this);
            }
            this.payment_id = payment_id_hu_conv;
            this.payment_preimage = obj.payment_preimage;
            this.payment_hash = obj.payment_hash;
            long fee_paid_msat = obj.fee_paid_msat;
            Option_u64Z fee_paid_msat_hu_conv = Option_u64Z.constr_from_ptr(fee_paid_msat);
            if (fee_paid_msat_hu_conv != null) {
                fee_paid_msat_hu_conv.ptrs_to.add(this);
            }
            this.fee_paid_msat = fee_paid_msat_hu_conv;
        }
    }

    public static final class PaymentFailed
    extends Event {
        public final byte[] payment_id;
        public final Option_ThirtyTwoBytesZ payment_hash;
        public final Option_PaymentFailureReasonZ reason;

        private PaymentFailed(long ptr, bindings.LDKEvent.PaymentFailed obj) {
            super(null, ptr);
            this.payment_id = obj.payment_id;
            long payment_hash = obj.payment_hash;
            Option_ThirtyTwoBytesZ payment_hash_hu_conv = Option_ThirtyTwoBytesZ.constr_from_ptr(payment_hash);
            if (payment_hash_hu_conv != null) {
                payment_hash_hu_conv.ptrs_to.add(this);
            }
            this.payment_hash = payment_hash_hu_conv;
            long reason = obj.reason;
            Option_PaymentFailureReasonZ reason_hu_conv = Option_PaymentFailureReasonZ.constr_from_ptr(reason);
            if (reason_hu_conv != null) {
                reason_hu_conv.ptrs_to.add(this);
            }
            this.reason = reason_hu_conv;
        }
    }

    public static final class PaymentPathSuccessful
    extends Event {
        public final byte[] payment_id;
        public final Option_ThirtyTwoBytesZ payment_hash;
        public final Path path;

        private PaymentPathSuccessful(long ptr, bindings.LDKEvent.PaymentPathSuccessful obj) {
            super(null, ptr);
            this.payment_id = obj.payment_id;
            long payment_hash = obj.payment_hash;
            Option_ThirtyTwoBytesZ payment_hash_hu_conv = Option_ThirtyTwoBytesZ.constr_from_ptr(payment_hash);
            if (payment_hash_hu_conv != null) {
                payment_hash_hu_conv.ptrs_to.add(this);
            }
            this.payment_hash = payment_hash_hu_conv;
            long path = obj.path;
            Path path_hu_conv = null;
            if (path < 0L || path > 4096L) {
                path_hu_conv = new Path(null, path);
            }
            if (path_hu_conv != null) {
                path_hu_conv.ptrs_to.add(this);
            }
            this.path = path_hu_conv;
        }
    }

    public static final class PaymentPathFailed
    extends Event {
        public final Option_ThirtyTwoBytesZ payment_id;
        public final byte[] payment_hash;
        public final boolean payment_failed_permanently;
        public final PathFailure failure;
        public final Path path;
        public final Option_u64Z short_channel_id;

        private PaymentPathFailed(long ptr, bindings.LDKEvent.PaymentPathFailed obj) {
            super(null, ptr);
            long payment_id = obj.payment_id;
            Option_ThirtyTwoBytesZ payment_id_hu_conv = Option_ThirtyTwoBytesZ.constr_from_ptr(payment_id);
            if (payment_id_hu_conv != null) {
                payment_id_hu_conv.ptrs_to.add(this);
            }
            this.payment_id = payment_id_hu_conv;
            this.payment_hash = obj.payment_hash;
            this.payment_failed_permanently = obj.payment_failed_permanently;
            long failure = obj.failure;
            PathFailure failure_hu_conv = PathFailure.constr_from_ptr(failure);
            if (failure_hu_conv != null) {
                failure_hu_conv.ptrs_to.add(this);
            }
            this.failure = failure_hu_conv;
            long path = obj.path;
            Path path_hu_conv = null;
            if (path < 0L || path > 4096L) {
                path_hu_conv = new Path(null, path);
            }
            if (path_hu_conv != null) {
                path_hu_conv.ptrs_to.add(this);
            }
            this.path = path_hu_conv;
            long short_channel_id = obj.short_channel_id;
            Option_u64Z short_channel_id_hu_conv = Option_u64Z.constr_from_ptr(short_channel_id);
            if (short_channel_id_hu_conv != null) {
                short_channel_id_hu_conv.ptrs_to.add(this);
            }
            this.short_channel_id = short_channel_id_hu_conv;
        }
    }

    public static final class ProbeSuccessful
    extends Event {
        public final byte[] payment_id;
        public final byte[] payment_hash;
        public final Path path;

        private ProbeSuccessful(long ptr, bindings.LDKEvent.ProbeSuccessful obj) {
            super(null, ptr);
            this.payment_id = obj.payment_id;
            this.payment_hash = obj.payment_hash;
            long path = obj.path;
            Path path_hu_conv = null;
            if (path < 0L || path > 4096L) {
                path_hu_conv = new Path(null, path);
            }
            if (path_hu_conv != null) {
                path_hu_conv.ptrs_to.add(this);
            }
            this.path = path_hu_conv;
        }
    }

    public static final class ProbeFailed
    extends Event {
        public final byte[] payment_id;
        public final byte[] payment_hash;
        public final Path path;
        public final Option_u64Z short_channel_id;

        private ProbeFailed(long ptr, bindings.LDKEvent.ProbeFailed obj) {
            super(null, ptr);
            this.payment_id = obj.payment_id;
            this.payment_hash = obj.payment_hash;
            long path = obj.path;
            Path path_hu_conv = null;
            if (path < 0L || path > 4096L) {
                path_hu_conv = new Path(null, path);
            }
            if (path_hu_conv != null) {
                path_hu_conv.ptrs_to.add(this);
            }
            this.path = path_hu_conv;
            long short_channel_id = obj.short_channel_id;
            Option_u64Z short_channel_id_hu_conv = Option_u64Z.constr_from_ptr(short_channel_id);
            if (short_channel_id_hu_conv != null) {
                short_channel_id_hu_conv.ptrs_to.add(this);
            }
            this.short_channel_id = short_channel_id_hu_conv;
        }
    }

    public static final class PendingHTLCsForwardable
    extends Event {
        public final long time_forwardable;

        private PendingHTLCsForwardable(long ptr, bindings.LDKEvent.PendingHTLCsForwardable obj) {
            super(null, ptr);
            this.time_forwardable = obj.time_forwardable;
        }
    }

    public static final class HTLCIntercepted
    extends Event {
        public final byte[] intercept_id;
        public final long requested_next_hop_scid;
        public final byte[] payment_hash;
        public final long inbound_amount_msat;
        public final long expected_outbound_amount_msat;

        private HTLCIntercepted(long ptr, bindings.LDKEvent.HTLCIntercepted obj) {
            super(null, ptr);
            this.intercept_id = obj.intercept_id;
            this.requested_next_hop_scid = obj.requested_next_hop_scid;
            this.payment_hash = obj.payment_hash;
            this.inbound_amount_msat = obj.inbound_amount_msat;
            this.expected_outbound_amount_msat = obj.expected_outbound_amount_msat;
        }
    }

    public static final class SpendableOutputs
    extends Event {
        public final SpendableOutputDescriptor[] outputs;
        @Nullable
        public final ChannelId channel_id;

        private SpendableOutputs(long ptr, bindings.LDKEvent.SpendableOutputs obj) {
            super(null, ptr);
            long[] outputs = obj.outputs;
            int outputs_conv_27_len = outputs.length;
            SpendableOutputDescriptor[] outputs_conv_27_arr = new SpendableOutputDescriptor[outputs_conv_27_len];
            for (int b = 0; b < outputs_conv_27_len; ++b) {
                long outputs_conv_27 = outputs[b];
                SpendableOutputDescriptor outputs_conv_27_hu_conv = SpendableOutputDescriptor.constr_from_ptr(outputs_conv_27);
                if (outputs_conv_27_hu_conv != null) {
                    outputs_conv_27_hu_conv.ptrs_to.add(this);
                }
                outputs_conv_27_arr[b] = outputs_conv_27_hu_conv;
            }
            this.outputs = outputs_conv_27_arr;
            long channel_id = obj.channel_id;
            ChannelId channel_id_hu_conv = null;
            if (channel_id < 0L || channel_id > 4096L) {
                channel_id_hu_conv = new ChannelId(null, channel_id);
            }
            if (channel_id_hu_conv != null) {
                channel_id_hu_conv.ptrs_to.add(this);
            }
            this.channel_id = channel_id_hu_conv;
        }
    }

    public static final class PaymentForwarded
    extends Event {
        @Nullable
        public final ChannelId prev_channel_id;
        @Nullable
        public final ChannelId next_channel_id;
        public final Option_U128Z prev_user_channel_id;
        public final Option_U128Z next_user_channel_id;
        @Nullable
        public final byte[] prev_node_id;
        @Nullable
        public final byte[] next_node_id;
        public final Option_u64Z total_fee_earned_msat;
        public final Option_u64Z skimmed_fee_msat;
        public final boolean claim_from_onchain_tx;
        public final Option_u64Z outbound_amount_forwarded_msat;

        private PaymentForwarded(long ptr, bindings.LDKEvent.PaymentForwarded obj) {
            super(null, ptr);
            long prev_channel_id = obj.prev_channel_id;
            ChannelId prev_channel_id_hu_conv = null;
            if (prev_channel_id < 0L || prev_channel_id > 4096L) {
                prev_channel_id_hu_conv = new ChannelId(null, prev_channel_id);
            }
            if (prev_channel_id_hu_conv != null) {
                prev_channel_id_hu_conv.ptrs_to.add(this);
            }
            this.prev_channel_id = prev_channel_id_hu_conv;
            long next_channel_id = obj.next_channel_id;
            ChannelId next_channel_id_hu_conv = null;
            if (next_channel_id < 0L || next_channel_id > 4096L) {
                next_channel_id_hu_conv = new ChannelId(null, next_channel_id);
            }
            if (next_channel_id_hu_conv != null) {
                next_channel_id_hu_conv.ptrs_to.add(this);
            }
            this.next_channel_id = next_channel_id_hu_conv;
            long prev_user_channel_id = obj.prev_user_channel_id;
            Option_U128Z prev_user_channel_id_hu_conv = Option_U128Z.constr_from_ptr(prev_user_channel_id);
            if (prev_user_channel_id_hu_conv != null) {
                prev_user_channel_id_hu_conv.ptrs_to.add(this);
            }
            this.prev_user_channel_id = prev_user_channel_id_hu_conv;
            long next_user_channel_id = obj.next_user_channel_id;
            Option_U128Z next_user_channel_id_hu_conv = Option_U128Z.constr_from_ptr(next_user_channel_id);
            if (next_user_channel_id_hu_conv != null) {
                next_user_channel_id_hu_conv.ptrs_to.add(this);
            }
            this.next_user_channel_id = next_user_channel_id_hu_conv;
            this.prev_node_id = obj.prev_node_id;
            this.next_node_id = obj.next_node_id;
            long total_fee_earned_msat = obj.total_fee_earned_msat;
            Option_u64Z total_fee_earned_msat_hu_conv = Option_u64Z.constr_from_ptr(total_fee_earned_msat);
            if (total_fee_earned_msat_hu_conv != null) {
                total_fee_earned_msat_hu_conv.ptrs_to.add(this);
            }
            this.total_fee_earned_msat = total_fee_earned_msat_hu_conv;
            long skimmed_fee_msat = obj.skimmed_fee_msat;
            Option_u64Z skimmed_fee_msat_hu_conv = Option_u64Z.constr_from_ptr(skimmed_fee_msat);
            if (skimmed_fee_msat_hu_conv != null) {
                skimmed_fee_msat_hu_conv.ptrs_to.add(this);
            }
            this.skimmed_fee_msat = skimmed_fee_msat_hu_conv;
            this.claim_from_onchain_tx = obj.claim_from_onchain_tx;
            long outbound_amount_forwarded_msat = obj.outbound_amount_forwarded_msat;
            Option_u64Z outbound_amount_forwarded_msat_hu_conv = Option_u64Z.constr_from_ptr(outbound_amount_forwarded_msat);
            if (outbound_amount_forwarded_msat_hu_conv != null) {
                outbound_amount_forwarded_msat_hu_conv.ptrs_to.add(this);
            }
            this.outbound_amount_forwarded_msat = outbound_amount_forwarded_msat_hu_conv;
        }
    }

    public static final class ChannelPending
    extends Event {
        public final ChannelId channel_id;
        public final UInt128 user_channel_id;
        @Nullable
        public final ChannelId former_temporary_channel_id;
        public final byte[] counterparty_node_id;
        public final OutPoint funding_txo;
        @Nullable
        public final ChannelTypeFeatures channel_type;

        private ChannelPending(long ptr, bindings.LDKEvent.ChannelPending obj) {
            super(null, ptr);
            UInt128 user_channel_id_conv;
            long channel_id = obj.channel_id;
            ChannelId channel_id_hu_conv = null;
            if (channel_id < 0L || channel_id > 4096L) {
                channel_id_hu_conv = new ChannelId(null, channel_id);
            }
            if (channel_id_hu_conv != null) {
                channel_id_hu_conv.ptrs_to.add(this);
            }
            this.channel_id = channel_id_hu_conv;
            byte[] user_channel_id = obj.user_channel_id;
            this.user_channel_id = user_channel_id_conv = new UInt128(user_channel_id);
            long former_temporary_channel_id = obj.former_temporary_channel_id;
            ChannelId former_temporary_channel_id_hu_conv = null;
            if (former_temporary_channel_id < 0L || former_temporary_channel_id > 4096L) {
                former_temporary_channel_id_hu_conv = new ChannelId(null, former_temporary_channel_id);
            }
            if (former_temporary_channel_id_hu_conv != null) {
                former_temporary_channel_id_hu_conv.ptrs_to.add(this);
            }
            this.former_temporary_channel_id = former_temporary_channel_id_hu_conv;
            this.counterparty_node_id = obj.counterparty_node_id;
            long funding_txo = obj.funding_txo;
            OutPoint funding_txo_hu_conv = null;
            if (funding_txo < 0L || funding_txo > 4096L) {
                funding_txo_hu_conv = new OutPoint(null, funding_txo);
            }
            if (funding_txo_hu_conv != null) {
                funding_txo_hu_conv.ptrs_to.add(this);
            }
            this.funding_txo = funding_txo_hu_conv;
            long channel_type = obj.channel_type;
            ChannelTypeFeatures channel_type_hu_conv = null;
            if (channel_type < 0L || channel_type > 4096L) {
                channel_type_hu_conv = new ChannelTypeFeatures(null, channel_type);
            }
            if (channel_type_hu_conv != null) {
                channel_type_hu_conv.ptrs_to.add(this);
            }
            this.channel_type = channel_type_hu_conv;
        }
    }

    public static final class ChannelReady
    extends Event {
        public final ChannelId channel_id;
        public final UInt128 user_channel_id;
        public final byte[] counterparty_node_id;
        public final ChannelTypeFeatures channel_type;

        private ChannelReady(long ptr, bindings.LDKEvent.ChannelReady obj) {
            super(null, ptr);
            UInt128 user_channel_id_conv;
            long channel_id = obj.channel_id;
            ChannelId channel_id_hu_conv = null;
            if (channel_id < 0L || channel_id > 4096L) {
                channel_id_hu_conv = new ChannelId(null, channel_id);
            }
            if (channel_id_hu_conv != null) {
                channel_id_hu_conv.ptrs_to.add(this);
            }
            this.channel_id = channel_id_hu_conv;
            byte[] user_channel_id = obj.user_channel_id;
            this.user_channel_id = user_channel_id_conv = new UInt128(user_channel_id);
            this.counterparty_node_id = obj.counterparty_node_id;
            long channel_type = obj.channel_type;
            ChannelTypeFeatures channel_type_hu_conv = null;
            if (channel_type < 0L || channel_type > 4096L) {
                channel_type_hu_conv = new ChannelTypeFeatures(null, channel_type);
            }
            if (channel_type_hu_conv != null) {
                channel_type_hu_conv.ptrs_to.add(this);
            }
            this.channel_type = channel_type_hu_conv;
        }
    }

    public static final class ChannelClosed
    extends Event {
        public final ChannelId channel_id;
        public final UInt128 user_channel_id;
        public final ClosureReason reason;
        @Nullable
        public final byte[] counterparty_node_id;
        public final Option_u64Z channel_capacity_sats;
        @Nullable
        public final OutPoint channel_funding_txo;
        public final Option_u64Z last_local_balance_msat;

        private ChannelClosed(long ptr, bindings.LDKEvent.ChannelClosed obj) {
            super(null, ptr);
            UInt128 user_channel_id_conv;
            long channel_id = obj.channel_id;
            ChannelId channel_id_hu_conv = null;
            if (channel_id < 0L || channel_id > 4096L) {
                channel_id_hu_conv = new ChannelId(null, channel_id);
            }
            if (channel_id_hu_conv != null) {
                channel_id_hu_conv.ptrs_to.add(this);
            }
            this.channel_id = channel_id_hu_conv;
            byte[] user_channel_id = obj.user_channel_id;
            this.user_channel_id = user_channel_id_conv = new UInt128(user_channel_id);
            long reason = obj.reason;
            ClosureReason reason_hu_conv = ClosureReason.constr_from_ptr(reason);
            if (reason_hu_conv != null) {
                reason_hu_conv.ptrs_to.add(this);
            }
            this.reason = reason_hu_conv;
            this.counterparty_node_id = obj.counterparty_node_id;
            long channel_capacity_sats = obj.channel_capacity_sats;
            Option_u64Z channel_capacity_sats_hu_conv = Option_u64Z.constr_from_ptr(channel_capacity_sats);
            if (channel_capacity_sats_hu_conv != null) {
                channel_capacity_sats_hu_conv.ptrs_to.add(this);
            }
            this.channel_capacity_sats = channel_capacity_sats_hu_conv;
            long channel_funding_txo = obj.channel_funding_txo;
            OutPoint channel_funding_txo_hu_conv = null;
            if (channel_funding_txo < 0L || channel_funding_txo > 4096L) {
                channel_funding_txo_hu_conv = new OutPoint(null, channel_funding_txo);
            }
            if (channel_funding_txo_hu_conv != null) {
                channel_funding_txo_hu_conv.ptrs_to.add(this);
            }
            this.channel_funding_txo = channel_funding_txo_hu_conv;
            long last_local_balance_msat = obj.last_local_balance_msat;
            Option_u64Z last_local_balance_msat_hu_conv = Option_u64Z.constr_from_ptr(last_local_balance_msat);
            if (last_local_balance_msat_hu_conv != null) {
                last_local_balance_msat_hu_conv.ptrs_to.add(this);
            }
            this.last_local_balance_msat = last_local_balance_msat_hu_conv;
        }
    }

    public static final class DiscardFunding
    extends Event {
        public final ChannelId channel_id;
        public final FundingInfo funding_info;

        private DiscardFunding(long ptr, bindings.LDKEvent.DiscardFunding obj) {
            super(null, ptr);
            long channel_id = obj.channel_id;
            ChannelId channel_id_hu_conv = null;
            if (channel_id < 0L || channel_id > 4096L) {
                channel_id_hu_conv = new ChannelId(null, channel_id);
            }
            if (channel_id_hu_conv != null) {
                channel_id_hu_conv.ptrs_to.add(this);
            }
            this.channel_id = channel_id_hu_conv;
            long funding_info = obj.funding_info;
            FundingInfo funding_info_hu_conv = FundingInfo.constr_from_ptr(funding_info);
            if (funding_info_hu_conv != null) {
                funding_info_hu_conv.ptrs_to.add(this);
            }
            this.funding_info = funding_info_hu_conv;
        }
    }

    public static final class OpenChannelRequest
    extends Event {
        public final ChannelId temporary_channel_id;
        public final byte[] counterparty_node_id;
        public final long funding_satoshis;
        public final InboundChannelFunds channel_negotiation_type;
        public final ChannelTypeFeatures channel_type;
        public final boolean is_announced;
        public final ChannelParameters params;

        private OpenChannelRequest(long ptr, bindings.LDKEvent.OpenChannelRequest obj) {
            super(null, ptr);
            long temporary_channel_id = obj.temporary_channel_id;
            ChannelId temporary_channel_id_hu_conv = null;
            if (temporary_channel_id < 0L || temporary_channel_id > 4096L) {
                temporary_channel_id_hu_conv = new ChannelId(null, temporary_channel_id);
            }
            if (temporary_channel_id_hu_conv != null) {
                temporary_channel_id_hu_conv.ptrs_to.add(this);
            }
            this.temporary_channel_id = temporary_channel_id_hu_conv;
            this.counterparty_node_id = obj.counterparty_node_id;
            this.funding_satoshis = obj.funding_satoshis;
            long channel_negotiation_type = obj.channel_negotiation_type;
            InboundChannelFunds channel_negotiation_type_hu_conv = InboundChannelFunds.constr_from_ptr(channel_negotiation_type);
            if (channel_negotiation_type_hu_conv != null) {
                channel_negotiation_type_hu_conv.ptrs_to.add(this);
            }
            this.channel_negotiation_type = channel_negotiation_type_hu_conv;
            long channel_type = obj.channel_type;
            ChannelTypeFeatures channel_type_hu_conv = null;
            if (channel_type < 0L || channel_type > 4096L) {
                channel_type_hu_conv = new ChannelTypeFeatures(null, channel_type);
            }
            if (channel_type_hu_conv != null) {
                channel_type_hu_conv.ptrs_to.add(this);
            }
            this.channel_type = channel_type_hu_conv;
            this.is_announced = obj.is_announced;
            long params = obj.params;
            ChannelParameters params_hu_conv = null;
            if (params < 0L || params > 4096L) {
                params_hu_conv = new ChannelParameters(null, params);
            }
            if (params_hu_conv != null) {
                params_hu_conv.ptrs_to.add(this);
            }
            this.params = params_hu_conv;
        }
    }

    public static final class HTLCHandlingFailed
    extends Event {
        public final ChannelId prev_channel_id;
        public final HTLCDestination failed_next_destination;

        private HTLCHandlingFailed(long ptr, bindings.LDKEvent.HTLCHandlingFailed obj) {
            super(null, ptr);
            long prev_channel_id = obj.prev_channel_id;
            ChannelId prev_channel_id_hu_conv = null;
            if (prev_channel_id < 0L || prev_channel_id > 4096L) {
                prev_channel_id_hu_conv = new ChannelId(null, prev_channel_id);
            }
            if (prev_channel_id_hu_conv != null) {
                prev_channel_id_hu_conv.ptrs_to.add(this);
            }
            this.prev_channel_id = prev_channel_id_hu_conv;
            long failed_next_destination = obj.failed_next_destination;
            HTLCDestination failed_next_destination_hu_conv = HTLCDestination.constr_from_ptr(failed_next_destination);
            if (failed_next_destination_hu_conv != null) {
                failed_next_destination_hu_conv.ptrs_to.add(this);
            }
            this.failed_next_destination = failed_next_destination_hu_conv;
        }
    }

    public static final class BumpTransaction
    extends Event {
        public final BumpTransactionEvent bump_transaction;

        private BumpTransaction(long ptr, bindings.LDKEvent.BumpTransaction obj) {
            super(null, ptr);
            long bump_transaction = obj.bump_transaction;
            BumpTransactionEvent bump_transaction_hu_conv = BumpTransactionEvent.constr_from_ptr(bump_transaction);
            if (bump_transaction_hu_conv != null) {
                bump_transaction_hu_conv.ptrs_to.add(this);
            }
            this.bump_transaction = bump_transaction_hu_conv;
        }
    }

    public static final class OnionMessageIntercepted
    extends Event {
        public final byte[] peer_node_id;
        public final OnionMessage message;

        private OnionMessageIntercepted(long ptr, bindings.LDKEvent.OnionMessageIntercepted obj) {
            super(null, ptr);
            this.peer_node_id = obj.peer_node_id;
            long message = obj.message;
            OnionMessage message_hu_conv = null;
            if (message < 0L || message > 4096L) {
                message_hu_conv = new OnionMessage(null, message);
            }
            if (message_hu_conv != null) {
                message_hu_conv.ptrs_to.add(this);
            }
            this.message = message_hu_conv;
        }
    }

    public static final class OnionMessagePeerConnected
    extends Event {
        public final byte[] peer_node_id;

        private OnionMessagePeerConnected(long ptr, bindings.LDKEvent.OnionMessagePeerConnected obj) {
            super(null, ptr);
            this.peer_node_id = obj.peer_node_id;
        }
    }
}

