/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.util.InternalUtils;
import org.ldk.util.WitnessVersion;

public class Fallback
extends CommonBase {
    private Fallback(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.Fallback_free(this.ptr);
        }
    }

    static Fallback constr_from_ptr(long ptr) {
        bindings.LDKFallback raw_val = bindings.LDKFallback_ref_from_ptr(ptr);
        if (raw_val.getClass() == bindings.LDKFallback.SegWitProgram.class) {
            return new SegWitProgram(ptr, (bindings.LDKFallback.SegWitProgram)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKFallback.PubKeyHash.class) {
            return new PubKeyHash(ptr, (bindings.LDKFallback.PubKeyHash)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKFallback.ScriptHash.class) {
            return new ScriptHash(ptr, (bindings.LDKFallback.ScriptHash)raw_val);
        }
        assert (false);
        return null;
    }

    long clone_ptr() {
        long ret = bindings.Fallback_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public Fallback clone() {
        long ret = bindings.Fallback_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Fallback ret_hu_conv = Fallback.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static Fallback seg_wit_program(WitnessVersion version2, byte[] program) {
        long ret = bindings.Fallback_seg_wit_program(version2.getVal(), program);
        Reference.reachabilityFence(version2);
        Reference.reachabilityFence(program);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Fallback ret_hu_conv = Fallback.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Fallback pub_key_hash(byte[] a) {
        long ret = bindings.Fallback_pub_key_hash(InternalUtils.check_arr_len(a, 20));
        Reference.reachabilityFence(a);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Fallback ret_hu_conv = Fallback.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static Fallback script_hash(byte[] a) {
        long ret = bindings.Fallback_script_hash(InternalUtils.check_arr_len(a, 20));
        Reference.reachabilityFence(a);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Fallback ret_hu_conv = Fallback.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public long hash() {
        long ret = bindings.Fallback_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public int hashCode() {
        return (int)this.hash();
    }

    public boolean eq(Fallback b) {
        boolean ret = bindings.Fallback_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Fallback)) {
            return false;
        }
        return this.eq((Fallback)o);
    }

    public static final class SegWitProgram
    extends Fallback {
        public final WitnessVersion version;
        public final byte[] program;

        private SegWitProgram(long ptr, bindings.LDKFallback.SegWitProgram obj) {
            super(null, ptr);
            WitnessVersion version_conv;
            byte version2 = obj.version;
            this.version = version_conv = new WitnessVersion(version2);
            this.program = obj.program;
        }
    }

    public static final class PubKeyHash
    extends Fallback {
        public final byte[] pub_key_hash;

        private PubKeyHash(long ptr, bindings.LDKFallback.PubKeyHash obj) {
            super(null, ptr);
            this.pub_key_hash = obj.pub_key_hash;
        }
    }

    public static final class ScriptHash
    extends Fallback {
        public final byte[] script_hash;

        private ScriptHash(long ptr, bindings.LDKFallback.ScriptHash obj) {
            super(null, ptr);
            this.script_hash = obj.script_hash;
        }
    }
}

