/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.ChannelDerivationParameters;
import org.ldk.structs.CommonBase;
import org.ldk.structs.EcdsaChannelSigner;
import org.ldk.structs.HTLCOutputInCommitment;
import org.ldk.structs.Option_ThirtyTwoBytesZ;
import org.ldk.structs.OutPoint;
import org.ldk.structs.Result_HTLCDescriptorDecodeErrorZ;
import org.ldk.structs.SignerProvider;
import org.ldk.structs.TxIn;
import org.ldk.structs.TxOut;
import org.ldk.util.InternalUtils;

public class HTLCDescriptor
extends CommonBase {
    HTLCDescriptor(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.HTLCDescriptor_free(this.ptr);
        }
    }

    public ChannelDerivationParameters get_channel_derivation_parameters() {
        long ret = bindings.HTLCDescriptor_get_channel_derivation_parameters(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelDerivationParameters ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelDerivationParameters(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_channel_derivation_parameters(ChannelDerivationParameters val) {
        bindings.HTLCDescriptor_set_channel_derivation_parameters(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_commitment_txid() {
        byte[] ret = bindings.HTLCDescriptor_get_commitment_txid(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_commitment_txid(byte[] val) {
        bindings.HTLCDescriptor_set_commitment_txid(this.ptr, InternalUtils.check_arr_len(val, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public long get_per_commitment_number() {
        long ret = bindings.HTLCDescriptor_get_per_commitment_number(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_per_commitment_number(long val) {
        bindings.HTLCDescriptor_set_per_commitment_number(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_per_commitment_point() {
        byte[] ret = bindings.HTLCDescriptor_get_per_commitment_point(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_per_commitment_point(byte[] val) {
        bindings.HTLCDescriptor_set_per_commitment_point(this.ptr, InternalUtils.check_arr_len(val, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public int get_feerate_per_kw() {
        int ret = bindings.HTLCDescriptor_get_feerate_per_kw(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_feerate_per_kw(int val) {
        bindings.HTLCDescriptor_set_feerate_per_kw(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public HTLCOutputInCommitment get_htlc() {
        long ret = bindings.HTLCDescriptor_get_htlc(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        HTLCOutputInCommitment ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new HTLCOutputInCommitment(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_htlc(HTLCOutputInCommitment val) {
        bindings.HTLCDescriptor_set_htlc(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_ThirtyTwoBytesZ get_preimage() {
        long ret = bindings.HTLCDescriptor_get_preimage(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_ThirtyTwoBytesZ ret_hu_conv = Option_ThirtyTwoBytesZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_preimage(Option_ThirtyTwoBytesZ val) {
        bindings.HTLCDescriptor_set_preimage(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_counterparty_sig() {
        byte[] ret = bindings.HTLCDescriptor_get_counterparty_sig(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_counterparty_sig(byte[] val) {
        bindings.HTLCDescriptor_set_counterparty_sig(this.ptr, InternalUtils.check_arr_len(val, 64));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public static HTLCDescriptor of(ChannelDerivationParameters channel_derivation_parameters_arg, byte[] commitment_txid_arg, long per_commitment_number_arg, byte[] per_commitment_point_arg, int feerate_per_kw_arg, HTLCOutputInCommitment htlc_arg, Option_ThirtyTwoBytesZ preimage_arg, byte[] counterparty_sig_arg) {
        long ret = bindings.HTLCDescriptor_new(channel_derivation_parameters_arg.ptr, InternalUtils.check_arr_len(commitment_txid_arg, 32), per_commitment_number_arg, InternalUtils.check_arr_len(per_commitment_point_arg, 33), feerate_per_kw_arg, htlc_arg.ptr, preimage_arg.ptr, InternalUtils.check_arr_len(counterparty_sig_arg, 64));
        Reference.reachabilityFence(channel_derivation_parameters_arg);
        Reference.reachabilityFence(commitment_txid_arg);
        Reference.reachabilityFence(per_commitment_number_arg);
        Reference.reachabilityFence(per_commitment_point_arg);
        Reference.reachabilityFence(feerate_per_kw_arg);
        Reference.reachabilityFence(htlc_arg);
        Reference.reachabilityFence(preimage_arg);
        Reference.reachabilityFence(counterparty_sig_arg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        HTLCDescriptor ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new HTLCDescriptor(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    long clone_ptr() {
        long ret = bindings.HTLCDescriptor_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public HTLCDescriptor clone() {
        long ret = bindings.HTLCDescriptor_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        HTLCDescriptor ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new HTLCDescriptor(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public boolean eq(HTLCDescriptor b) {
        boolean ret = bindings.HTLCDescriptor_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        if (this != null) {
            this.ptrs_to.add(b);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof HTLCDescriptor)) {
            return false;
        }
        return this.eq((HTLCDescriptor)o);
    }

    public byte[] write() {
        byte[] ret = bindings.HTLCDescriptor_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_HTLCDescriptorDecodeErrorZ read(byte[] ser) {
        long ret = bindings.HTLCDescriptor_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_HTLCDescriptorDecodeErrorZ ret_hu_conv = Result_HTLCDescriptorDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public OutPoint outpoint() {
        long ret = bindings.HTLCDescriptor_outpoint(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OutPoint ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new OutPoint(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public TxOut previous_utxo() {
        long ret = bindings.HTLCDescriptor_previous_utxo(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        TxOut ret_conv = new TxOut(null, ret);
        return ret_conv;
    }

    public TxIn unsigned_tx_input() {
        long ret = bindings.HTLCDescriptor_unsigned_tx_input(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        TxIn ret_conv = new TxIn(null, ret);
        return ret_conv;
    }

    public TxOut tx_output() {
        long ret = bindings.HTLCDescriptor_tx_output(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        TxOut ret_conv = new TxOut(null, ret);
        return ret_conv;
    }

    public byte[] witness_script() {
        byte[] ret = bindings.HTLCDescriptor_witness_script(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public byte[] tx_input_witness(byte[] signature, byte[] witness_script) {
        byte[] ret = bindings.HTLCDescriptor_tx_input_witness(this.ptr, InternalUtils.check_arr_len(signature, 64), witness_script);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(signature);
        Reference.reachabilityFence(witness_script);
        return ret;
    }

    public EcdsaChannelSigner derive_channel_signer(SignerProvider signer_provider) {
        long ret = bindings.HTLCDescriptor_derive_channel_signer(this.ptr, signer_provider.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(signer_provider);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        EcdsaChannelSigner ret_hu_conv = new EcdsaChannelSigner(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        if (this != null) {
            this.ptrs_to.add(signer_provider);
        }
        return ret_hu_conv;
    }
}

