/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import javax.annotation.Nullable;
import org.ldk.impl.bindings;
import org.ldk.structs.ChannelId;
import org.ldk.structs.CommonBase;
import org.ldk.util.InternalUtils;

public class HTLCDestination
extends CommonBase {
    private HTLCDestination(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.HTLCDestination_free(this.ptr);
        }
    }

    static HTLCDestination constr_from_ptr(long ptr) {
        bindings.LDKHTLCDestination raw_val = bindings.LDKHTLCDestination_ref_from_ptr(ptr);
        if (raw_val.getClass() == bindings.LDKHTLCDestination.NextHopChannel.class) {
            return new NextHopChannel(ptr, (bindings.LDKHTLCDestination.NextHopChannel)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKHTLCDestination.UnknownNextHop.class) {
            return new UnknownNextHop(ptr, (bindings.LDKHTLCDestination.UnknownNextHop)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKHTLCDestination.InvalidForward.class) {
            return new InvalidForward(ptr, (bindings.LDKHTLCDestination.InvalidForward)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKHTLCDestination.InvalidOnion.class) {
            return new InvalidOnion(ptr, (bindings.LDKHTLCDestination.InvalidOnion)raw_val);
        }
        if (raw_val.getClass() == bindings.LDKHTLCDestination.FailedPayment.class) {
            return new FailedPayment(ptr, (bindings.LDKHTLCDestination.FailedPayment)raw_val);
        }
        assert (false);
        return null;
    }

    long clone_ptr() {
        long ret = bindings.HTLCDestination_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public HTLCDestination clone() {
        long ret = bindings.HTLCDestination_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        HTLCDestination ret_hu_conv = HTLCDestination.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static HTLCDestination next_hop_channel(byte[] node_id, ChannelId channel_id) {
        long ret = bindings.HTLCDestination_next_hop_channel(InternalUtils.check_arr_len(node_id, 33), channel_id.ptr);
        Reference.reachabilityFence(node_id);
        Reference.reachabilityFence(channel_id);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        HTLCDestination ret_hu_conv = HTLCDestination.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static HTLCDestination unknown_next_hop(long requested_forward_scid) {
        long ret = bindings.HTLCDestination_unknown_next_hop(requested_forward_scid);
        Reference.reachabilityFence(requested_forward_scid);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        HTLCDestination ret_hu_conv = HTLCDestination.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static HTLCDestination invalid_forward(long requested_forward_scid) {
        long ret = bindings.HTLCDestination_invalid_forward(requested_forward_scid);
        Reference.reachabilityFence(requested_forward_scid);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        HTLCDestination ret_hu_conv = HTLCDestination.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static HTLCDestination invalid_onion() {
        long ret = bindings.HTLCDestination_invalid_onion();
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        HTLCDestination ret_hu_conv = HTLCDestination.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public static HTLCDestination failed_payment(byte[] payment_hash) {
        long ret = bindings.HTLCDestination_failed_payment(InternalUtils.check_arr_len(payment_hash, 32));
        Reference.reachabilityFence(payment_hash);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        HTLCDestination ret_hu_conv = HTLCDestination.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public boolean eq(HTLCDestination b) {
        boolean ret = bindings.HTLCDestination_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof HTLCDestination)) {
            return false;
        }
        return this.eq((HTLCDestination)o);
    }

    public byte[] write() {
        byte[] ret = bindings.HTLCDestination_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static final class NextHopChannel
    extends HTLCDestination {
        @Nullable
        public final byte[] node_id;
        public final ChannelId channel_id;

        private NextHopChannel(long ptr, bindings.LDKHTLCDestination.NextHopChannel obj) {
            super(null, ptr);
            this.node_id = obj.node_id;
            long channel_id = obj.channel_id;
            ChannelId channel_id_hu_conv = null;
            if (channel_id < 0L || channel_id > 4096L) {
                channel_id_hu_conv = new ChannelId(null, channel_id);
            }
            if (channel_id_hu_conv != null) {
                channel_id_hu_conv.ptrs_to.add(this);
            }
            this.channel_id = channel_id_hu_conv;
        }
    }

    public static final class UnknownNextHop
    extends HTLCDestination {
        public final long requested_forward_scid;

        private UnknownNextHop(long ptr, bindings.LDKHTLCDestination.UnknownNextHop obj) {
            super(null, ptr);
            this.requested_forward_scid = obj.requested_forward_scid;
        }
    }

    public static final class InvalidForward
    extends HTLCDestination {
        public final long requested_forward_scid;

        private InvalidForward(long ptr, bindings.LDKHTLCDestination.InvalidForward obj) {
            super(null, ptr);
            this.requested_forward_scid = obj.requested_forward_scid;
        }
    }

    public static final class InvalidOnion
    extends HTLCDestination {
        private InvalidOnion(long ptr, bindings.LDKHTLCDestination.InvalidOnion obj) {
            super(null, ptr);
        }
    }

    public static final class FailedPayment
    extends HTLCDestination {
        public final byte[] payment_hash;

        private FailedPayment(long ptr, bindings.LDKHTLCDestination.FailedPayment obj) {
            super(null, ptr);
            this.payment_hash = obj.payment_hash;
        }
    }
}

