/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Option_u32Z;
import org.ldk.structs.Result_HTLCOutputInCommitmentDecodeErrorZ;
import org.ldk.util.InternalUtils;

public class HTLCOutputInCommitment
extends CommonBase {
    HTLCOutputInCommitment(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.HTLCOutputInCommitment_free(this.ptr);
        }
    }

    public boolean get_offered() {
        boolean ret = bindings.HTLCOutputInCommitment_get_offered(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_offered(boolean val) {
        bindings.HTLCOutputInCommitment_set_offered(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public long get_amount_msat() {
        long ret = bindings.HTLCOutputInCommitment_get_amount_msat(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_amount_msat(long val) {
        bindings.HTLCOutputInCommitment_set_amount_msat(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public int get_cltv_expiry() {
        int ret = bindings.HTLCOutputInCommitment_get_cltv_expiry(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_cltv_expiry(int val) {
        bindings.HTLCOutputInCommitment_set_cltv_expiry(this.ptr, val);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_payment_hash() {
        byte[] ret = bindings.HTLCOutputInCommitment_get_payment_hash(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_payment_hash(byte[] val) {
        bindings.HTLCOutputInCommitment_set_payment_hash(this.ptr, InternalUtils.check_arr_len(val, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public Option_u32Z get_transaction_output_index() {
        long ret = bindings.HTLCOutputInCommitment_get_transaction_output_index(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u32Z ret_hu_conv = Option_u32Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public void set_transaction_output_index(Option_u32Z val) {
        bindings.HTLCOutputInCommitment_set_transaction_output_index(this.ptr, val.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public static HTLCOutputInCommitment of(boolean offered_arg, long amount_msat_arg, int cltv_expiry_arg, byte[] payment_hash_arg, Option_u32Z transaction_output_index_arg) {
        long ret = bindings.HTLCOutputInCommitment_new(offered_arg, amount_msat_arg, cltv_expiry_arg, InternalUtils.check_arr_len(payment_hash_arg, 32), transaction_output_index_arg.ptr);
        Reference.reachabilityFence(offered_arg);
        Reference.reachabilityFence(amount_msat_arg);
        Reference.reachabilityFence(cltv_expiry_arg);
        Reference.reachabilityFence(payment_hash_arg);
        Reference.reachabilityFence(transaction_output_index_arg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        HTLCOutputInCommitment ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new HTLCOutputInCommitment(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    long clone_ptr() {
        long ret = bindings.HTLCOutputInCommitment_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public HTLCOutputInCommitment clone() {
        long ret = bindings.HTLCOutputInCommitment_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        HTLCOutputInCommitment ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new HTLCOutputInCommitment(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public boolean eq(HTLCOutputInCommitment b) {
        boolean ret = bindings.HTLCOutputInCommitment_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        if (this != null) {
            this.ptrs_to.add(b);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof HTLCOutputInCommitment)) {
            return false;
        }
        return this.eq((HTLCOutputInCommitment)o);
    }

    public long to_bitcoin_amount() {
        long ret = bindings.HTLCOutputInCommitment_to_bitcoin_amount(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public byte[] write() {
        byte[] ret = bindings.HTLCOutputInCommitment_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_HTLCOutputInCommitmentDecodeErrorZ read(byte[] ser) {
        long ret = bindings.HTLCOutputInCommitment_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_HTLCOutputInCommitmentDecodeErrorZ ret_hu_conv = Result_HTLCOutputInCommitmentDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }
}

