/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.HtlcBasepoint;
import org.ldk.structs.Result_HtlcKeyDecodeErrorZ;
import org.ldk.util.InternalUtils;

public class HtlcKey
extends CommonBase {
    HtlcKey(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.HtlcKey_free(this.ptr);
        }
    }

    public byte[] get_a() {
        byte[] ret = bindings.HtlcKey_get_a(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_a(byte[] val) {
        bindings.HtlcKey_set_a(this.ptr, InternalUtils.check_arr_len(val, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public static HtlcKey of(byte[] a_arg) {
        long ret = bindings.HtlcKey_new(InternalUtils.check_arr_len(a_arg, 33));
        Reference.reachabilityFence(a_arg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        HtlcKey ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new HtlcKey(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public boolean eq(HtlcKey b) {
        boolean ret = bindings.HtlcKey_eq(this.ptr, b.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(b);
        if (this != null) {
            this.ptrs_to.add(b);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof HtlcKey)) {
            return false;
        }
        return this.eq((HtlcKey)o);
    }

    long clone_ptr() {
        long ret = bindings.HtlcKey_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public HtlcKey clone() {
        long ret = bindings.HtlcKey_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        HtlcKey ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new HtlcKey(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static HtlcKey from_basepoint(HtlcBasepoint countersignatory_basepoint, byte[] per_commitment_point) {
        long ret = bindings.HtlcKey_from_basepoint(countersignatory_basepoint.ptr, InternalUtils.check_arr_len(per_commitment_point, 33));
        Reference.reachabilityFence(countersignatory_basepoint);
        Reference.reachabilityFence(per_commitment_point);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        HtlcKey ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new HtlcKey(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(countersignatory_basepoint);
        }
        return ret_hu_conv;
    }

    public static HtlcKey from_secret_key(byte[] sk) {
        long ret = bindings.HtlcKey_from_secret_key(InternalUtils.check_arr_len(sk, 32));
        Reference.reachabilityFence(sk);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        HtlcKey ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new HtlcKey(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public byte[] to_public_key() {
        byte[] ret = bindings.HtlcKey_to_public_key(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public byte[] write() {
        byte[] ret = bindings.HtlcKey_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_HtlcKeyDecodeErrorZ read(byte[] ser) {
        long ret = bindings.HtlcKey_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_HtlcKeyDecodeErrorZ ret_hu_conv = Result_HtlcKeyDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }
}

