/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.NodeId;
import org.ldk.structs.Option_u64Z;
import org.ldk.structs.Path;
import org.ldk.structs.Result_InFlightHtlcsDecodeErrorZ;
import org.ldk.util.InternalUtils;

public class InFlightHtlcs
extends CommonBase {
    InFlightHtlcs(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.InFlightHtlcs_free(this.ptr);
        }
    }

    long clone_ptr() {
        long ret = bindings.InFlightHtlcs_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public InFlightHtlcs clone() {
        long ret = bindings.InFlightHtlcs_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        InFlightHtlcs ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new InFlightHtlcs(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static InFlightHtlcs of() {
        long ret = bindings.InFlightHtlcs_new();
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        InFlightHtlcs ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new InFlightHtlcs(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    public void process_path(Path path, byte[] payer_node_id) {
        bindings.InFlightHtlcs_process_path(this.ptr, path.ptr, InternalUtils.check_arr_len(payer_node_id, 33));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(path);
        Reference.reachabilityFence(payer_node_id);
        if (this != null) {
            this.ptrs_to.add(path);
        }
    }

    public void add_inflight_htlc(NodeId source, NodeId target, long channel_scid, long used_msat) {
        bindings.InFlightHtlcs_add_inflight_htlc(this.ptr, source.ptr, target.ptr, channel_scid, used_msat);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(source);
        Reference.reachabilityFence(target);
        Reference.reachabilityFence(channel_scid);
        Reference.reachabilityFence(used_msat);
        if (this != null) {
            this.ptrs_to.add(source);
        }
        if (this != null) {
            this.ptrs_to.add(target);
        }
    }

    public Option_u64Z used_liquidity_msat(NodeId source, NodeId target, long channel_scid) {
        long ret = bindings.InFlightHtlcs_used_liquidity_msat(this.ptr, source.ptr, target.ptr, channel_scid);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(source);
        Reference.reachabilityFence(target);
        Reference.reachabilityFence(channel_scid);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u64Z ret_hu_conv = Option_u64Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        if (this != null) {
            this.ptrs_to.add(source);
        }
        if (this != null) {
            this.ptrs_to.add(target);
        }
        return ret_hu_conv;
    }

    public byte[] write() {
        byte[] ret = bindings.InFlightHtlcs_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_InFlightHtlcsDecodeErrorZ read(byte[] ser) {
        long ret = bindings.InFlightHtlcs_read(ser);
        Reference.reachabilityFence(ser);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_InFlightHtlcsDecodeErrorZ ret_hu_conv = Result_InFlightHtlcsDecodeErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }
}

