/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import javax.annotation.Nullable;
import org.ldk.impl.bindings;
import org.ldk.structs.ChannelPublicKeys;
import org.ldk.structs.ChannelSigner;
import org.ldk.structs.ChannelTransactionParameters;
import org.ldk.structs.ChannelTypeFeatures;
import org.ldk.structs.CommonBase;
import org.ldk.structs.DelayedPaymentOutputDescriptor;
import org.ldk.structs.EcdsaChannelSigner;
import org.ldk.structs.EntropySource;
import org.ldk.structs.Option_boolZ;
import org.ldk.structs.Option_u16Z;
import org.ldk.structs.OutPoint;
import org.ldk.structs.Result_InMemorySignerDecodeErrorZ;
import org.ldk.structs.Result_WitnessNoneZ;
import org.ldk.structs.StaticPaymentOutputDescriptor;
import org.ldk.util.InternalUtils;

public class InMemorySigner
extends CommonBase {
    InMemorySigner(Object _dummy, long ptr) {
        super(ptr);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.ptr != 0L) {
            bindings.InMemorySigner_free(this.ptr);
        }
    }

    public byte[] get_funding_key() {
        byte[] ret = bindings.InMemorySigner_get_funding_key(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_funding_key(byte[] val) {
        bindings.InMemorySigner_set_funding_key(this.ptr, InternalUtils.check_arr_len(val, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_revocation_base_key() {
        byte[] ret = bindings.InMemorySigner_get_revocation_base_key(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_revocation_base_key(byte[] val) {
        bindings.InMemorySigner_set_revocation_base_key(this.ptr, InternalUtils.check_arr_len(val, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_payment_key() {
        byte[] ret = bindings.InMemorySigner_get_payment_key(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_payment_key(byte[] val) {
        bindings.InMemorySigner_set_payment_key(this.ptr, InternalUtils.check_arr_len(val, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_delayed_payment_base_key() {
        byte[] ret = bindings.InMemorySigner_get_delayed_payment_base_key(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_delayed_payment_base_key(byte[] val) {
        bindings.InMemorySigner_set_delayed_payment_base_key(this.ptr, InternalUtils.check_arr_len(val, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_htlc_base_key() {
        byte[] ret = bindings.InMemorySigner_get_htlc_base_key(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_htlc_base_key(byte[] val) {
        bindings.InMemorySigner_set_htlc_base_key(this.ptr, InternalUtils.check_arr_len(val, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    public byte[] get_commitment_seed() {
        byte[] ret = bindings.InMemorySigner_get_commitment_seed(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public void set_commitment_seed(byte[] val) {
        bindings.InMemorySigner_set_commitment_seed(this.ptr, InternalUtils.check_arr_len(val, 32));
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(val);
    }

    long clone_ptr() {
        long ret = bindings.InMemorySigner_clone_ptr(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public InMemorySigner clone() {
        long ret = bindings.InMemorySigner_clone(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        InMemorySigner ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new InMemorySigner(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public static InMemorySigner of(byte[] funding_key, byte[] revocation_base_key, byte[] payment_key, byte[] delayed_payment_base_key, byte[] htlc_base_key, byte[] commitment_seed, long channel_value_satoshis, byte[] channel_keys_id, byte[] rand_bytes_unique_start) {
        long ret = bindings.InMemorySigner_new(InternalUtils.check_arr_len(funding_key, 32), InternalUtils.check_arr_len(revocation_base_key, 32), InternalUtils.check_arr_len(payment_key, 32), InternalUtils.check_arr_len(delayed_payment_base_key, 32), InternalUtils.check_arr_len(htlc_base_key, 32), InternalUtils.check_arr_len(commitment_seed, 32), channel_value_satoshis, InternalUtils.check_arr_len(channel_keys_id, 32), InternalUtils.check_arr_len(rand_bytes_unique_start, 32));
        Reference.reachabilityFence(funding_key);
        Reference.reachabilityFence(revocation_base_key);
        Reference.reachabilityFence(payment_key);
        Reference.reachabilityFence(delayed_payment_base_key);
        Reference.reachabilityFence(htlc_base_key);
        Reference.reachabilityFence(commitment_seed);
        Reference.reachabilityFence(channel_value_satoshis);
        Reference.reachabilityFence(channel_keys_id);
        Reference.reachabilityFence(rand_bytes_unique_start);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        InMemorySigner ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new InMemorySigner(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(ret_hu_conv);
        }
        return ret_hu_conv;
    }

    @Nullable
    public ChannelPublicKeys counterparty_pubkeys() {
        long ret = bindings.InMemorySigner_counterparty_pubkeys(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelPublicKeys ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelPublicKeys(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Option_u16Z counterparty_selected_contest_delay() {
        long ret = bindings.InMemorySigner_counterparty_selected_contest_delay(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u16Z ret_hu_conv = Option_u16Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Option_u16Z holder_selected_contest_delay() {
        long ret = bindings.InMemorySigner_holder_selected_contest_delay(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_u16Z ret_hu_conv = Option_u16Z.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Option_boolZ is_outbound() {
        long ret = bindings.InMemorySigner_is_outbound(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Option_boolZ ret_hu_conv = Option_boolZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    @Nullable
    public OutPoint funding_outpoint() {
        long ret = bindings.InMemorySigner_funding_outpoint(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        OutPoint ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new OutPoint(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    @Nullable
    public ChannelTransactionParameters get_channel_parameters() {
        long ret = bindings.InMemorySigner_get_channel_parameters(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelTransactionParameters ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelTransactionParameters(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    @Nullable
    public ChannelTypeFeatures channel_type_features() {
        long ret = bindings.InMemorySigner_channel_type_features(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelTypeFeatures ret_hu_conv = null;
        if (ret < 0L || ret > 4096L) {
            ret_hu_conv = new ChannelTypeFeatures(null, ret);
        }
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public Result_WitnessNoneZ sign_counterparty_payment_input(byte[] spend_tx, long input_idx, StaticPaymentOutputDescriptor descriptor) {
        long ret = bindings.InMemorySigner_sign_counterparty_payment_input(this.ptr, spend_tx, input_idx, descriptor.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(spend_tx);
        Reference.reachabilityFence(input_idx);
        Reference.reachabilityFence(descriptor);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_WitnessNoneZ ret_hu_conv = Result_WitnessNoneZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(descriptor);
        }
        return ret_hu_conv;
    }

    public Result_WitnessNoneZ sign_dynamic_p2wsh_input(byte[] spend_tx, long input_idx, DelayedPaymentOutputDescriptor descriptor) {
        long ret = bindings.InMemorySigner_sign_dynamic_p2wsh_input(this.ptr, spend_tx, input_idx, descriptor.ptr);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(spend_tx);
        Reference.reachabilityFence(input_idx);
        Reference.reachabilityFence(descriptor);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_WitnessNoneZ ret_hu_conv = Result_WitnessNoneZ.constr_from_ptr(ret);
        if (this != null) {
            this.ptrs_to.add(descriptor);
        }
        return ret_hu_conv;
    }

    public EntropySource as_EntropySource() {
        long ret = bindings.InMemorySigner_as_EntropySource(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        EntropySource ret_hu_conv = new EntropySource(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public ChannelSigner as_ChannelSigner() {
        long ret = bindings.InMemorySigner_as_ChannelSigner(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        ChannelSigner ret_hu_conv = new ChannelSigner(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public EcdsaChannelSigner as_EcdsaChannelSigner() {
        long ret = bindings.InMemorySigner_as_EcdsaChannelSigner(this.ptr);
        Reference.reachabilityFence(this);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        EcdsaChannelSigner ret_hu_conv = new EcdsaChannelSigner(null, ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(this);
        }
        return ret_hu_conv;
    }

    public byte[] write() {
        byte[] ret = bindings.InMemorySigner_write(this.ptr);
        Reference.reachabilityFence(this);
        return ret;
    }

    public static Result_InMemorySignerDecodeErrorZ read(byte[] ser, EntropySource arg) {
        long ret = bindings.InMemorySigner_read(ser, arg.ptr);
        Reference.reachabilityFence(ser);
        Reference.reachabilityFence(arg);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_InMemorySignerDecodeErrorZ ret_hu_conv = Result_InMemorySignerDecodeErrorZ.constr_from_ptr(ret);
        if (ret_hu_conv != null) {
            ret_hu_conv.ptrs_to.add(arg);
        }
        return ret_hu_conv;
    }
}

