/*
 * Decompiled with CFR 0.152.
 */
package org.ldk.structs;

import java.lang.ref.Reference;
import org.ldk.impl.bindings;
import org.ldk.structs.CommonBase;
import org.ldk.structs.Result_CVec_StrZIOErrorZ;
import org.ldk.structs.Result_CVec_u8ZIOErrorZ;
import org.ldk.structs.Result_NoneIOErrorZ;

public class KVStore
extends CommonBase {
    final bindings.LDKKVStore bindings_instance;

    KVStore(Object _dummy, long ptr) {
        super(ptr);
        this.bindings_instance = null;
    }

    private KVStore(bindings.LDKKVStore arg) {
        super(bindings.LDKKVStore_new(arg));
        this.ptrs_to.add(arg);
        this.bindings_instance = arg;
    }

    protected void finalize() throws Throwable {
        if (this.ptr != 0L) {
            bindings.KVStore_free(this.ptr);
        }
        super.finalize();
    }

    public void destroy() {
        if (this.ptr != 0L) {
            bindings.KVStore_free(this.ptr);
        }
        this.ptr = 0L;
    }

    public static KVStore new_impl(final KVStoreInterface arg) {
        LDKKVStoreHolder impl_holder = new LDKKVStoreHolder();
        impl_holder.held = new KVStore(new bindings.LDKKVStore(){

            @Override
            public long read(String primary_namespace, String secondary_namespace, String key) {
                Result_CVec_u8ZIOErrorZ ret = arg.read(primary_namespace, secondary_namespace, key);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long write(String primary_namespace, String secondary_namespace, String key, byte[] buf) {
                Result_NoneIOErrorZ ret = arg.write(primary_namespace, secondary_namespace, key, buf);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long remove(String primary_namespace, String secondary_namespace, String key, boolean lazy) {
                Result_NoneIOErrorZ ret = arg.remove(primary_namespace, secondary_namespace, key, lazy);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }

            @Override
            public long list(String primary_namespace, String secondary_namespace) {
                Result_CVec_StrZIOErrorZ ret = arg.list(primary_namespace, secondary_namespace);
                Reference.reachabilityFence(arg);
                long result = ret.clone_ptr();
                return result;
            }
        });
        return impl_holder.held;
    }

    public Result_CVec_u8ZIOErrorZ read(String primary_namespace, String secondary_namespace, String key) {
        long ret = bindings.KVStore_read(this.ptr, primary_namespace, secondary_namespace, key);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(primary_namespace);
        Reference.reachabilityFence(secondary_namespace);
        Reference.reachabilityFence(key);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_CVec_u8ZIOErrorZ ret_hu_conv = Result_CVec_u8ZIOErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_NoneIOErrorZ write(String primary_namespace, String secondary_namespace, String key, byte[] buf) {
        long ret = bindings.KVStore_write(this.ptr, primary_namespace, secondary_namespace, key, buf);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(primary_namespace);
        Reference.reachabilityFence(secondary_namespace);
        Reference.reachabilityFence(key);
        Reference.reachabilityFence(buf);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneIOErrorZ ret_hu_conv = Result_NoneIOErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_NoneIOErrorZ remove(String primary_namespace, String secondary_namespace, String key, boolean lazy) {
        long ret = bindings.KVStore_remove(this.ptr, primary_namespace, secondary_namespace, key, lazy);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(primary_namespace);
        Reference.reachabilityFence(secondary_namespace);
        Reference.reachabilityFence(key);
        Reference.reachabilityFence(lazy);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_NoneIOErrorZ ret_hu_conv = Result_NoneIOErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    public Result_CVec_StrZIOErrorZ list(String primary_namespace, String secondary_namespace) {
        long ret = bindings.KVStore_list(this.ptr, primary_namespace, secondary_namespace);
        Reference.reachabilityFence(this);
        Reference.reachabilityFence(primary_namespace);
        Reference.reachabilityFence(secondary_namespace);
        if (ret >= 0L && ret <= 4096L) {
            return null;
        }
        Result_CVec_StrZIOErrorZ ret_hu_conv = Result_CVec_StrZIOErrorZ.constr_from_ptr(ret);
        return ret_hu_conv;
    }

    private static class LDKKVStoreHolder {
        KVStore held;

        private LDKKVStoreHolder() {
        }
    }

    public static interface KVStoreInterface {
        public Result_CVec_u8ZIOErrorZ read(String var1, String var2, String var3);

        public Result_NoneIOErrorZ write(String var1, String var2, String var3, byte[] var4);

        public Result_NoneIOErrorZ remove(String var1, String var2, String var3, boolean var4);

        public Result_CVec_StrZIOErrorZ list(String var1, String var2);
    }
}

